/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.telephony.PhoneNumberUtils;
import android.text.Editable;
import android.text.Selection;
import android.text.TextWatcher;
import com.android.i18n.phonenumbers.AsYouTypeFormatter;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import java.util.Locale;

public class PhoneNumberFormattingTextWatcher
implements TextWatcher {
    private boolean mSelfChange = false;
    private boolean mStopFormatting;
    private AsYouTypeFormatter mFormatter;

    public PhoneNumberFormattingTextWatcher() {
        this(Locale.getDefault().getCountry());
    }

    public PhoneNumberFormattingTextWatcher(String countryCode) {
        if (countryCode == null) {
            throw new IllegalArgumentException();
        }
        this.mFormatter = PhoneNumberUtil.getInstance().getAsYouTypeFormatter(countryCode);
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        if (this.mSelfChange || this.mStopFormatting) {
            return;
        }
        if (count > 0 && this.hasSeparator(s, start, count)) {
            this.stopFormatting();
        }
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.mSelfChange || this.mStopFormatting) {
            return;
        }
        if (count > 0 && this.hasSeparator(s, start, count)) {
            this.stopFormatting();
        }
    }

    @Override
    public synchronized void afterTextChanged(Editable s) {
        if (this.mStopFormatting) {
            this.mStopFormatting = s.length() != 0;
            return;
        }
        if (this.mSelfChange) {
            return;
        }
        String formatted = this.reformat(s, Selection.getSelectionEnd(s));
        if (formatted != null) {
            int rememberedPos = this.mFormatter.getRememberedPosition();
            this.mSelfChange = true;
            s.replace(0, s.length(), formatted, 0, formatted.length());
            if (formatted.equals(s.toString())) {
                Selection.setSelection(s, rememberedPos);
            }
            this.mSelfChange = false;
        }
        PhoneNumberUtils.ttsSpanAsPhoneNumber(s, 0, s.length());
    }

    private String reformat(CharSequence s, int cursor) {
        int curIndex = cursor - 1;
        String formatted = null;
        this.mFormatter.clear();
        char lastNonSeparator = '\u0000';
        boolean hasCursor = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (PhoneNumberUtils.isNonSeparator(c)) {
                if (lastNonSeparator != '\u0000') {
                    formatted = this.getFormattedNumber(lastNonSeparator, hasCursor);
                    hasCursor = false;
                }
                lastNonSeparator = c;
            }
            if (i != curIndex) continue;
            hasCursor = true;
        }
        if (lastNonSeparator != '\u0000') {
            formatted = this.getFormattedNumber(lastNonSeparator, hasCursor);
        }
        return formatted;
    }

    private String getFormattedNumber(char lastNonSeparator, boolean hasCursor) {
        return hasCursor ? this.mFormatter.inputDigitAndRememberPosition(lastNonSeparator) : this.mFormatter.inputDigit(lastNonSeparator);
    }

    private void stopFormatting() {
        this.mStopFormatting = true;
        this.mFormatter.clear();
    }

    private boolean hasSeparator(CharSequence s, int start, int count) {
        for (int i = start; i < start + count; ++i) {
            char c = s.charAt(i);
            if (PhoneNumberUtils.isNonSeparator(c)) continue;
            return true;
        }
        return false;
    }
}

