/*
 * Decompiled with CFR 0.152.
 */
package android.system;

import libcore.util.Objects;

public final class StructTimeval {
    public final long tv_sec;
    public final long tv_usec;

    private StructTimeval(long tv_sec, long tv_usec) {
        this.tv_sec = tv_sec;
        this.tv_usec = tv_usec;
    }

    public static StructTimeval fromMillis(long millis) {
        long tv_sec = millis / 1000L;
        long tv_usec = (millis - tv_sec * 1000L) * 1000L;
        return new StructTimeval(tv_sec, tv_usec);
    }

    public long toMillis() {
        return this.tv_sec * 1000L + this.tv_usec / 1000L;
    }

    public String toString() {
        return Objects.toString(this);
    }
}

