/*
 * Decompiled with CFR 0.152.
 */
package android.service.euicc;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import android.service.euicc.GetDefaultDownloadableSubscriptionListResult;
import android.service.euicc.GetDownloadableSubscriptionMetadataResult;
import android.service.euicc.GetEuiccProfileInfoListResult;
import android.service.euicc.IDeleteSubscriptionCallback;
import android.service.euicc.IDownloadSubscriptionCallback;
import android.service.euicc.IEraseSubscriptionsCallback;
import android.service.euicc.IEuiccService;
import android.service.euicc.IGetDefaultDownloadableSubscriptionListCallback;
import android.service.euicc.IGetDownloadableSubscriptionMetadataCallback;
import android.service.euicc.IGetEidCallback;
import android.service.euicc.IGetEuiccInfoCallback;
import android.service.euicc.IGetEuiccProfileInfoListCallback;
import android.service.euicc.IRetainSubscriptionsForFactoryResetCallback;
import android.service.euicc.ISwitchToSubscriptionCallback;
import android.service.euicc.IUpdateSubscriptionNicknameCallback;
import android.telephony.euicc.DownloadableSubscription;
import android.telephony.euicc.EuiccInfo;
import android.util.ArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class EuiccService
extends Service {
    public static final String EUICC_SERVICE_INTERFACE = "android.service.euicc.EuiccService";
    public static final String CATEGORY_EUICC_UI = "android.service.euicc.category.EUICC_UI";
    public static final String ACTION_MANAGE_EMBEDDED_SUBSCRIPTIONS = "android.service.euicc.action.MANAGE_EMBEDDED_SUBSCRIPTIONS";
    public static final String ACTION_PROVISION_EMBEDDED_SUBSCRIPTION = "android.service.euicc.action.PROVISION_EMBEDDED_SUBSCRIPTION";
    public static final String ACTION_RESOLVE_DEACTIVATE_SIM = "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM";
    public static final String ACTION_RESOLVE_NO_PRIVILEGES = "android.service.euicc.action.RESOLVE_NO_PRIVILEGES";
    public static final String EXTRA_RESOLUTION_CALLING_PACKAGE = "android.service.euicc.extra.RESOLUTION_CALLING_PACKAGE";
    public static final int RESULT_OK = 0;
    public static final int RESULT_MUST_DEACTIVATE_SIM = -1;
    public static final int RESULT_FIRST_USER = 1;
    public static final ArraySet<String> RESOLUTION_ACTIONS = new ArraySet();
    public static final String RESOLUTION_EXTRA_CONSENT = "consent";
    private final IEuiccService.Stub mStubWrapper = new IEuiccServiceWrapper();
    private ThreadPoolExecutor mExecutor;

    @Override
    public void onCreate() {
        super.onCreate();
        this.mExecutor = new ThreadPoolExecutor(4, 4, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger mCount = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "EuiccService #" + this.mCount.getAndIncrement());
            }
        });
        this.mExecutor.allowCoreThreadTimeOut(true);
    }

    @Override
    public void onDestroy() {
        this.mExecutor.shutdownNow();
        super.onDestroy();
    }

    @Override
    public IBinder onBind(Intent intent) {
        return this.mStubWrapper;
    }

    public abstract String onGetEid(int var1);

    public abstract GetDownloadableSubscriptionMetadataResult onGetDownloadableSubscriptionMetadata(int var1, DownloadableSubscription var2, boolean var3);

    public abstract GetDefaultDownloadableSubscriptionListResult onGetDefaultDownloadableSubscriptionList(int var1, boolean var2);

    public abstract int onDownloadSubscription(int var1, DownloadableSubscription var2, boolean var3, boolean var4);

    public abstract GetEuiccProfileInfoListResult onGetEuiccProfileInfoList(int var1);

    public abstract EuiccInfo onGetEuiccInfo(int var1);

    public abstract int onDeleteSubscription(int var1, String var2);

    public abstract int onSwitchToSubscription(int var1, String var2, boolean var3);

    public abstract int onUpdateSubscriptionNickname(int var1, String var2, String var3);

    public abstract int onEraseSubscriptions(int var1);

    public abstract int onRetainSubscriptionsForFactoryReset(int var1);

    static {
        RESOLUTION_ACTIONS.add(ACTION_RESOLVE_DEACTIVATE_SIM);
        RESOLUTION_ACTIONS.add(ACTION_RESOLVE_NO_PRIVILEGES);
    }

    private class IEuiccServiceWrapper
    extends IEuiccService.Stub {
        private IEuiccServiceWrapper() {
        }

        @Override
        public void downloadSubscription(final int slotId, final DownloadableSubscription subscription, final boolean switchAfterDownload, final boolean forceDeactivateSim, final IDownloadSubscriptionCallback callback) {
            EuiccService.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    int result = EuiccService.this.onDownloadSubscription(slotId, subscription, switchAfterDownload, forceDeactivateSim);
                    try {
                        callback.onComplete(result);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void getEid(final int slotId, final IGetEidCallback callback) {
            EuiccService.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    String eid = EuiccService.this.onGetEid(slotId);
                    try {
                        callback.onSuccess(eid);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void getDownloadableSubscriptionMetadata(final int slotId, final DownloadableSubscription subscription, final boolean forceDeactivateSim, final IGetDownloadableSubscriptionMetadataCallback callback) {
            EuiccService.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    GetDownloadableSubscriptionMetadataResult result = EuiccService.this.onGetDownloadableSubscriptionMetadata(slotId, subscription, forceDeactivateSim);
                    try {
                        callback.onComplete(result);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void getDefaultDownloadableSubscriptionList(final int slotId, final boolean forceDeactivateSim, final IGetDefaultDownloadableSubscriptionListCallback callback) {
            EuiccService.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    GetDefaultDownloadableSubscriptionListResult result = EuiccService.this.onGetDefaultDownloadableSubscriptionList(slotId, forceDeactivateSim);
                    try {
                        callback.onComplete(result);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void getEuiccProfileInfoList(final int slotId, final IGetEuiccProfileInfoListCallback callback) {
            EuiccService.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    GetEuiccProfileInfoListResult result = EuiccService.this.onGetEuiccProfileInfoList(slotId);
                    try {
                        callback.onComplete(result);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void getEuiccInfo(final int slotId, final IGetEuiccInfoCallback callback) {
            EuiccService.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    EuiccInfo euiccInfo = EuiccService.this.onGetEuiccInfo(slotId);
                    try {
                        callback.onSuccess(euiccInfo);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void deleteSubscription(final int slotId, final String iccid, final IDeleteSubscriptionCallback callback) {
            EuiccService.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    int result = EuiccService.this.onDeleteSubscription(slotId, iccid);
                    try {
                        callback.onComplete(result);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void switchToSubscription(final int slotId, final String iccid, final boolean forceDeactivateSim, final ISwitchToSubscriptionCallback callback) {
            EuiccService.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    int result = EuiccService.this.onSwitchToSubscription(slotId, iccid, forceDeactivateSim);
                    try {
                        callback.onComplete(result);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void updateSubscriptionNickname(final int slotId, final String iccid, final String nickname, final IUpdateSubscriptionNicknameCallback callback) {
            EuiccService.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    int result = EuiccService.this.onUpdateSubscriptionNickname(slotId, iccid, nickname);
                    try {
                        callback.onComplete(result);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void eraseSubscriptions(final int slotId, final IEraseSubscriptionsCallback callback) {
            EuiccService.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    int result = EuiccService.this.onEraseSubscriptions(slotId);
                    try {
                        callback.onComplete(result);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void retainSubscriptionsForFactoryReset(final int slotId, final IRetainSubscriptionsForFactoryResetCallback callback) {
            EuiccService.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    int result = EuiccService.this.onRetainSubscriptionsForFactoryReset(slotId);
                    try {
                        callback.onComplete(result);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

