/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalValidator;
import android.service.autofill.Validator;
import android.service.autofill.ValueFinder;
import android.util.Log;
import android.view.autofill.AutofillId;
import android.view.autofill.Helper;
import com.android.internal.util.Preconditions;
import java.util.regex.Pattern;

public final class RegexValidator
extends InternalValidator
implements Validator,
Parcelable {
    private static final String TAG = "RegexValidator";
    private final AutofillId mId;
    private final Pattern mRegex;
    public static final Parcelable.Creator<RegexValidator> CREATOR = new Parcelable.Creator<RegexValidator>(){

        @Override
        public RegexValidator createFromParcel(Parcel parcel) {
            return new RegexValidator((AutofillId)parcel.readParcelable(null), (Pattern)parcel.readSerializable());
        }

        public RegexValidator[] newArray(int size) {
            return new RegexValidator[size];
        }
    };

    public RegexValidator(AutofillId id2, Pattern regex) {
        this.mId = Preconditions.checkNotNull(id2);
        this.mRegex = Preconditions.checkNotNull(regex);
    }

    @Override
    public boolean isValid(ValueFinder finder) {
        String value = finder.findByAutofillId(this.mId);
        if (value == null) {
            Log.w(TAG, "No view for id " + this.mId);
            return false;
        }
        boolean valid = this.mRegex.matcher(value).matches();
        if (Helper.sDebug) {
            Log.d(TAG, "isValid(): " + valid);
        }
        return valid;
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "RegexValidator: [id=" + this.mId + ", regex=" + this.mRegex + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mId, flags);
        parcel.writeSerializable(this.mRegex);
    }
}

