/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public final class FillEventHistory
implements Parcelable {
    private final int mServiceUid;
    private final int mSessionId;
    private final Bundle mClientState;
    List<Event> mEvents;
    public static final Parcelable.Creator<FillEventHistory> CREATOR = new Parcelable.Creator<FillEventHistory>(){

        @Override
        public FillEventHistory createFromParcel(Parcel parcel) {
            FillEventHistory selection = new FillEventHistory(0, 0, parcel.readBundle());
            int numEvents = parcel.readInt();
            for (int i = 0; i < numEvents; ++i) {
                selection.addEvent(new Event(parcel.readInt(), parcel.readString()));
            }
            return selection;
        }

        public FillEventHistory[] newArray(int size) {
            return new FillEventHistory[size];
        }
    };

    public int getServiceUid() {
        return this.mServiceUid;
    }

    public int getSessionId() {
        return this.mSessionId;
    }

    public Bundle getClientState() {
        return this.mClientState;
    }

    public List<Event> getEvents() {
        return this.mEvents;
    }

    public void addEvent(Event event) {
        if (this.mEvents == null) {
            this.mEvents = new ArrayList<Event>(1);
        }
        this.mEvents.add(event);
    }

    public FillEventHistory(int serviceUid, int sessionId, Bundle clientState) {
        this.mClientState = clientState;
        this.mServiceUid = serviceUid;
        this.mSessionId = sessionId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.mClientState);
        if (this.mEvents == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(this.mEvents.size());
            int numEvents = this.mEvents.size();
            for (int i = 0; i < numEvents; ++i) {
                Event event = this.mEvents.get(i);
                dest.writeInt(event.getType());
                dest.writeString(event.getDatasetId());
            }
        }
    }

    public static final class Event {
        public static final int TYPE_DATASET_SELECTED = 0;
        public static final int TYPE_DATASET_AUTHENTICATION_SELECTED = 1;
        public static final int TYPE_AUTHENTICATION_SELECTED = 2;
        public static final int TYPE_SAVE_SHOWN = 3;
        private final int mEventType;
        private final String mDatasetId;

        public int getType() {
            return this.mEventType;
        }

        public String getDatasetId() {
            return this.mDatasetId;
        }

        public Event(int eventType, String datasetId) {
            this.mEventType = Preconditions.checkArgumentInRange(eventType, 0, 3, "eventType");
            this.mDatasetId = datasetId;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface EventIds {
        }
    }
}

