/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.Credentials;
import android.security.KeyStore;
import android.security.KeyStoreParameter;
import android.security.keymaster.KeyCharacteristics;
import android.security.keymaster.KeymasterArguments;
import android.security.keystore.AndroidKeyStoreKey;
import android.security.keystore.AndroidKeyStoreLoadStoreParameter;
import android.security.keystore.AndroidKeyStorePrivateKey;
import android.security.keystore.AndroidKeyStoreProvider;
import android.security.keystore.AndroidKeyStoreSecretKey;
import android.security.keystore.DelegatingX509Certificate;
import android.security.keystore.KeyProperties;
import android.security.keystore.KeyProtection;
import android.security.keystore.KeymasterUtils;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.SecretKey;
import libcore.util.EmptyArray;

public class AndroidKeyStoreSpi
extends KeyStoreSpi {
    public static final String NAME = "AndroidKeyStore";
    private KeyStore mKeyStore;
    private int mUid = -1;

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.isPrivateKeyEntry(alias)) {
            String privateKeyAlias = "USRPKEY_" + alias;
            return AndroidKeyStoreProvider.loadAndroidKeyStorePrivateKeyFromKeystore(this.mKeyStore, privateKeyAlias, this.mUid);
        }
        if (this.isSecretKeyEntry(alias)) {
            String secretKeyAlias = "USRSKEY_" + alias;
            return AndroidKeyStoreProvider.loadAndroidKeyStoreSecretKeyFromKeystore(this.mKeyStore, secretKeyAlias, this.mUid);
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] caList;
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        X509Certificate leaf = (X509Certificate)this.engineGetCertificate(alias);
        if (leaf == null) {
            return null;
        }
        byte[] caBytes = this.mKeyStore.get("CACERT_" + alias, this.mUid);
        if (caBytes != null) {
            Collection<X509Certificate> caChain = AndroidKeyStoreSpi.toCertificates(caBytes);
            caList = new Certificate[caChain.size() + 1];
            Iterator<X509Certificate> it = caChain.iterator();
            int i = 1;
            while (it.hasNext()) {
                caList[i++] = it.next();
            }
        } else {
            caList = new Certificate[]{leaf};
        }
        return caList;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        byte[] encodedCert = this.mKeyStore.get("USRCERT_" + alias, this.mUid);
        if (encodedCert != null) {
            return this.getCertificateForPrivateKeyEntry(alias, encodedCert);
        }
        encodedCert = this.mKeyStore.get("CACERT_" + alias, this.mUid);
        if (encodedCert != null) {
            return this.getCertificateForTrustedCertificateEntry(encodedCert);
        }
        return null;
    }

    private Certificate getCertificateForTrustedCertificateEntry(byte[] encodedCert) {
        return AndroidKeyStoreSpi.toCertificate(encodedCert);
    }

    private Certificate getCertificateForPrivateKeyEntry(String alias, byte[] encodedCert) {
        X509Certificate cert = AndroidKeyStoreSpi.toCertificate(encodedCert);
        if (cert == null) {
            return null;
        }
        String privateKeyAlias = "USRPKEY_" + alias;
        if (this.mKeyStore.contains(privateKeyAlias, this.mUid)) {
            return AndroidKeyStoreSpi.wrapIntoKeyStoreCertificate(privateKeyAlias, this.mUid, cert);
        }
        return cert;
    }

    private static KeyStoreX509Certificate wrapIntoKeyStoreCertificate(String privateKeyAlias, int uid, X509Certificate certificate) {
        return certificate != null ? new KeyStoreX509Certificate(privateKeyAlias, uid, certificate) : null;
    }

    private static X509Certificate toCertificate(byte[] bytes) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            Log.w(NAME, "Couldn't parse certificate in keystore", e);
            return null;
        }
    }

    private static Collection<X509Certificate> toCertificates(byte[] bytes) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return certFactory.generateCertificates(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            Log.w(NAME, "Couldn't parse certificates in keystore", e);
            return new ArrayList<X509Certificate>();
        }
    }

    private Date getModificationDate(String alias) {
        long epochMillis = this.mKeyStore.getmtime(alias, this.mUid);
        if (epochMillis == -1L) {
            return null;
        }
        return new Date(epochMillis);
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        Date d = this.getModificationDate("USRPKEY_" + alias);
        if (d != null) {
            return d;
        }
        d = this.getModificationDate("USRSKEY_" + alias);
        if (d != null) {
            return d;
        }
        d = this.getModificationDate("USRCERT_" + alias);
        if (d != null) {
            return d;
        }
        return this.getModificationDate("CACERT_" + alias);
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (password != null && password.length > 0) {
            throw new KeyStoreException("entries cannot be protected with passwords");
        }
        if (key instanceof PrivateKey) {
            this.setPrivateKeyEntry(alias, (PrivateKey)key, chain, null);
        } else if (key instanceof SecretKey) {
            this.setSecretKeyEntry(alias, (SecretKey)key, null);
        } else {
            throw new KeyStoreException("Only PrivateKey and SecretKey are supported");
        }
    }

    private static KeyProtection getLegacyKeyProtectionParameter(PrivateKey key) throws KeyStoreException {
        KeyProtection.Builder specBuilder;
        String keyAlgorithm = key.getAlgorithm();
        if ("EC".equalsIgnoreCase(keyAlgorithm)) {
            specBuilder = new KeyProtection.Builder(12);
            specBuilder.setDigests("NONE", "SHA-1", "SHA-224", "SHA-256", "SHA-384", "SHA-512");
        } else if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            specBuilder = new KeyProtection.Builder(15);
            specBuilder.setDigests("NONE", "MD5", "SHA-1", "SHA-224", "SHA-256", "SHA-384", "SHA-512");
            specBuilder.setEncryptionPaddings("NoPadding", "PKCS1Padding", "OAEPPadding");
            specBuilder.setSignaturePaddings("PKCS1", "PSS");
            specBuilder.setRandomizedEncryptionRequired(false);
        } else {
            throw new KeyStoreException("Unsupported key algorithm: " + keyAlgorithm);
        }
        specBuilder.setUserAuthenticationRequired(false);
        return specBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPrivateKeyEntry(String alias, PrivateKey key, Certificate[] chain, KeyStore.ProtectionParameter param) throws KeyStoreException {
        byte[] pkcs8EncodedPrivateKeyBytes;
        KeymasterArguments importArgs;
        boolean shouldReplacePrivateKey;
        String pkeyAlias;
        byte[] chainBytes;
        byte[] userCertBytes;
        KeyProtection spec;
        int flags = 0;
        if (param == null) {
            spec = AndroidKeyStoreSpi.getLegacyKeyProtectionParameter(key);
        } else if (param instanceof KeyStoreParameter) {
            spec = AndroidKeyStoreSpi.getLegacyKeyProtectionParameter(key);
            KeyStoreParameter legacySpec = (KeyStoreParameter)param;
            if (legacySpec.isEncryptionRequired()) {
                flags = 1;
            }
        } else if (param instanceof KeyProtection) {
            spec = (KeyProtection)param;
            if (spec.isCriticalToDeviceEncryption()) {
                flags |= 8;
            }
        } else {
            throw new KeyStoreException("Unsupported protection parameter class:" + param.getClass().getName() + ". Supported: " + KeyProtection.class.getName() + ", " + KeyStoreParameter.class.getName());
        }
        if (chain == null || chain.length == 0) {
            throw new KeyStoreException("Must supply at least one Certificate with PrivateKey");
        }
        X509Certificate[] x509chain = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            if (!"X.509".equals(chain[i].getType())) {
                throw new KeyStoreException("Certificates must be in X.509 format: invalid cert #" + i);
            }
            if (!(chain[i] instanceof X509Certificate)) {
                throw new KeyStoreException("Certificates must be in X.509 format: invalid cert #" + i);
            }
            x509chain[i] = (X509Certificate)chain[i];
        }
        try {
            userCertBytes = x509chain[0].getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException("Failed to encode certificate #0", e);
        }
        if (chain.length > 1) {
            byte[][] certsBytes = new byte[x509chain.length - 1][];
            int totalCertLength = 0;
            for (int i = 0; i < certsBytes.length; ++i) {
                try {
                    certsBytes[i] = x509chain[i + 1].getEncoded();
                    totalCertLength += certsBytes[i].length;
                    continue;
                }
                catch (CertificateEncodingException e) {
                    throw new KeyStoreException("Failed to encode certificate #" + i, e);
                }
            }
            chainBytes = new byte[totalCertLength];
            int outputOffset = 0;
            for (int i = 0; i < certsBytes.length; ++i) {
                int certLength = certsBytes[i].length;
                System.arraycopy((byte[])certsBytes[i], (int)0, (byte[])chainBytes, (int)outputOffset, (int)certLength);
                outputOffset += certLength;
                certsBytes[i] = null;
            }
        } else {
            chainBytes = null;
        }
        if ((pkeyAlias = key instanceof AndroidKeyStorePrivateKey ? ((AndroidKeyStoreKey)((Object)key)).getAlias() : null) != null && pkeyAlias.startsWith("USRPKEY_")) {
            String keySubalias = pkeyAlias.substring("USRPKEY_".length());
            if (!alias.equals(keySubalias)) {
                throw new KeyStoreException("Can only replace keys with same alias: " + alias + " != " + keySubalias);
            }
            shouldReplacePrivateKey = false;
            importArgs = null;
            pkcs8EncodedPrivateKeyBytes = null;
        } else {
            shouldReplacePrivateKey = true;
            String keyFormat = key.getFormat();
            if (keyFormat == null || !"PKCS#8".equals(keyFormat)) {
                throw new KeyStoreException("Unsupported private key export format: " + keyFormat + ". Only private keys which export their key material in PKCS#8 format are" + " supported.");
            }
            pkcs8EncodedPrivateKeyBytes = key.getEncoded();
            if (pkcs8EncodedPrivateKeyBytes == null) {
                throw new KeyStoreException("Private key did not export any key material");
            }
            importArgs = new KeymasterArguments();
            try {
                importArgs.addEnum(0x10000002, KeyProperties.KeyAlgorithm.toKeymasterAsymmetricKeyAlgorithm(key.getAlgorithm()));
                int purposes = spec.getPurposes();
                importArgs.addEnums(0x20000001, KeyProperties.Purpose.allToKeymaster(purposes));
                if (spec.isDigestsSpecified()) {
                    importArgs.addEnums(0x20000005, KeyProperties.Digest.allToKeymaster(spec.getDigests()));
                }
                importArgs.addEnums(0x20000004, KeyProperties.BlockMode.allToKeymaster(spec.getBlockModes()));
                int[] keymasterEncryptionPaddings = KeyProperties.EncryptionPadding.allToKeymaster(spec.getEncryptionPaddings());
                if ((purposes & 1) != 0 && spec.isRandomizedEncryptionRequired()) {
                    for (int keymasterPadding : keymasterEncryptionPaddings) {
                        if (KeymasterUtils.isKeymasterPaddingSchemeIndCpaCompatibleWithAsymmetricCrypto(keymasterPadding)) continue;
                        throw new KeyStoreException("Randomized encryption (IND-CPA) required but is violated by encryption padding mode: " + KeyProperties.EncryptionPadding.fromKeymaster(keymasterPadding) + ". See KeyProtection documentation.");
                    }
                }
                importArgs.addEnums(0x20000006, keymasterEncryptionPaddings);
                importArgs.addEnums(0x20000006, KeyProperties.SignaturePadding.allToKeymaster(spec.getSignaturePaddings()));
                KeymasterUtils.addUserAuthArgs(importArgs, spec.isUserAuthenticationRequired(), spec.getUserAuthenticationValidityDurationSeconds(), spec.isUserAuthenticationValidWhileOnBody(), spec.isInvalidatedByBiometricEnrollment(), spec.getBoundToSpecificSecureUserId());
                importArgs.addDateIfNotNull(1610613136, spec.getKeyValidityStart());
                importArgs.addDateIfNotNull(1610613137, spec.getKeyValidityForOriginationEnd());
                importArgs.addDateIfNotNull(1610613138, spec.getKeyValidityForConsumptionEnd());
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new KeyStoreException(e);
            }
        }
        boolean success = false;
        try {
            if (shouldReplacePrivateKey) {
                Credentials.deleteAllTypesForAlias(this.mKeyStore, alias, this.mUid);
                KeyCharacteristics resultingKeyCharacteristics = new KeyCharacteristics();
                int errorCode = this.mKeyStore.importKey("USRPKEY_" + alias, importArgs, 1, pkcs8EncodedPrivateKeyBytes, this.mUid, flags, resultingKeyCharacteristics);
                if (errorCode != 1) {
                    throw new KeyStoreException("Failed to store private key", KeyStore.getKeyStoreException(errorCode));
                }
            } else {
                Credentials.deleteCertificateTypesForAlias(this.mKeyStore, alias, this.mUid);
                Credentials.deleteSecretKeyTypeForAlias(this.mKeyStore, alias, this.mUid);
            }
            int errorCode = this.mKeyStore.insert("USRCERT_" + alias, userCertBytes, this.mUid, flags);
            if (errorCode != 1) {
                throw new KeyStoreException("Failed to store certificate #0", KeyStore.getKeyStoreException(errorCode));
            }
            errorCode = this.mKeyStore.insert("CACERT_" + alias, chainBytes, this.mUid, flags);
            if (errorCode != 1) {
                throw new KeyStoreException("Failed to store certificate chain", KeyStore.getKeyStoreException(errorCode));
            }
            success = true;
        }
        finally {
            if (!success) {
                if (shouldReplacePrivateKey) {
                    Credentials.deleteAllTypesForAlias(this.mKeyStore, alias, this.mUid);
                } else {
                    Credentials.deleteCertificateTypesForAlias(this.mKeyStore, alias, this.mUid);
                    Credentials.deleteSecretKeyTypeForAlias(this.mKeyStore, alias, this.mUid);
                }
            }
        }
    }

    private void setSecretKeyEntry(String entryAlias, SecretKey key, KeyStore.ProtectionParameter param) throws KeyStoreException {
        if (param != null && !(param instanceof KeyProtection)) {
            throw new KeyStoreException("Unsupported protection parameter class: " + param.getClass().getName() + ". Supported: " + KeyProtection.class.getName());
        }
        KeyProtection params = (KeyProtection)param;
        if (key instanceof AndroidKeyStoreSecretKey) {
            String keyAliasInKeystore = ((AndroidKeyStoreSecretKey)key).getAlias();
            if (keyAliasInKeystore == null) {
                throw new KeyStoreException("KeyStore-backed secret key does not have an alias");
            }
            if (!keyAliasInKeystore.startsWith("USRSKEY_")) {
                throw new KeyStoreException("KeyStore-backed secret key has invalid alias: " + keyAliasInKeystore);
            }
            String keyEntryAlias = keyAliasInKeystore.substring("USRSKEY_".length());
            if (!entryAlias.equals(keyEntryAlias)) {
                throw new KeyStoreException("Can only replace KeyStore-backed keys with same alias: " + entryAlias + " != " + keyEntryAlias);
            }
            if (params != null) {
                throw new KeyStoreException("Modifying KeyStore-backed key using protection parameters not supported");
            }
            return;
        }
        if (params == null) {
            throw new KeyStoreException("Protection parameters must be specified when importing a symmetric key");
        }
        String keyExportFormat = key.getFormat();
        if (keyExportFormat == null) {
            throw new KeyStoreException("Only secret keys that export their key material are supported");
        }
        if (!"RAW".equals(keyExportFormat)) {
            throw new KeyStoreException("Unsupported secret key material export format: " + keyExportFormat);
        }
        byte[] keyMaterial = key.getEncoded();
        if (keyMaterial == null) {
            throw new KeyStoreException("Key did not export its key material despite supporting RAW format export");
        }
        KeymasterArguments args = new KeymasterArguments();
        try {
            int[] keymasterDigests;
            int keymasterAlgorithm = KeyProperties.KeyAlgorithm.toKeymasterSecretKeyAlgorithm(key.getAlgorithm());
            args.addEnum(0x10000002, keymasterAlgorithm);
            if (keymasterAlgorithm == 128) {
                int[] keymasterDigestsFromParams;
                int keymasterImpliedDigest = KeyProperties.KeyAlgorithm.toKeymasterDigest(key.getAlgorithm());
                if (keymasterImpliedDigest == -1) {
                    throw new ProviderException("HMAC key algorithm digest unknown for key algorithm " + key.getAlgorithm());
                }
                keymasterDigests = new int[]{keymasterImpliedDigest};
                if (params.isDigestsSpecified() && ((keymasterDigestsFromParams = KeyProperties.Digest.allToKeymaster(params.getDigests())).length != 1 || keymasterDigestsFromParams[0] != keymasterImpliedDigest)) {
                    throw new KeyStoreException("Unsupported digests specification: " + Arrays.asList(params.getDigests()) + ". Only " + KeyProperties.Digest.fromKeymaster(keymasterImpliedDigest) + " supported for HMAC key algorithm " + key.getAlgorithm());
                }
            } else {
                keymasterDigests = params.isDigestsSpecified() ? KeyProperties.Digest.allToKeymaster(params.getDigests()) : EmptyArray.INT;
            }
            args.addEnums(0x20000005, keymasterDigests);
            int purposes = params.getPurposes();
            int[] keymasterBlockModes = KeyProperties.BlockMode.allToKeymaster(params.getBlockModes());
            if ((purposes & 1) != 0 && params.isRandomizedEncryptionRequired()) {
                for (int keymasterBlockMode : keymasterBlockModes) {
                    if (KeymasterUtils.isKeymasterBlockModeIndCpaCompatibleWithSymmetricCrypto(keymasterBlockMode)) continue;
                    throw new KeyStoreException("Randomized encryption (IND-CPA) required but may be violated by block mode: " + KeyProperties.BlockMode.fromKeymaster(keymasterBlockMode) + ". See KeyProtection documentation.");
                }
            }
            args.addEnums(0x20000001, KeyProperties.Purpose.allToKeymaster(purposes));
            args.addEnums(0x20000004, keymasterBlockModes);
            if (params.getSignaturePaddings().length > 0) {
                throw new KeyStoreException("Signature paddings not supported for symmetric keys");
            }
            int[] keymasterPaddings = KeyProperties.EncryptionPadding.allToKeymaster(params.getEncryptionPaddings());
            args.addEnums(0x20000006, keymasterPaddings);
            KeymasterUtils.addUserAuthArgs(args, params.isUserAuthenticationRequired(), params.getUserAuthenticationValidityDurationSeconds(), params.isUserAuthenticationValidWhileOnBody(), params.isInvalidatedByBiometricEnrollment(), params.getBoundToSpecificSecureUserId());
            KeymasterUtils.addMinMacLengthAuthorizationIfNecessary(args, keymasterAlgorithm, keymasterBlockModes, keymasterDigests);
            args.addDateIfNotNull(1610613136, params.getKeyValidityStart());
            args.addDateIfNotNull(1610613137, params.getKeyValidityForOriginationEnd());
            args.addDateIfNotNull(1610613138, params.getKeyValidityForConsumptionEnd());
            if ((purposes & 1) != 0 && !params.isRandomizedEncryptionRequired()) {
                args.addBoolean(0x70000007);
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new KeyStoreException(e);
        }
        int flags = 0;
        if (params.isCriticalToDeviceEncryption()) {
            flags |= 8;
        }
        Credentials.deleteAllTypesForAlias(this.mKeyStore, entryAlias, this.mUid);
        String keyAliasInKeystore = "USRSKEY_" + entryAlias;
        int errorCode = this.mKeyStore.importKey(keyAliasInKeystore, args, 3, keyMaterial, this.mUid, flags, new KeyCharacteristics());
        if (errorCode != 1) {
            throw new KeyStoreException("Failed to import secret key. Keystore error code: " + errorCode);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] userKey, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Operation not supported because key encoding is unknown");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        byte[] encoded;
        if (this.isKeyEntry(alias)) {
            throw new KeyStoreException("Entry exists and is not a trusted certificate");
        }
        if (cert == null) {
            throw new NullPointerException("cert == null");
        }
        try {
            encoded = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException(e);
        }
        if (!this.mKeyStore.put("CACERT_" + alias, encoded, this.mUid, 0)) {
            throw new KeyStoreException("Couldn't insert certificate; is KeyStore initialized?");
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (!Credentials.deleteAllTypesForAlias(this.mKeyStore, alias, this.mUid)) {
            throw new KeyStoreException("Failed to delete entry: " + alias);
        }
    }

    private Set<String> getUniqueAliases() {
        String[] rawAliases = this.mKeyStore.list("", this.mUid);
        if (rawAliases == null) {
            return new HashSet<String>();
        }
        HashSet<String> aliases = new HashSet<String>(rawAliases.length);
        for (String alias : rawAliases) {
            int idx = alias.indexOf(95);
            if (idx == -1 || alias.length() <= idx) {
                Log.e(NAME, "invalid alias: " + alias);
                continue;
            }
            aliases.add(new String(alias.substring(idx + 1)));
        }
        return aliases;
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.getUniqueAliases());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("USRPKEY_" + alias, this.mUid) || this.mKeyStore.contains("USRSKEY_" + alias, this.mUid) || this.mKeyStore.contains("USRCERT_" + alias, this.mUid) || this.mKeyStore.contains("CACERT_" + alias, this.mUid);
    }

    @Override
    public int engineSize() {
        return this.getUniqueAliases().size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.isKeyEntry(alias);
    }

    private boolean isKeyEntry(String alias) {
        return this.isPrivateKeyEntry(alias) || this.isSecretKeyEntry(alias);
    }

    private boolean isPrivateKeyEntry(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("USRPKEY_" + alias, this.mUid);
    }

    private boolean isSecretKeyEntry(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("USRSKEY_" + alias, this.mUid);
    }

    private boolean isCertificateEntry(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("CACERT_" + alias, this.mUid);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return !this.isKeyEntry(alias) && this.isCertificateEntry(alias);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        byte[] targetCertBytes;
        if (cert == null) {
            return null;
        }
        if (!"X.509".equalsIgnoreCase(cert.getType())) {
            return null;
        }
        try {
            targetCertBytes = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            return null;
        }
        if (targetCertBytes == null) {
            return null;
        }
        HashSet<String> nonCaEntries = new HashSet<String>();
        String[] certAliases = this.mKeyStore.list("USRCERT_", this.mUid);
        if (certAliases != null) {
            for (String alias : certAliases) {
                byte[] certBytes = this.mKeyStore.get("USRCERT_" + alias, this.mUid);
                if (certBytes == null) continue;
                nonCaEntries.add(alias);
                if (!Arrays.equals(certBytes, targetCertBytes)) continue;
                return alias;
            }
        }
        String[] caAliases = this.mKeyStore.list("CACERT_", this.mUid);
        if (certAliases != null) {
            for (String alias : caAliases) {
                byte[] certBytes;
                if (nonCaEntries.contains(alias) || (certBytes = this.mKeyStore.get("CACERT_" + alias, this.mUid)) == null || !Arrays.equals(certBytes, targetCertBytes)) continue;
                return alias;
            }
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException("Can not serialize AndroidKeyStore to OutputStream");
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream != null) {
            throw new IllegalArgumentException("InputStream not supported");
        }
        if (password != null) {
            throw new IllegalArgumentException("password not supported");
        }
        this.mKeyStore = KeyStore.getInstance();
        this.mUid = -1;
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        int uid = -1;
        if (param != null) {
            if (param instanceof AndroidKeyStoreLoadStoreParameter) {
                uid = ((AndroidKeyStoreLoadStoreParameter)param).getUid();
            } else {
                throw new IllegalArgumentException("Unsupported param type: " + param.getClass());
            }
        }
        this.mKeyStore = KeyStore.getInstance();
        this.mUid = uid;
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter param) throws KeyStoreException {
        if (entry == null) {
            throw new KeyStoreException("entry == null");
        }
        Credentials.deleteAllTypesForAlias(this.mKeyStore, alias, this.mUid);
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trE = (KeyStore.TrustedCertificateEntry)entry;
            this.engineSetCertificateEntry(alias, trE.getTrustedCertificate());
            return;
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry prE = (KeyStore.PrivateKeyEntry)entry;
            this.setPrivateKeyEntry(alias, prE.getPrivateKey(), prE.getCertificateChain(), param);
        } else if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry secE = (KeyStore.SecretKeyEntry)entry;
            this.setSecretKeyEntry(alias, secE.getSecretKey(), param);
        } else {
            throw new KeyStoreException("Entry must be a PrivateKeyEntry, SecretKeyEntry or TrustedCertificateEntry; was " + entry);
        }
    }

    static class KeyStoreX509Certificate
    extends DelegatingX509Certificate {
        private final String mPrivateKeyAlias;
        private final int mPrivateKeyUid;

        KeyStoreX509Certificate(String privateKeyAlias, int privateKeyUid, X509Certificate delegate) {
            super(delegate);
            this.mPrivateKeyAlias = privateKeyAlias;
            this.mPrivateKeyUid = privateKeyUid;
        }

        @Override
        public PublicKey getPublicKey() {
            PublicKey original = super.getPublicKey();
            return AndroidKeyStoreProvider.getAndroidKeyStorePublicKey(this.mPrivateKeyAlias, this.mPrivateKeyUid, original.getAlgorithm(), original.getEncoded());
        }
    }
}

