/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.FieldPacker;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.Script;
import android.renderscript.Type;
import android.util.Log;
import android.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ScriptGroup
extends BaseObj {
    private static final String TAG = "ScriptGroup";
    IO[] mOutputs;
    IO[] mInputs;
    private String mName;
    private List<Closure> mClosures;
    private List<Input> mInputs2;
    private Future[] mOutputs2;

    ScriptGroup(long id2, RenderScript rs) {
        super(id2, rs);
        this.guard.open("destroy");
    }

    ScriptGroup(RenderScript rs, String name, List<Closure> closures, List<Input> inputs, Future[] outputs) {
        super(0L, rs);
        this.mName = name;
        this.mClosures = closures;
        this.mInputs2 = inputs;
        this.mOutputs2 = outputs;
        long[] closureIDs = new long[closures.size()];
        for (int i = 0; i < closureIDs.length; ++i) {
            closureIDs[i] = closures.get(i).getID(rs);
        }
        long id2 = rs.nScriptGroup2Create(name, RenderScript.getCachePath(), closureIDs);
        this.setID(id2);
        this.guard.open("destroy");
    }

    public Object[] execute(Object ... inputs) {
        if (inputs.length < this.mInputs2.size()) {
            Log.e(TAG, this.toString() + " receives " + inputs.length + " inputs, " + "less than expected " + this.mInputs2.size());
            return null;
        }
        if (inputs.length > this.mInputs2.size()) {
            Log.i(TAG, this.toString() + " receives " + inputs.length + " inputs, " + "more than expected " + this.mInputs2.size());
        }
        for (int i = 0; i < this.mInputs2.size(); ++i) {
            Object obj = inputs[i];
            if (obj instanceof Future || obj instanceof Input) {
                Log.e(TAG, this.toString() + ": input " + i + " is a future or unbound value");
                return null;
            }
            Input unbound = this.mInputs2.get(i);
            unbound.set(obj);
        }
        this.mRS.nScriptGroup2Execute(this.getID(this.mRS));
        Object[] outputObjs = new Object[this.mOutputs2.length];
        int i = 0;
        for (Future f : this.mOutputs2) {
            Object output = f.getValue();
            if (output instanceof Input) {
                output = ((Input)output).get();
            }
            outputObjs[i++] = output;
        }
        return outputObjs;
    }

    public void setInput(Script.KernelID s, Allocation a) {
        for (int ct = 0; ct < this.mInputs.length; ++ct) {
            if (this.mInputs[ct].mKID != s) continue;
            this.mInputs[ct].mAllocation = a;
            this.mRS.nScriptGroupSetInput(this.getID(this.mRS), s.getID(this.mRS), this.mRS.safeID(a));
            return;
        }
        throw new RSIllegalArgumentException("Script not found");
    }

    public void setOutput(Script.KernelID s, Allocation a) {
        for (int ct = 0; ct < this.mOutputs.length; ++ct) {
            if (this.mOutputs[ct].mKID != s) continue;
            this.mOutputs[ct].mAllocation = a;
            this.mRS.nScriptGroupSetOutput(this.getID(this.mRS), s.getID(this.mRS), this.mRS.safeID(a));
            return;
        }
        throw new RSIllegalArgumentException("Script not found");
    }

    public void execute() {
        this.mRS.nScriptGroupExecute(this.getID(this.mRS));
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mClosures != null) {
            for (Closure c : this.mClosures) {
                c.destroy();
            }
        }
    }

    public static final class Builder2 {
        RenderScript mRS;
        List<Closure> mClosures;
        List<Input> mInputs;
        private static final String TAG = "ScriptGroup.Builder2";

        public Builder2(RenderScript rs) {
            this.mRS = rs;
            this.mClosures = new ArrayList<Closure>();
            this.mInputs = new ArrayList<Input>();
        }

        private Closure addKernelInternal(Script.KernelID k, Type returnType, Object[] args, Map<Script.FieldID, Object> globalBindings) {
            Closure c = new Closure(this.mRS, k, returnType, args, globalBindings);
            this.mClosures.add(c);
            return c;
        }

        private Closure addInvokeInternal(Script.InvokeID invoke, Object[] args, Map<Script.FieldID, Object> globalBindings) {
            Closure c = new Closure(this.mRS, invoke, args, globalBindings);
            this.mClosures.add(c);
            return c;
        }

        public Input addInput() {
            Input unbound = new Input();
            this.mInputs.add(unbound);
            return unbound;
        }

        public Closure addKernel(Script.KernelID k, Type returnType, Object ... argsAndBindings) {
            ArrayList<Object> args = new ArrayList<Object>();
            HashMap<Script.FieldID, Object> bindingMap = new HashMap<Script.FieldID, Object>();
            if (!this.seperateArgsAndBindings(argsAndBindings, args, bindingMap)) {
                return null;
            }
            return this.addKernelInternal(k, returnType, args.toArray(), bindingMap);
        }

        public Closure addInvoke(Script.InvokeID invoke, Object ... argsAndBindings) {
            ArrayList<Object> args = new ArrayList<Object>();
            HashMap<Script.FieldID, Object> bindingMap = new HashMap<Script.FieldID, Object>();
            if (!this.seperateArgsAndBindings(argsAndBindings, args, bindingMap)) {
                return null;
            }
            return this.addInvokeInternal(invoke, args.toArray(), bindingMap);
        }

        public ScriptGroup create(String name, Future ... outputs) {
            if (name == null || name.isEmpty() || name.length() > 100 || !name.equals(name.replaceAll("[^a-zA-Z0-9-]", "_"))) {
                throw new RSIllegalArgumentException("invalid script group name");
            }
            ScriptGroup ret = new ScriptGroup(this.mRS, name, this.mClosures, this.mInputs, outputs);
            this.mClosures = new ArrayList<Closure>();
            this.mInputs = new ArrayList<Input>();
            return ret;
        }

        private boolean seperateArgsAndBindings(Object[] argsAndBindings, ArrayList<Object> args, Map<Script.FieldID, Object> bindingMap) {
            int i;
            for (i = 0; i < argsAndBindings.length && !(argsAndBindings[i] instanceof Binding); ++i) {
                args.add(argsAndBindings[i]);
            }
            while (i < argsAndBindings.length) {
                if (!(argsAndBindings[i] instanceof Binding)) {
                    return false;
                }
                Binding b = (Binding)argsAndBindings[i];
                bindingMap.put(b.getField(), b.getValue());
                ++i;
            }
            return true;
        }
    }

    public static final class Binding {
        private final Script.FieldID mField;
        private final Object mValue;

        public Binding(Script.FieldID field, Object value) {
            this.mField = field;
            this.mValue = value;
        }

        Script.FieldID getField() {
            return this.mField;
        }

        Object getValue() {
            return this.mValue;
        }
    }

    public static final class Builder {
        private RenderScript mRS;
        private ArrayList<Node> mNodes = new ArrayList();
        private ArrayList<ConnectLine> mLines = new ArrayList();
        private int mKernelCount;

        public Builder(RenderScript rs) {
            this.mRS = rs;
        }

        private void validateCycle(Node target, Node original) {
            for (int ct = 0; ct < target.mOutputs.size(); ++ct) {
                Node tn;
                ConnectLine cl = target.mOutputs.get(ct);
                if (cl.mToK != null) {
                    tn = this.findNode(cl.mToK.mScript);
                    if (tn.equals(original)) {
                        throw new RSInvalidStateException("Loops in group not allowed.");
                    }
                    this.validateCycle(tn, original);
                }
                if (cl.mToF == null) continue;
                tn = this.findNode(cl.mToF.mScript);
                if (tn.equals(original)) {
                    throw new RSInvalidStateException("Loops in group not allowed.");
                }
                this.validateCycle(tn, original);
            }
        }

        private void mergeDAGs(int valueUsed, int valueKilled) {
            for (int ct = 0; ct < this.mNodes.size(); ++ct) {
                if (this.mNodes.get((int)ct).dagNumber != valueKilled) continue;
                this.mNodes.get((int)ct).dagNumber = valueUsed;
            }
        }

        private void validateDAGRecurse(Node n, int dagNumber) {
            if (n.dagNumber != 0 && n.dagNumber != dagNumber) {
                this.mergeDAGs(n.dagNumber, dagNumber);
                return;
            }
            n.dagNumber = dagNumber;
            for (int ct = 0; ct < n.mOutputs.size(); ++ct) {
                Node tn;
                ConnectLine cl = n.mOutputs.get(ct);
                if (cl.mToK != null) {
                    tn = this.findNode(cl.mToK.mScript);
                    this.validateDAGRecurse(tn, dagNumber);
                }
                if (cl.mToF == null) continue;
                tn = this.findNode(cl.mToF.mScript);
                this.validateDAGRecurse(tn, dagNumber);
            }
        }

        private void validateDAG() {
            for (int ct = 0; ct < this.mNodes.size(); ++ct) {
                Node n = this.mNodes.get(ct);
                if (n.mInputs.size() != 0) continue;
                if (n.mOutputs.size() == 0 && this.mNodes.size() > 1) {
                    String msg = "Groups cannot contain unconnected scripts";
                    throw new RSInvalidStateException(msg);
                }
                this.validateDAGRecurse(n, ct + 1);
            }
            int dagNumber = this.mNodes.get((int)0).dagNumber;
            for (int ct = 0; ct < this.mNodes.size(); ++ct) {
                if (this.mNodes.get((int)ct).dagNumber == dagNumber) continue;
                throw new RSInvalidStateException("Multiple DAGs in group not allowed.");
            }
        }

        private Node findNode(Script s) {
            for (int ct = 0; ct < this.mNodes.size(); ++ct) {
                if (s != this.mNodes.get((int)ct).mScript) continue;
                return this.mNodes.get(ct);
            }
            return null;
        }

        private Node findNode(Script.KernelID k) {
            for (int ct = 0; ct < this.mNodes.size(); ++ct) {
                Node n = this.mNodes.get(ct);
                for (int ct2 = 0; ct2 < n.mKernels.size(); ++ct2) {
                    if (k != n.mKernels.get(ct2)) continue;
                    return n;
                }
            }
            return null;
        }

        public Builder addKernel(Script.KernelID k) {
            if (this.mLines.size() != 0) {
                throw new RSInvalidStateException("Kernels may not be added once connections exist.");
            }
            if (this.findNode(k) != null) {
                return this;
            }
            ++this.mKernelCount;
            Node n = this.findNode(k.mScript);
            if (n == null) {
                n = new Node(k.mScript);
                this.mNodes.add(n);
            }
            n.mKernels.add(k);
            return this;
        }

        public Builder addConnection(Type t, Script.KernelID from, Script.FieldID to) {
            Node nf = this.findNode(from);
            if (nf == null) {
                throw new RSInvalidStateException("From script not found.");
            }
            Node nt = this.findNode(to.mScript);
            if (nt == null) {
                throw new RSInvalidStateException("To script not found.");
            }
            ConnectLine cl = new ConnectLine(t, from, to);
            this.mLines.add(new ConnectLine(t, from, to));
            nf.mOutputs.add(cl);
            nt.mInputs.add(cl);
            this.validateCycle(nf, nf);
            return this;
        }

        public Builder addConnection(Type t, Script.KernelID from, Script.KernelID to) {
            Node nf = this.findNode(from);
            if (nf == null) {
                throw new RSInvalidStateException("From script not found.");
            }
            Node nt = this.findNode(to);
            if (nt == null) {
                throw new RSInvalidStateException("To script not found.");
            }
            ConnectLine cl = new ConnectLine(t, from, to);
            this.mLines.add(new ConnectLine(t, from, to));
            nf.mOutputs.add(cl);
            nt.mInputs.add(cl);
            this.validateCycle(nf, nf);
            return this;
        }

        public ScriptGroup create() {
            int ct;
            if (this.mNodes.size() == 0) {
                throw new RSInvalidStateException("Empty script groups are not allowed");
            }
            for (int ct2 = 0; ct2 < this.mNodes.size(); ++ct2) {
                this.mNodes.get((int)ct2).dagNumber = 0;
            }
            this.validateDAG();
            ArrayList<IO> inputs = new ArrayList<IO>();
            ArrayList<IO> outputs = new ArrayList<IO>();
            long[] kernels = new long[this.mKernelCount];
            int idx = 0;
            for (int ct3 = 0; ct3 < this.mNodes.size(); ++ct3) {
                Node n = this.mNodes.get(ct3);
                for (int ct2 = 0; ct2 < n.mKernels.size(); ++ct2) {
                    int ct32;
                    Script.KernelID kid = n.mKernels.get(ct2);
                    kernels[idx++] = kid.getID(this.mRS);
                    boolean hasInput = false;
                    boolean hasOutput = false;
                    for (ct32 = 0; ct32 < n.mInputs.size(); ++ct32) {
                        if (n.mInputs.get((int)ct32).mToK != kid) continue;
                        hasInput = true;
                    }
                    for (ct32 = 0; ct32 < n.mOutputs.size(); ++ct32) {
                        if (n.mOutputs.get((int)ct32).mFrom != kid) continue;
                        hasOutput = true;
                    }
                    if (!hasInput) {
                        inputs.add(new IO(kid));
                    }
                    if (hasOutput) continue;
                    outputs.add(new IO(kid));
                }
            }
            if (idx != this.mKernelCount) {
                throw new RSRuntimeException("Count mismatch, should not happen.");
            }
            long[] src = new long[this.mLines.size()];
            long[] dstk = new long[this.mLines.size()];
            long[] dstf = new long[this.mLines.size()];
            long[] types = new long[this.mLines.size()];
            for (int ct4 = 0; ct4 < this.mLines.size(); ++ct4) {
                ConnectLine cl = this.mLines.get(ct4);
                src[ct4] = cl.mFrom.getID(this.mRS);
                if (cl.mToK != null) {
                    dstk[ct4] = cl.mToK.getID(this.mRS);
                }
                if (cl.mToF != null) {
                    dstf[ct4] = cl.mToF.getID(this.mRS);
                }
                types[ct4] = cl.mAllocationType.getID(this.mRS);
            }
            long id2 = this.mRS.nScriptGroupCreate(kernels, src, dstk, dstf, types);
            if (id2 == 0L) {
                throw new RSRuntimeException("Object creation error, should not happen.");
            }
            ScriptGroup sg = new ScriptGroup(id2, this.mRS);
            sg.mOutputs = new IO[outputs.size()];
            for (ct = 0; ct < outputs.size(); ++ct) {
                sg.mOutputs[ct] = (IO)outputs.get(ct);
            }
            sg.mInputs = new IO[inputs.size()];
            for (ct = 0; ct < inputs.size(); ++ct) {
                sg.mInputs[ct] = (IO)inputs.get(ct);
            }
            return sg;
        }
    }

    public static final class Input {
        List<Pair<Closure, Script.FieldID>> mFieldID = new ArrayList<Pair<Closure, Script.FieldID>>();
        List<Pair<Closure, Integer>> mArgIndex = new ArrayList<Pair<Closure, Integer>>();
        Object mValue;

        Input() {
        }

        void addReference(Closure closure, int index) {
            this.mArgIndex.add(Pair.create(closure, index));
        }

        void addReference(Closure closure, Script.FieldID fieldID) {
            this.mFieldID.add(Pair.create(closure, fieldID));
        }

        void set(Object value) {
            Closure closure;
            this.mValue = value;
            for (Pair<Closure, Integer> pair : this.mArgIndex) {
                closure = (Closure)pair.first;
                int index = (Integer)pair.second;
                closure.setArg(index, value);
            }
            for (Pair<Closure, Object> pair : this.mFieldID) {
                closure = (Closure)pair.first;
                Script.FieldID fieldID = (Script.FieldID)pair.second;
                closure.setGlobal(fieldID, value);
            }
        }

        Object get() {
            return this.mValue;
        }
    }

    public static final class Future {
        Closure mClosure;
        Script.FieldID mFieldID;
        Object mValue;

        Future(Closure closure, Script.FieldID fieldID, Object value) {
            this.mClosure = closure;
            this.mFieldID = fieldID;
            this.mValue = value;
        }

        Closure getClosure() {
            return this.mClosure;
        }

        Script.FieldID getFieldID() {
            return this.mFieldID;
        }

        Object getValue() {
            return this.mValue;
        }
    }

    public static final class Closure
    extends BaseObj {
        private Object[] mArgs;
        private Allocation mReturnValue;
        private Map<Script.FieldID, Object> mBindings;
        private Future mReturnFuture;
        private Map<Script.FieldID, Future> mGlobalFuture;
        private FieldPacker mFP;
        private static final String TAG = "Closure";

        Closure(long id2, RenderScript rs) {
            super(id2, rs);
        }

        Closure(RenderScript rs, Script.KernelID kernelID, Type returnType, Object[] args, Map<Script.FieldID, Object> globals) {
            super(0L, rs);
            int i;
            this.mArgs = args;
            this.mReturnValue = Allocation.createTyped(rs, returnType);
            this.mBindings = globals;
            this.mGlobalFuture = new HashMap<Script.FieldID, Future>();
            int numValues = args.length + globals.size();
            long[] fieldIDs = new long[numValues];
            long[] values = new long[numValues];
            int[] sizes = new int[numValues];
            long[] depClosures = new long[numValues];
            long[] depFieldIDs = new long[numValues];
            for (i = 0; i < args.length; ++i) {
                fieldIDs[i] = 0L;
                this.retrieveValueAndDependenceInfo(rs, i, null, args[i], values, sizes, depClosures, depFieldIDs);
            }
            for (Map.Entry<Script.FieldID, Object> entry : globals.entrySet()) {
                Object obj = entry.getValue();
                Script.FieldID fieldID = entry.getKey();
                fieldIDs[i] = fieldID.getID(rs);
                this.retrieveValueAndDependenceInfo(rs, i, fieldID, obj, values, sizes, depClosures, depFieldIDs);
                ++i;
            }
            long id2 = rs.nClosureCreate(kernelID.getID(rs), this.mReturnValue.getID(rs), fieldIDs, values, sizes, depClosures, depFieldIDs);
            this.setID(id2);
            this.guard.open("destroy");
        }

        Closure(RenderScript rs, Script.InvokeID invokeID, Object[] args, Map<Script.FieldID, Object> globals) {
            super(0L, rs);
            this.mFP = FieldPacker.createFromArray(args);
            this.mArgs = args;
            this.mBindings = globals;
            this.mGlobalFuture = new HashMap<Script.FieldID, Future>();
            int numValues = globals.size();
            long[] fieldIDs = new long[numValues];
            long[] values = new long[numValues];
            int[] sizes = new int[numValues];
            long[] depClosures = new long[numValues];
            long[] depFieldIDs = new long[numValues];
            int i = 0;
            for (Map.Entry<Script.FieldID, Object> entry : globals.entrySet()) {
                Object obj = entry.getValue();
                Script.FieldID fieldID = entry.getKey();
                fieldIDs[i] = fieldID.getID(rs);
                this.retrieveValueAndDependenceInfo(rs, i, fieldID, obj, values, sizes, depClosures, depFieldIDs);
                ++i;
            }
            long id2 = rs.nInvokeClosureCreate(invokeID.getID(rs), this.mFP.getData(), fieldIDs, values, sizes);
            this.setID(id2);
            this.guard.open("destroy");
        }

        @Override
        public void destroy() {
            super.destroy();
            if (this.mReturnValue != null) {
                this.mReturnValue.destroy();
            }
        }

        @Override
        protected void finalize() throws Throwable {
            this.mReturnValue = null;
            super.finalize();
        }

        private void retrieveValueAndDependenceInfo(RenderScript rs, int index, Script.FieldID fid, Object obj, long[] values, int[] sizes, long[] depClosures, long[] depFieldIDs) {
            if (obj instanceof Future) {
                Future f = (Future)obj;
                obj = f.getValue();
                depClosures[index] = f.getClosure().getID(rs);
                Script.FieldID fieldID = f.getFieldID();
                depFieldIDs[index] = fieldID != null ? fieldID.getID(rs) : 0L;
            } else {
                depClosures[index] = 0L;
                depFieldIDs[index] = 0L;
            }
            if (obj instanceof Input) {
                Input unbound = (Input)obj;
                if (index < this.mArgs.length) {
                    unbound.addReference(this, index);
                } else {
                    unbound.addReference(this, fid);
                }
                values[index] = 0L;
                sizes[index] = 0;
            } else {
                ValueAndSize vs = new ValueAndSize(rs, obj);
                values[index] = vs.value;
                sizes[index] = vs.size;
            }
        }

        public Future getReturn() {
            if (this.mReturnFuture == null) {
                this.mReturnFuture = new Future(this, null, this.mReturnValue);
            }
            return this.mReturnFuture;
        }

        public Future getGlobal(Script.FieldID field) {
            Future f = this.mGlobalFuture.get(field);
            if (f == null) {
                Object obj = this.mBindings.get(field);
                if (obj instanceof Future) {
                    obj = ((Future)obj).getValue();
                }
                f = new Future(this, field, obj);
                this.mGlobalFuture.put(field, f);
            }
            return f;
        }

        void setArg(int index, Object obj) {
            if (obj instanceof Future) {
                obj = ((Future)obj).getValue();
            }
            this.mArgs[index] = obj;
            ValueAndSize vs = new ValueAndSize(this.mRS, obj);
            this.mRS.nClosureSetArg(this.getID(this.mRS), index, vs.value, vs.size);
        }

        void setGlobal(Script.FieldID fieldID, Object obj) {
            if (obj instanceof Future) {
                obj = ((Future)obj).getValue();
            }
            this.mBindings.put(fieldID, obj);
            ValueAndSize vs = new ValueAndSize(this.mRS, obj);
            this.mRS.nClosureSetGlobal(this.getID(this.mRS), fieldID.getID(this.mRS), vs.value, vs.size);
        }

        private static final class ValueAndSize {
            public long value;
            public int size;

            public ValueAndSize(RenderScript rs, Object obj) {
                if (obj instanceof Allocation) {
                    this.value = ((Allocation)obj).getID(rs);
                    this.size = -1;
                } else if (obj instanceof Boolean) {
                    this.value = (Boolean)obj != false ? 1L : 0L;
                    this.size = 4;
                } else if (obj instanceof Integer) {
                    this.value = ((Integer)obj).longValue();
                    this.size = 4;
                } else if (obj instanceof Long) {
                    this.value = (Long)obj;
                    this.size = 8;
                } else if (obj instanceof Float) {
                    this.value = Float.floatToRawIntBits(((Float)obj).floatValue());
                    this.size = 4;
                } else if (obj instanceof Double) {
                    this.value = Double.doubleToRawLongBits((Double)obj);
                    this.size = 8;
                }
            }
        }
    }

    static class Node {
        Script mScript;
        ArrayList<Script.KernelID> mKernels = new ArrayList();
        ArrayList<ConnectLine> mInputs = new ArrayList();
        ArrayList<ConnectLine> mOutputs = new ArrayList();
        int dagNumber;
        Node mNext;

        Node(Script s) {
            this.mScript = s;
        }
    }

    static class ConnectLine {
        Script.FieldID mToF;
        Script.KernelID mToK;
        Script.KernelID mFrom;
        Type mAllocationType;

        ConnectLine(Type t, Script.KernelID from, Script.KernelID to) {
            this.mFrom = from;
            this.mToK = to;
            this.mAllocationType = t;
        }

        ConnectLine(Type t, Script.KernelID from, Script.FieldID to) {
            this.mFrom = from;
            this.mToF = to;
            this.mAllocationType = t;
        }
    }

    static class IO {
        Script.KernelID mKID;
        Allocation mAllocation;

        IO(Script.KernelID s) {
            this.mKID = s;
        }
    }
}

