/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.content.Context;
import android.content.Loader;
import android.os.Handler;
import android.os.Message;
import android.print.PrintManager;
import android.printservice.recommendation.RecommendationInfo;
import com.android.internal.util.Preconditions;
import java.util.List;

public class PrintServiceRecommendationsLoader
extends Loader<List<RecommendationInfo>> {
    private final PrintManager mPrintManager;
    private final Handler mHandler = new MyHandler();
    private PrintManager.PrintServiceRecommendationsChangeListener mListener;

    public PrintServiceRecommendationsLoader(PrintManager printManager, Context context) {
        super(Preconditions.checkNotNull(context));
        this.mPrintManager = Preconditions.checkNotNull(printManager);
    }

    @Override
    protected void onForceLoad() {
        this.queueNewResult();
    }

    private void queueNewResult() {
        Message m = this.mHandler.obtainMessage(0);
        m.obj = this.mPrintManager.getPrintServiceRecommendations();
        this.mHandler.sendMessage(m);
    }

    @Override
    protected void onStartLoading() {
        this.mListener = new PrintManager.PrintServiceRecommendationsChangeListener(){

            @Override
            public void onPrintServiceRecommendationsChanged() {
                PrintServiceRecommendationsLoader.this.queueNewResult();
            }
        };
        this.mPrintManager.addPrintServiceRecommendationsChangeListener(this.mListener, null);
        this.deliverResult(this.mPrintManager.getPrintServiceRecommendations());
    }

    @Override
    protected void onStopLoading() {
        if (this.mListener != null) {
            this.mPrintManager.removePrintServiceRecommendationsChangeListener(this.mListener);
            this.mListener = null;
        }
        this.mHandler.removeMessages(0);
    }

    @Override
    protected void onReset() {
        this.onStopLoading();
    }

    private class MyHandler
    extends Handler {
        public MyHandler() {
            super(PrintServiceRecommendationsLoader.this.getContext().getMainLooper());
        }

        @Override
        public void handleMessage(Message msg) {
            if (PrintServiceRecommendationsLoader.this.isStarted()) {
                PrintServiceRecommendationsLoader.this.deliverResult((List)msg.obj);
            }
        }
    }
}

