/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.net.nsd.DnsSdTxtRecord;
import android.net.wifi.p2p.nsd.WifiP2pServiceInfo;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class WifiP2pDnsSdServiceInfo
extends WifiP2pServiceInfo {
    public static final int VERSION_1 = 1;
    public static final int DNS_TYPE_PTR = 12;
    public static final int DNS_TYPE_TXT = 16;
    private static final Map<String, String> sVmPacket = new HashMap<String, String>();

    private WifiP2pDnsSdServiceInfo(List<String> queryList) {
        super(queryList);
    }

    public static WifiP2pDnsSdServiceInfo newInstance(String instanceName, String serviceType, Map<String, String> txtMap) {
        if (TextUtils.isEmpty(instanceName) || TextUtils.isEmpty(serviceType)) {
            throw new IllegalArgumentException("instance name or service type cannot be empty");
        }
        DnsSdTxtRecord txtRecord = new DnsSdTxtRecord();
        if (txtMap != null) {
            for (String key : txtMap.keySet()) {
                txtRecord.set(key, txtMap.get(key));
            }
        }
        ArrayList<String> queries = new ArrayList<String>();
        queries.add(WifiP2pDnsSdServiceInfo.createPtrServiceQuery(instanceName, serviceType));
        queries.add(WifiP2pDnsSdServiceInfo.createTxtServiceQuery(instanceName, serviceType, txtRecord));
        return new WifiP2pDnsSdServiceInfo(queries);
    }

    private static String createPtrServiceQuery(String instanceName, String serviceType) {
        StringBuffer sb = new StringBuffer();
        sb.append("bonjour ");
        sb.append(WifiP2pDnsSdServiceInfo.createRequest(serviceType + ".local.", 12, 1));
        sb.append(" ");
        byte[] data = instanceName.getBytes();
        sb.append(String.format(Locale.US, "%02x", data.length));
        sb.append(WifiP2pServiceInfo.bin2HexStr(data));
        sb.append("c027");
        return sb.toString();
    }

    private static String createTxtServiceQuery(String instanceName, String serviceType, DnsSdTxtRecord txtRecord) {
        StringBuffer sb = new StringBuffer();
        sb.append("bonjour ");
        sb.append(WifiP2pDnsSdServiceInfo.createRequest(instanceName + "." + serviceType + ".local.", 16, 1));
        sb.append(" ");
        byte[] rawData = txtRecord.getRawData();
        if (rawData.length == 0) {
            sb.append("00");
        } else {
            sb.append(WifiP2pDnsSdServiceInfo.bin2HexStr(rawData));
        }
        return sb.toString();
    }

    static String createRequest(String dnsName, int dnsType, int version) {
        StringBuffer sb = new StringBuffer();
        if (dnsType == 16) {
            dnsName = dnsName.toLowerCase(Locale.ROOT);
        }
        sb.append(WifiP2pDnsSdServiceInfo.compressDnsName(dnsName));
        sb.append(String.format(Locale.US, "%04x", dnsType));
        sb.append(String.format(Locale.US, "%02x", version));
        return sb.toString();
    }

    private static String compressDnsName(String dnsName) {
        StringBuffer sb = new StringBuffer();
        while (true) {
            String data;
            if ((data = sVmPacket.get(dnsName)) != null) {
                sb.append(data);
                break;
            }
            int i = dnsName.indexOf(46);
            if (i == -1) {
                if (dnsName.length() > 0) {
                    sb.append(String.format(Locale.US, "%02x", dnsName.length()));
                    sb.append(WifiP2pServiceInfo.bin2HexStr(dnsName.getBytes()));
                }
                sb.append("00");
                break;
            }
            String name = dnsName.substring(0, i);
            dnsName = dnsName.substring(i + 1);
            sb.append(String.format(Locale.US, "%02x", name.length()));
            sb.append(WifiP2pServiceInfo.bin2HexStr(name.getBytes()));
        }
        return sb.toString();
    }

    static {
        sVmPacket.put("_tcp.local.", "c00c");
        sVmPacket.put("local.", "c011");
        sVmPacket.put("_udp.local.", "c01c");
    }
}

