/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.INetworkScoreCache;
import android.net.NetworkKey;
import android.net.ScoredNetwork;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Process;
import android.util.Log;
import android.util.LruCache;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;

public class WifiNetworkScoreCache
extends INetworkScoreCache.Stub {
    private static final String TAG = "WifiNetworkScoreCache";
    private static final boolean DBG = Log.isLoggable("WifiNetworkScoreCache", 3);
    public static final int INVALID_NETWORK_SCORE = -128;
    private static final int DEFAULT_MAX_CACHE_SIZE = 100;
    @GuardedBy(value="mLock")
    private CacheListener mListener;
    private final Context mContext;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private final LruCache<String, ScoredNetwork> mCache;

    public WifiNetworkScoreCache(Context context) {
        this(context, null);
    }

    public WifiNetworkScoreCache(Context context, CacheListener listener) {
        this(context, listener, 100);
    }

    public WifiNetworkScoreCache(Context context, CacheListener listener, int maxCacheSize) {
        this.mContext = context.getApplicationContext();
        this.mListener = listener;
        this.mCache = new LruCache(maxCacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateScores(List<ScoredNetwork> networks) {
        if (networks == null || networks.isEmpty()) {
            return;
        }
        if (DBG) {
            Log.d(TAG, "updateScores list size=" + networks.size());
        }
        boolean changed = false;
        Object object = this.mLock;
        synchronized (object) {
            for (ScoredNetwork network : networks) {
                String networkKey = this.buildNetworkKey(network);
                if (networkKey == null) {
                    if (!DBG) continue;
                    Log.d(TAG, "Failed to build network key for ScoredNetwork" + network);
                    continue;
                }
                this.mCache.put(networkKey, network);
                changed = true;
            }
            if (this.mListener != null && changed) {
                this.mListener.post(networks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearScores() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCache.evictAll();
        }
    }

    public boolean isScoredNetwork(ScanResult result) {
        return this.getScoredNetwork(result) != null;
    }

    public boolean hasScoreCurve(ScanResult result) {
        ScoredNetwork network = this.getScoredNetwork(result);
        return network != null && network.rssiCurve != null;
    }

    public int getNetworkScore(ScanResult result) {
        int score = -128;
        ScoredNetwork network = this.getScoredNetwork(result);
        if (network != null && network.rssiCurve != null) {
            score = network.rssiCurve.lookupScore(result.level);
            if (DBG) {
                Log.d(TAG, "getNetworkScore found scored network " + network.networkKey + " score " + Integer.toString(score) + " RSSI " + result.level);
            }
        }
        return score;
    }

    public boolean getMeteredHint(ScanResult result) {
        ScoredNetwork network = this.getScoredNetwork(result);
        return network != null && network.meteredHint;
    }

    public int getNetworkScore(ScanResult result, boolean isActiveNetwork) {
        int score = -128;
        ScoredNetwork network = this.getScoredNetwork(result);
        if (network != null && network.rssiCurve != null) {
            score = network.rssiCurve.lookupScore(result.level, isActiveNetwork);
            if (DBG) {
                Log.d(TAG, "getNetworkScore found scored network " + network.networkKey + " score " + Integer.toString(score) + " RSSI " + result.level + " isActiveNetwork " + isActiveNetwork);
            }
        }
        return score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScoredNetwork getScoredNetwork(ScanResult result) {
        String key = this.buildNetworkKey(result);
        if (key == null) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            ScoredNetwork network = this.mCache.get(key);
            return network;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScoredNetwork getScoredNetwork(NetworkKey networkKey) {
        String key = this.buildNetworkKey(networkKey);
        if (key == null) {
            if (DBG) {
                Log.d(TAG, "Could not build key string for Network Key: " + networkKey);
            }
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            return this.mCache.get(key);
        }
    }

    private String buildNetworkKey(ScoredNetwork network) {
        if (network == null) {
            return null;
        }
        return this.buildNetworkKey(network.networkKey);
    }

    private String buildNetworkKey(NetworkKey networkKey) {
        if (networkKey == null) {
            return null;
        }
        if (networkKey.wifiKey == null) {
            return null;
        }
        if (networkKey.type == 1) {
            String key = networkKey.wifiKey.ssid;
            if (key == null) {
                return null;
            }
            if (networkKey.wifiKey.bssid != null) {
                key = key + networkKey.wifiKey.bssid;
            }
            return key;
        }
        return null;
    }

    private String buildNetworkKey(ScanResult result) {
        if (result == null || result.SSID == null) {
            return null;
        }
        StringBuilder key = new StringBuilder("\"");
        key.append(result.SSID);
        key.append("\"");
        if (result.BSSID != null) {
            key.append(result.BSSID);
        }
        return key.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        String header = String.format("WifiNetworkScoreCache (%s/%d)", this.mContext.getPackageName(), Process.myUid());
        writer.println(header);
        writer.println("  All score curves:");
        Object object = this.mLock;
        synchronized (object) {
            for (ScoredNetwork score : this.mCache.snapshot().values()) {
                writer.println("    " + score);
            }
            writer.println("  Network scores for latest ScanResults:");
            WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
            for (ScanResult scanResult : wifiManager.getScanResults()) {
                writer.println("    " + this.buildNetworkKey(scanResult) + ": " + this.getNetworkScore(scanResult));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(CacheListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = null;
        }
    }

    public static abstract class CacheListener {
        private Handler mHandler;

        public CacheListener(Handler handler) {
            Preconditions.checkNotNull(handler);
            this.mHandler = handler;
        }

        void post(final List<ScoredNetwork> updatedNetworks) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    this.networkCacheUpdated(updatedNetworks);
                }
            });
        }

        public abstract void networkCacheUpdated(List<ScoredNetwork> var1);
    }
}

