/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.os.SystemClock;

public class Stopwatch {
    private long mStartTimeMs;
    private long mStopTimeMs;

    public boolean isStarted() {
        return this.mStartTimeMs > 0L;
    }

    public boolean isStopped() {
        return this.mStopTimeMs > 0L;
    }

    public boolean isRunning() {
        return this.isStarted() && !this.isStopped();
    }

    public Stopwatch start() {
        if (!this.isStarted()) {
            this.mStartTimeMs = SystemClock.elapsedRealtime();
        }
        return this;
    }

    public long stop() {
        if (this.isRunning()) {
            this.mStopTimeMs = SystemClock.elapsedRealtime();
        }
        return this.mStopTimeMs - this.mStartTimeMs;
    }

    public long lap() {
        if (this.isRunning()) {
            return SystemClock.elapsedRealtime() - this.mStartTimeMs;
        }
        return this.stop();
    }

    public void reset() {
        this.mStartTimeMs = 0L;
        this.mStopTimeMs = 0L;
    }
}

