/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.net.INetd;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.Log;

public class NetdService {
    private static final String TAG = NetdService.class.getSimpleName();
    private static final String NETD_SERVICE_NAME = "netd";
    private static final long BASE_TIMEOUT_MS = 100L;
    private static final long MAX_TIMEOUT_MS = 1000L;

    public static INetd getInstance() {
        INetd netdInstance = INetd.Stub.asInterface(ServiceManager.getService(NETD_SERVICE_NAME));
        if (netdInstance == null) {
            Log.w(TAG, "WARNING: returning null INetd instance.");
        }
        return netdInstance;
    }

    public static INetd get(long maxTimeoutMs) {
        if (maxTimeoutMs == 0L) {
            return NetdService.getInstance();
        }
        long stop = maxTimeoutMs > 0L ? SystemClock.elapsedRealtime() + maxTimeoutMs : Long.MAX_VALUE;
        long timeoutMs = 0L;
        while (true) {
            INetd netdInstance;
            if ((netdInstance = NetdService.getInstance()) != null) {
                return netdInstance;
            }
            long remaining = stop - SystemClock.elapsedRealtime();
            if (remaining <= 0L) break;
            timeoutMs = Math.min(timeoutMs + 100L, 1000L);
            timeoutMs = Math.min(timeoutMs, remaining);
            try {
                Thread.sleep(timeoutMs);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    public static INetd get() {
        return NetdService.get(-1L);
    }

    public static void run(NetdCommand cmd) {
        while (true) {
            try {
                cmd.run(NetdService.get());
                return;
            }
            catch (RemoteException re) {
                Log.e(TAG, "error communicating with netd: " + re);
                continue;
            }
            break;
        }
    }

    public static interface NetdCommand {
        public void run(INetd var1) throws RemoteException;
    }
}

