/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.content.Context;
import android.net.LinkProperties;
import android.net.RouteInfo;
import android.net.metrics.IpConnectivityLog;
import android.net.metrics.IpReachabilityEvent;
import android.net.netlink.NetlinkConstants;
import android.net.netlink.NetlinkErrorMessage;
import android.net.netlink.NetlinkMessage;
import android.net.netlink.NetlinkSocket;
import android.net.netlink.RtNetlinkNeighborMessage;
import android.net.netlink.StructNdMsg;
import android.net.util.MultinetworkPolicyTracker;
import android.net.util.SharedLog;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.NetlinkSocketAddress;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.InterruptedIOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IpReachabilityMonitor {
    private static final String TAG = "IpReachabilityMonitor";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private final Object mLock = new Object();
    private final PowerManager.WakeLock mWakeLock;
    private final String mInterfaceName;
    private final int mInterfaceIndex;
    private final SharedLog mLog;
    private final Callback mCallback;
    private final MultinetworkPolicyTracker mMultinetworkPolicyTracker;
    private final NetlinkSocketObserver mNetlinkSocketObserver;
    private final Thread mObserverThread;
    private final IpConnectivityLog mMetricsLog = new IpConnectivityLog();
    @GuardedBy(value="mLock")
    private LinkProperties mLinkProperties = new LinkProperties();
    @GuardedBy(value="mLock")
    private Map<InetAddress, Short> mIpWatchList = new HashMap<InetAddress, Short>();
    @GuardedBy(value="mLock")
    private int mIpWatchListVersion;
    private volatile boolean mRunning;
    private volatile long mLastProbeTimeMs;

    private static int probeNeighbor(int ifIndex, InetAddress ip) {
        String msgSnippet = "probing ip=" + ip.getHostAddress() + "%" + ifIndex;
        byte[] msg = RtNetlinkNeighborMessage.newNewNeighborMessage(1, ip, (short)16, ifIndex, null);
        try {
            NetlinkSocket.sendOneShotKernelMessage(OsConstants.NETLINK_ROUTE, msg);
        }
        catch (ErrnoException e) {
            Log.e(TAG, "Error " + msgSnippet + ": " + e);
            return -e.errno;
        }
        return 0;
    }

    public IpReachabilityMonitor(Context context, String ifName, SharedLog log, Callback callback) {
        this(context, ifName, log, callback, null);
    }

    public IpReachabilityMonitor(Context context, String ifName, SharedLog log, Callback callback, MultinetworkPolicyTracker tracker) throws IllegalArgumentException {
        this.mInterfaceName = ifName;
        int ifIndex = -1;
        try {
            NetworkInterface netIf = NetworkInterface.getByName(ifName);
            this.mInterfaceIndex = netIf.getIndex();
        }
        catch (NullPointerException | SocketException e) {
            throw new IllegalArgumentException("invalid interface '" + ifName + "': ", e);
        }
        this.mWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, "IpReachabilityMonitor." + this.mInterfaceName);
        this.mLog = log.forSubComponent(TAG);
        this.mCallback = callback;
        this.mMultinetworkPolicyTracker = tracker;
        this.mNetlinkSocketObserver = new NetlinkSocketObserver();
        this.mObserverThread = new Thread(this.mNetlinkSocketObserver);
        this.mObserverThread.start();
    }

    public void stop() {
        this.mRunning = false;
        this.clearLinkProperties();
        this.mNetlinkSocketObserver.clearNetlinkSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String describeWatchList() {
        String delimiter = ", ";
        StringBuilder sb = new StringBuilder();
        Object object = this.mLock;
        synchronized (object) {
            sb.append("iface{" + this.mInterfaceName + "/" + this.mInterfaceIndex + "}, ");
            sb.append("v{" + this.mIpWatchListVersion + "}, ");
            sb.append("ntable=[");
            boolean firstTime = true;
            for (Map.Entry<InetAddress, Short> entry : this.mIpWatchList.entrySet()) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    sb.append(", ");
                }
                sb.append(entry.getKey().getHostAddress() + "/" + StructNdMsg.stringForNudState(entry.getValue()));
            }
            sb.append("]");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWatching(InetAddress ip) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRunning && this.mIpWatchList.containsKey(ip);
        }
    }

    private static boolean isOnLink(List<RouteInfo> routes, InetAddress ip) {
        for (RouteInfo route : routes) {
            if (route.hasGateway() || !route.matches(ip)) continue;
            return true;
        }
        return false;
    }

    private short getNeighborStateLocked(InetAddress ip) {
        if (this.mIpWatchList.containsKey(ip)) {
            return this.mIpWatchList.get(ip);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLinkProperties(LinkProperties lp) {
        if (!this.mInterfaceName.equals(lp.getInterfaceName())) {
            Log.wtf(TAG, "requested LinkProperties interface '" + lp.getInterfaceName() + "' does not match: " + this.mInterfaceName);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mLinkProperties = new LinkProperties(lp);
            HashMap<InetAddress, Short> newIpWatchList = new HashMap<InetAddress, Short>();
            List<RouteInfo> routes = this.mLinkProperties.getRoutes();
            for (RouteInfo route : routes) {
                InetAddress gw;
                if (!route.hasGateway() || !IpReachabilityMonitor.isOnLink(routes, gw = route.getGateway())) continue;
                newIpWatchList.put(gw, this.getNeighborStateLocked(gw));
            }
            for (InetAddress nameserver : lp.getDnsServers()) {
                if (!IpReachabilityMonitor.isOnLink(routes, nameserver)) continue;
                newIpWatchList.put(nameserver, this.getNeighborStateLocked(nameserver));
            }
            this.mIpWatchList = newIpWatchList;
            ++this.mIpWatchListVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLinkProperties() {
        Object object = this.mLock;
        synchronized (object) {
            this.mLinkProperties.clear();
            this.mIpWatchList.clear();
            ++this.mIpWatchListVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNeighborLost(String msg) {
        LinkProperties.ProvisioningChange delta;
        InetAddress ip = null;
        Object object = this.mLock;
        synchronized (object) {
            LinkProperties whatIfLp = new LinkProperties(this.mLinkProperties);
            for (Map.Entry<InetAddress, Short> entry : this.mIpWatchList.entrySet()) {
                if (entry.getValue() != 32) continue;
                ip = entry.getKey();
                for (RouteInfo route : this.mLinkProperties.getRoutes()) {
                    if (!ip.equals(route.getGateway())) continue;
                    whatIfLp.removeRoute(route);
                }
                if (!this.avoidingBadLinks() && ip instanceof Inet6Address) continue;
                whatIfLp.removeDnsServer(ip);
            }
            delta = LinkProperties.compareProvisioning(this.mLinkProperties, whatIfLp);
        }
        if (delta == LinkProperties.ProvisioningChange.LOST_PROVISIONING) {
            String logMsg = "FAILURE: LOST_PROVISIONING, " + msg;
            Log.w(TAG, logMsg);
            if (this.mCallback != null) {
                this.mCallback.notifyLost(ip, logMsg);
            }
        }
        this.logNudFailed(delta);
    }

    private boolean avoidingBadLinks() {
        return this.mMultinetworkPolicyTracker == null || this.mMultinetworkPolicyTracker.getAvoidBadWifi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void probeAll() {
        ArrayList<InetAddress> ipProbeList;
        Iterator iterator = this.mLock;
        synchronized (iterator) {
            ipProbeList = new ArrayList<InetAddress>(this.mIpWatchList.keySet());
        }
        if (!ipProbeList.isEmpty() && this.mRunning) {
            this.mWakeLock.acquire(IpReachabilityMonitor.getProbeWakeLockDuration());
        }
        for (InetAddress target : ipProbeList) {
            if (!this.mRunning) break;
            int returnValue = IpReachabilityMonitor.probeNeighbor(this.mInterfaceIndex, target);
            this.mLog.log(String.format("put neighbor %s into NUD_PROBE state (rval=%d)", target.getHostAddress(), returnValue));
            this.logEvent(256, returnValue);
        }
        this.mLastProbeTimeMs = SystemClock.elapsedRealtime();
    }

    private static long getProbeWakeLockDuration() {
        long numUnicastProbes = 3L;
        long retransTimeMs = 1000L;
        long gracePeriodMs = 500L;
        return 3500L;
    }

    private void logEvent(int probeType, int errorCode) {
        int eventType = probeType | errorCode & 0xFF;
        this.mMetricsLog.log(this.mInterfaceName, (Parcelable)new IpReachabilityEvent(eventType));
    }

    private void logNudFailed(LinkProperties.ProvisioningChange delta) {
        long duration = SystemClock.elapsedRealtime() - this.mLastProbeTimeMs;
        boolean isFromProbe = duration < IpReachabilityMonitor.getProbeWakeLockDuration();
        boolean isProvisioningLost = delta == LinkProperties.ProvisioningChange.LOST_PROVISIONING;
        int eventType = IpReachabilityEvent.nudFailureEventType(isFromProbe, isProvisioningLost);
        this.mMetricsLog.log(this.mInterfaceName, (Parcelable)new IpReachabilityEvent(eventType));
    }

    private final class NetlinkSocketObserver
    implements Runnable {
        private NetlinkSocket mSocket;

        private NetlinkSocketObserver() {
        }

        @Override
        public void run() {
            IpReachabilityMonitor.this.mRunning = true;
            try {
                this.setupNetlinkSocket();
            }
            catch (ErrnoException | SocketException e) {
                Log.e(IpReachabilityMonitor.TAG, "Failed to suitably initialize a netlink socket", e);
                IpReachabilityMonitor.this.mRunning = false;
            }
            while (IpReachabilityMonitor.this.mRunning) {
                ByteBuffer byteBuffer;
                try {
                    byteBuffer = this.recvKernelReply();
                }
                catch (ErrnoException e) {
                    if (!IpReachabilityMonitor.this.mRunning) break;
                    Log.w(IpReachabilityMonitor.TAG, "ErrnoException: ", e);
                    break;
                }
                long whenMs = SystemClock.elapsedRealtime();
                if (byteBuffer == null) continue;
                this.parseNetlinkMessageBuffer(byteBuffer, whenMs);
            }
            this.clearNetlinkSocket();
            IpReachabilityMonitor.this.mRunning = false;
        }

        private void clearNetlinkSocket() {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }

        private void setupNetlinkSocket() throws ErrnoException, SocketException {
            this.clearNetlinkSocket();
            this.mSocket = new NetlinkSocket(OsConstants.NETLINK_ROUTE);
            NetlinkSocketAddress listenAddr = new NetlinkSocketAddress(0, OsConstants.RTMGRP_NEIGH);
            this.mSocket.bind(listenAddr);
        }

        private ByteBuffer recvKernelReply() throws ErrnoException {
            block3: {
                try {
                    return this.mSocket.recvMessage(0L);
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (ErrnoException e) {
                    if (e.errno == OsConstants.EAGAIN) break block3;
                    throw e;
                }
            }
            return null;
        }

        private void parseNetlinkMessageBuffer(ByteBuffer byteBuffer, long whenMs) {
            while (byteBuffer.remaining() > 0) {
                int position = byteBuffer.position();
                NetlinkMessage nlMsg = NetlinkMessage.parse(byteBuffer);
                if (nlMsg == null || nlMsg.getHeader() == null) {
                    byteBuffer.position(position);
                    Log.e(IpReachabilityMonitor.TAG, "unparsable netlink msg: " + NetlinkConstants.hexify(byteBuffer));
                    break;
                }
                int srcPortId = nlMsg.getHeader().nlmsg_pid;
                if (srcPortId != 0) {
                    Log.e(IpReachabilityMonitor.TAG, "non-kernel source portId: " + (long)(srcPortId & 0xFFFFFFFF));
                    break;
                }
                if (nlMsg instanceof NetlinkErrorMessage) {
                    Log.e(IpReachabilityMonitor.TAG, "netlink error: " + nlMsg);
                    continue;
                }
                if (!(nlMsg instanceof RtNetlinkNeighborMessage)) continue;
                this.evaluateRtNetlinkNeighborMessage((RtNetlinkNeighborMessage)nlMsg, whenMs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void evaluateRtNetlinkNeighborMessage(RtNetlinkNeighborMessage neighMsg, long whenMs) {
            StructNdMsg ndMsg = neighMsg.getNdHeader();
            if (ndMsg == null || ndMsg.ndm_ifindex != IpReachabilityMonitor.this.mInterfaceIndex) {
                return;
            }
            InetAddress destination = neighMsg.getDestination();
            if (!IpReachabilityMonitor.this.isWatching(destination)) {
                return;
            }
            short msgType = neighMsg.getHeader().nlmsg_type;
            short nudState = ndMsg.ndm_state;
            String eventMsg = "NeighborEvent{elapsedMs=" + whenMs + ", " + destination.getHostAddress() + ", " + "[" + NetlinkConstants.hexify(neighMsg.getLinkLayerAddress()) + "], " + NetlinkConstants.stringForNlMsgType(msgType) + ", " + StructNdMsg.stringForNudState(nudState) + "}";
            Object object = IpReachabilityMonitor.this.mLock;
            synchronized (object) {
                if (IpReachabilityMonitor.this.mIpWatchList.containsKey(destination)) {
                    short value = msgType == 29 ? (short)0 : nudState;
                    IpReachabilityMonitor.this.mIpWatchList.put(destination, value);
                }
            }
            if (nudState == 32) {
                Log.w(IpReachabilityMonitor.TAG, "ALERT: " + eventMsg);
                IpReachabilityMonitor.this.handleNeighborLost(eventMsg);
            }
        }
    }

    public static interface Callback {
        public void notifyLost(InetAddress var1, String var2);
    }
}

