/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.IIpSecService;
import android.net.IpSecAlgorithm;
import android.net.IpSecConfig;
import android.net.IpSecManager;
import android.net.IpSecTransformResponse;
import android.net.Network;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.util.Preconditions;
import dalvik.system.CloseGuard;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;

public final class IpSecTransform
implements AutoCloseable {
    private static final String TAG = "IpSecTransform";
    public static final int DIRECTION_IN = 0;
    public static final int DIRECTION_OUT = 1;
    private static final int MODE_TUNNEL = 0;
    private static final int MODE_TRANSPORT = 1;
    public static final int ENCAP_NONE = 0;
    public static final int ENCAP_ESPINUDP_NON_IKE = 1;
    public static final int ENCAP_ESPINUDP = 2;
    private final IpSecConfig mConfig;
    private int mResourceId;
    private final Context mContext;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private ConnectivityManager.PacketKeepalive mKeepalive;
    private int mKeepaliveStatus = -1;
    private Object mKeepaliveSyncLock = new Object();
    private ConnectivityManager.PacketKeepaliveCallback mKeepaliveCallback = new ConnectivityManager.PacketKeepaliveCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStarted() {
            Object object = IpSecTransform.this.mKeepaliveSyncLock;
            synchronized (object) {
                IpSecTransform.this.mKeepaliveStatus = 0;
                IpSecTransform.this.mKeepaliveSyncLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStopped() {
            Object object = IpSecTransform.this.mKeepaliveSyncLock;
            synchronized (object) {
                IpSecTransform.this.mKeepaliveStatus = -1;
                IpSecTransform.this.mKeepaliveSyncLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(int error) {
            Object object = IpSecTransform.this.mKeepaliveSyncLock;
            synchronized (object) {
                IpSecTransform.this.mKeepaliveStatus = error;
                IpSecTransform.this.mKeepaliveSyncLock.notifyAll();
            }
        }
    };

    private IpSecTransform(Context context, IpSecConfig config) {
        this.mContext = context;
        this.mConfig = config;
        this.mResourceId = 0;
    }

    private IIpSecService getIpSecService() {
        IBinder b = ServiceManager.getService("ipsec");
        if (b == null) {
            throw new RemoteException("Failed to connect to IpSecService").rethrowAsRuntimeException();
        }
        return IIpSecService.Stub.asInterface(b);
    }

    private void checkResultStatusAndThrow(int status) throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        switch (status) {
            case 0: {
                return;
            }
            case 1: {
                throw new IpSecManager.ResourceUnavailableException("Failed to allocate a new IpSecTransform");
            }
            case 2: {
                Log.wtf(TAG, "Attempting to use an SPI that was somehow not reserved");
            }
        }
        throw new IllegalStateException("Failed to Create a Transform with status code " + status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IpSecTransform activate() throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        IpSecTransform ipSecTransform = this;
        synchronized (ipSecTransform) {
            try {
                IIpSecService svc = this.getIpSecService();
                IpSecTransformResponse result = svc.createTransportModeTransform(this.mConfig, new Binder());
                int status = result.status;
                this.checkResultStatusAndThrow(status);
                this.mResourceId = result.resourceId;
                this.startKeepalive(this.mContext);
                Log.d(TAG, "Added Transform with Id " + this.mResourceId);
                this.mCloseGuard.open("build");
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
        return this;
    }

    @Override
    public void close() {
        Log.d(TAG, "Removing Transform with Id " + this.mResourceId);
        if (this.mResourceId == 0) {
            this.mCloseGuard.close();
            return;
        }
        try {
            IIpSecService svc = this.getIpSecService();
            svc.deleteTransportModeTransform(this.mResourceId);
            this.stopKeepalive();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        finally {
            this.mResourceId = 0;
            this.mCloseGuard.close();
        }
    }

    protected void finalize() throws Throwable {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.close();
    }

    IpSecConfig getConfig() {
        return this.mConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startKeepalive(Context c) {
        if (this.mConfig.getNattKeepaliveInterval() == 0) {
            return;
        }
        ConnectivityManager cm = (ConnectivityManager)c.getSystemService("connectivity");
        if (this.mKeepalive != null) {
            Log.wtf(TAG, "Keepalive already started for this IpSecTransform.");
            return;
        }
        Object object = this.mKeepaliveSyncLock;
        synchronized (object) {
            this.mKeepalive = cm.startNattKeepalive(this.mConfig.getNetwork(), this.mConfig.getNattKeepaliveInterval(), this.mKeepaliveCallback, this.mConfig.getLocalAddress(), 4660, this.mConfig.getRemoteAddress());
            try {
                this.mKeepaliveSyncLock.wait(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.mKeepaliveStatus != 0) {
            throw new UnsupportedOperationException("Packet Keepalive cannot be started");
        }
    }

    int getResourceId() {
        return this.mResourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopKeepalive() {
        if (this.mKeepalive == null) {
            return;
        }
        this.mKeepalive.stop();
        Object object = this.mKeepaliveSyncLock;
        synchronized (object) {
            if (this.mKeepaliveStatus == 0) {
                try {
                    this.mKeepaliveSyncLock.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static class Builder {
        private Context mContext;
        private IpSecConfig mConfig;

        public Builder setEncryption(int direction, IpSecAlgorithm algo) {
            this.mConfig.flow[direction].encryption = algo;
            return this;
        }

        public Builder setAuthentication(int direction, IpSecAlgorithm algo) {
            this.mConfig.flow[direction].authentication = algo;
            return this;
        }

        public Builder setSpi(int direction, IpSecManager.SecurityParameterIndex spi) {
            this.mConfig.flow[direction].spiResourceId = spi.getResourceId();
            return this;
        }

        public Builder setUnderlyingNetwork(Network net) {
            this.mConfig.network = net;
            return this;
        }

        public Builder setIpv4Encapsulation(IpSecManager.UdpEncapsulationSocket localSocket, int remotePort) {
            this.mConfig.encapType = 2;
            this.mConfig.encapLocalPortResourceId = localSocket.getResourceId();
            this.mConfig.encapRemotePort = remotePort;
            return this;
        }

        public Builder setNattKeepalive(int intervalSeconds) {
            this.mConfig.nattKeepaliveInterval = intervalSeconds;
            return this;
        }

        public IpSecTransform buildTransportModeTransform(InetAddress remoteAddress) throws IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException, IOException {
            this.mConfig.mode = 1;
            this.mConfig.remoteAddress = remoteAddress;
            return new IpSecTransform(this.mContext, this.mConfig).activate();
        }

        public IpSecTransform buildTunnelModeTransform(InetAddress localAddress, InetAddress remoteAddress) {
            this.mConfig.localAddress = localAddress;
            this.mConfig.remoteAddress = remoteAddress;
            this.mConfig.mode = 0;
            return new IpSecTransform(this.mContext, this.mConfig);
        }

        public Builder(Context context) {
            Preconditions.checkNotNull(context);
            this.mContext = context;
            this.mConfig = new IpSecConfig();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EncapType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TransformDirection {
    }
}

