/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.media.PlaybackParams;
import android.media.tv.ITvInputService;
import android.media.tv.ITvInputServiceCallback;
import android.media.tv.ITvInputSession;
import android.media.tv.ITvInputSessionCallback;
import android.media.tv.ITvInputSessionWrapper;
import android.media.tv.TvContentRating;
import android.media.tv.TvContract;
import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvInputInfo;
import android.media.tv.TvInputManager;
import android.media.tv.TvTrackInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;

public abstract class TvInputService
extends Service {
    private static final boolean DEBUG = false;
    private static final String TAG = "TvInputService";
    private static final int DETACH_OVERLAY_VIEW_TIMEOUT_MS = 5000;
    public static final String SERVICE_INTERFACE = "android.media.tv.TvInputService";
    public static final String SERVICE_META_DATA = "android.media.tv.input";
    private final Handler mServiceHandler = new ServiceHandler();
    private final RemoteCallbackList<ITvInputServiceCallback> mCallbacks = new RemoteCallbackList();
    private TvInputManager mTvInputManager;

    @Override
    public final IBinder onBind(Intent intent) {
        return new ITvInputService.Stub(){

            @Override
            public void registerCallback(ITvInputServiceCallback cb) {
                if (cb != null) {
                    TvInputService.this.mCallbacks.register(cb);
                }
            }

            @Override
            public void unregisterCallback(ITvInputServiceCallback cb) {
                if (cb != null) {
                    TvInputService.this.mCallbacks.unregister(cb);
                }
            }

            @Override
            public void createSession(InputChannel channel, ITvInputSessionCallback cb, String inputId) {
                if (channel == null) {
                    Log.w(TvInputService.TAG, "Creating session without input channel");
                }
                if (cb == null) {
                    return;
                }
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = channel;
                args.arg2 = cb;
                args.arg3 = inputId;
                TvInputService.this.mServiceHandler.obtainMessage(1, args).sendToTarget();
            }

            @Override
            public void createRecordingSession(ITvInputSessionCallback cb, String inputId) {
                if (cb == null) {
                    return;
                }
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = cb;
                args.arg2 = inputId;
                TvInputService.this.mServiceHandler.obtainMessage(3, args).sendToTarget();
            }

            @Override
            public void notifyHardwareAdded(TvInputHardwareInfo hardwareInfo) {
                TvInputService.this.mServiceHandler.obtainMessage(4, hardwareInfo).sendToTarget();
            }

            @Override
            public void notifyHardwareRemoved(TvInputHardwareInfo hardwareInfo) {
                TvInputService.this.mServiceHandler.obtainMessage(5, hardwareInfo).sendToTarget();
            }

            @Override
            public void notifyHdmiDeviceAdded(HdmiDeviceInfo deviceInfo) {
                TvInputService.this.mServiceHandler.obtainMessage(6, deviceInfo).sendToTarget();
            }

            @Override
            public void notifyHdmiDeviceRemoved(HdmiDeviceInfo deviceInfo) {
                TvInputService.this.mServiceHandler.obtainMessage(7, deviceInfo).sendToTarget();
            }
        };
    }

    public abstract Session onCreateSession(String var1);

    public RecordingSession onCreateRecordingSession(String inputId) {
        return null;
    }

    public TvInputInfo onHardwareAdded(TvInputHardwareInfo hardwareInfo) {
        return null;
    }

    public String onHardwareRemoved(TvInputHardwareInfo hardwareInfo) {
        return null;
    }

    public TvInputInfo onHdmiDeviceAdded(HdmiDeviceInfo deviceInfo) {
        return null;
    }

    public String onHdmiDeviceRemoved(HdmiDeviceInfo deviceInfo) {
        return null;
    }

    private boolean isPassthroughInput(String inputId) {
        TvInputInfo info;
        if (this.mTvInputManager == null) {
            this.mTvInputManager = (TvInputManager)this.getSystemService("tv_input");
        }
        return (info = this.mTvInputManager.getTvInputInfo(inputId)) != null && info.isPassthroughInput();
    }

    public static boolean isNavigationKey(int keyCode) {
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 61: 
            case 62: 
            case 66: 
            case 92: 
            case 93: 
            case 122: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    @SuppressLint(value={"HandlerLeak"})
    private final class ServiceHandler
    extends Handler {
        private static final int DO_CREATE_SESSION = 1;
        private static final int DO_NOTIFY_SESSION_CREATED = 2;
        private static final int DO_CREATE_RECORDING_SESSION = 3;
        private static final int DO_ADD_HARDWARE_INPUT = 4;
        private static final int DO_REMOVE_HARDWARE_INPUT = 5;
        private static final int DO_ADD_HDMI_INPUT = 6;
        private static final int DO_REMOVE_HDMI_INPUT = 7;

        private ServiceHandler() {
        }

        private void broadcastAddHardwareInput(int deviceId, TvInputInfo inputInfo) {
            int n = TvInputService.this.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                try {
                    ((ITvInputServiceCallback)TvInputService.this.mCallbacks.getBroadcastItem(i)).addHardwareInput(deviceId, inputInfo);
                    continue;
                }
                catch (RemoteException e) {
                    Log.e(TvInputService.TAG, "error in broadcastAddHardwareInput", e);
                }
            }
            TvInputService.this.mCallbacks.finishBroadcast();
        }

        private void broadcastAddHdmiInput(int id2, TvInputInfo inputInfo) {
            int n = TvInputService.this.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                try {
                    ((ITvInputServiceCallback)TvInputService.this.mCallbacks.getBroadcastItem(i)).addHdmiInput(id2, inputInfo);
                    continue;
                }
                catch (RemoteException e) {
                    Log.e(TvInputService.TAG, "error in broadcastAddHdmiInput", e);
                }
            }
            TvInputService.this.mCallbacks.finishBroadcast();
        }

        private void broadcastRemoveHardwareInput(String inputId) {
            int n = TvInputService.this.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                try {
                    ((ITvInputServiceCallback)TvInputService.this.mCallbacks.getBroadcastItem(i)).removeHardwareInput(inputId);
                    continue;
                }
                catch (RemoteException e) {
                    Log.e(TvInputService.TAG, "error in broadcastRemoveHardwareInput", e);
                }
            }
            TvInputService.this.mCallbacks.finishBroadcast();
        }

        @Override
        public final void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    InputChannel channel = (InputChannel)args.arg1;
                    ITvInputSessionCallback cb = (ITvInputSessionCallback)args.arg2;
                    String inputId = (String)args.arg3;
                    args.recycle();
                    Session sessionImpl = TvInputService.this.onCreateSession(inputId);
                    if (sessionImpl == null) {
                        try {
                            cb.onSessionCreated(null, null);
                        }
                        catch (RemoteException e) {
                            Log.e(TvInputService.TAG, "error in onSessionCreated", e);
                        }
                        return;
                    }
                    ITvInputSessionWrapper stub = new ITvInputSessionWrapper(TvInputService.this, sessionImpl, channel);
                    if (sessionImpl instanceof HardwareSession) {
                        HardwareSession proxySession = (HardwareSession)sessionImpl;
                        String hardwareInputId = proxySession.getHardwareInputId();
                        if (TextUtils.isEmpty(hardwareInputId) || !TvInputService.this.isPassthroughInput(hardwareInputId)) {
                            if (TextUtils.isEmpty(hardwareInputId)) {
                                Log.w(TvInputService.TAG, "Hardware input id is not setup yet.");
                            } else {
                                Log.w(TvInputService.TAG, "Invalid hardware input id : " + hardwareInputId);
                            }
                            sessionImpl.onRelease();
                            try {
                                cb.onSessionCreated(null, null);
                            }
                            catch (RemoteException e) {
                                Log.e(TvInputService.TAG, "error in onSessionCreated", e);
                            }
                            return;
                        }
                        proxySession.mProxySession = stub;
                        proxySession.mProxySessionCallback = cb;
                        proxySession.mServiceHandler = TvInputService.this.mServiceHandler;
                        TvInputManager manager = (TvInputManager)TvInputService.this.getSystemService("tv_input");
                        manager.createSession(hardwareInputId, proxySession.mHardwareSessionCallback, TvInputService.this.mServiceHandler);
                    } else {
                        SomeArgs someArgs = SomeArgs.obtain();
                        someArgs.arg1 = sessionImpl;
                        someArgs.arg2 = stub;
                        someArgs.arg3 = cb;
                        someArgs.arg4 = null;
                        TvInputService.this.mServiceHandler.obtainMessage(2, someArgs).sendToTarget();
                    }
                    return;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Session sessionImpl = (Session)args.arg1;
                    ITvInputSession stub = (ITvInputSession)args.arg2;
                    ITvInputSessionCallback cb = (ITvInputSessionCallback)args.arg3;
                    IBinder hardwareSessionToken = (IBinder)args.arg4;
                    try {
                        cb.onSessionCreated(stub, hardwareSessionToken);
                    }
                    catch (RemoteException e) {
                        Log.e(TvInputService.TAG, "error in onSessionCreated", e);
                    }
                    if (sessionImpl != null) {
                        sessionImpl.initialize(cb);
                    }
                    args.recycle();
                    return;
                }
                case 3: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    ITvInputSessionCallback cb = (ITvInputSessionCallback)args.arg1;
                    String inputId = (String)args.arg2;
                    args.recycle();
                    RecordingSession recordingSessionImpl = TvInputService.this.onCreateRecordingSession(inputId);
                    if (recordingSessionImpl == null) {
                        try {
                            cb.onSessionCreated(null, null);
                        }
                        catch (RemoteException e) {
                            Log.e(TvInputService.TAG, "error in onSessionCreated", e);
                        }
                        return;
                    }
                    ITvInputSessionWrapper stub = new ITvInputSessionWrapper(TvInputService.this, recordingSessionImpl);
                    try {
                        cb.onSessionCreated(stub, null);
                    }
                    catch (RemoteException e) {
                        Log.e(TvInputService.TAG, "error in onSessionCreated", e);
                    }
                    recordingSessionImpl.initialize(cb);
                    return;
                }
                case 4: {
                    TvInputHardwareInfo hardwareInfo = (TvInputHardwareInfo)msg.obj;
                    TvInputInfo inputInfo = TvInputService.this.onHardwareAdded(hardwareInfo);
                    if (inputInfo != null) {
                        this.broadcastAddHardwareInput(hardwareInfo.getDeviceId(), inputInfo);
                    }
                    return;
                }
                case 5: {
                    TvInputHardwareInfo hardwareInfo = (TvInputHardwareInfo)msg.obj;
                    String inputId = TvInputService.this.onHardwareRemoved(hardwareInfo);
                    if (inputId != null) {
                        this.broadcastRemoveHardwareInput(inputId);
                    }
                    return;
                }
                case 6: {
                    HdmiDeviceInfo deviceInfo = (HdmiDeviceInfo)msg.obj;
                    TvInputInfo inputInfo = TvInputService.this.onHdmiDeviceAdded(deviceInfo);
                    if (inputInfo != null) {
                        this.broadcastAddHdmiInput(deviceInfo.getId(), inputInfo);
                    }
                    return;
                }
                case 7: {
                    HdmiDeviceInfo deviceInfo = (HdmiDeviceInfo)msg.obj;
                    String inputId = TvInputService.this.onHdmiDeviceRemoved(deviceInfo);
                    if (inputId != null) {
                        this.broadcastRemoveHardwareInput(inputId);
                    }
                    return;
                }
            }
            Log.w(TvInputService.TAG, "Unhandled message code: " + msg.what);
        }
    }

    public static abstract class HardwareSession
    extends Session {
        private TvInputManager.Session mHardwareSession;
        private ITvInputSession mProxySession;
        private ITvInputSessionCallback mProxySessionCallback;
        private Handler mServiceHandler;
        private final TvInputManager.SessionCallback mHardwareSessionCallback = new TvInputManager.SessionCallback(){

            @Override
            public void onSessionCreated(TvInputManager.Session session) {
                mHardwareSession = session;
                SomeArgs args = SomeArgs.obtain();
                if (session != null) {
                    args.arg1 = this;
                    args.arg2 = mProxySession;
                    args.arg3 = mProxySessionCallback;
                    args.arg4 = session.getToken();
                    session.tune(TvContract.buildChannelUriForPassthroughInput(this.getHardwareInputId()));
                } else {
                    args.arg1 = null;
                    args.arg2 = null;
                    args.arg3 = mProxySessionCallback;
                    args.arg4 = null;
                    this.onRelease();
                }
                mServiceHandler.obtainMessage(2, args).sendToTarget();
            }

            @Override
            public void onVideoAvailable(TvInputManager.Session session) {
                if (mHardwareSession == session) {
                    this.onHardwareVideoAvailable();
                }
            }

            @Override
            public void onVideoUnavailable(TvInputManager.Session session, int reason) {
                if (mHardwareSession == session) {
                    this.onHardwareVideoUnavailable(reason);
                }
            }
        };

        public HardwareSession(Context context) {
            super(context);
        }

        public abstract String getHardwareInputId();

        @Override
        public final boolean onSetSurface(Surface surface) {
            Log.e(TvInputService.TAG, "onSetSurface() should not be called in HardwareProxySession.");
            return false;
        }

        public void onHardwareVideoAvailable() {
        }

        public void onHardwareVideoUnavailable(int reason) {
        }

        @Override
        void release() {
            if (this.mHardwareSession != null) {
                this.mHardwareSession.release();
                this.mHardwareSession = null;
            }
            super.release();
        }
    }

    public static abstract class RecordingSession {
        final Handler mHandler;
        private final Object mLock = new Object();
        private ITvInputSessionCallback mSessionCallback;
        private final List<Runnable> mPendingActions = new ArrayList<Runnable>();

        public RecordingSession(Context context) {
            this.mHandler = new Handler(context.getMainLooper());
        }

        public void notifyTuned(final Uri channelUri) {
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onTuned(channelUri);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyTuned", e);
                    }
                }
            });
        }

        public void notifyRecordingStopped(final Uri recordedProgramUri) {
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onRecordingStopped(recordedProgramUri);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyRecordingStopped", e);
                    }
                }
            });
        }

        public void notifyError(int error) {
            if (error < 0 || error > 2) {
                Log.w(TvInputService.TAG, "notifyError - invalid error code (" + error + ") is changed to RECORDING_ERROR_UNKNOWN.");
                error = 0;
            }
            final int validError = error;
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onError(validError);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyError", e);
                    }
                }
            });
        }

        public void notifySessionEvent(final String eventType, final Bundle eventArgs) {
            Preconditions.checkNotNull(eventType);
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onSessionEvent(eventType, eventArgs);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in sending event (event=" + eventType + ")", e);
                    }
                }
            });
        }

        public abstract void onTune(Uri var1);

        public void onTune(Uri channelUri, Bundle params) {
            this.onTune(channelUri);
        }

        public abstract void onStartRecording(Uri var1);

        public abstract void onStopRecording();

        public abstract void onRelease();

        public void onAppPrivateCommand(String action, Bundle data) {
        }

        void tune(Uri channelUri, Bundle params) {
            this.onTune(channelUri, params);
        }

        void release() {
            this.onRelease();
        }

        void startRecording(Uri programUri) {
            this.onStartRecording(programUri);
        }

        void stopRecording() {
            this.onStopRecording();
        }

        void appPrivateCommand(String action, Bundle data) {
            this.onAppPrivateCommand(action, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize(ITvInputSessionCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mSessionCallback = callback;
                for (Runnable runnable : this.mPendingActions) {
                    runnable.run();
                }
                this.mPendingActions.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeOrPostRunnableOnMainThread(Runnable action) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSessionCallback == null) {
                    this.mPendingActions.add(action);
                } else if (this.mHandler.getLooper().isCurrentThread()) {
                    action.run();
                } else {
                    this.mHandler.post(action);
                }
            }
        }
    }

    private static final class OverlayViewCleanUpTask
    extends AsyncTask<View, Void, Void> {
        private OverlayViewCleanUpTask() {
        }

        protected Void doInBackground(View ... views) {
            View overlayViewParent = views[0];
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                return null;
            }
            if (this.isCancelled()) {
                return null;
            }
            if (overlayViewParent.isAttachedToWindow()) {
                Log.e(TvInputService.TAG, "Time out on releasing overlay view. Killing " + overlayViewParent.getContext().getPackageName());
                Process.killProcess(Process.myPid());
            }
            return null;
        }
    }

    public static abstract class Session
    implements KeyEvent.Callback {
        private static final int POSITION_UPDATE_INTERVAL_MS = 1000;
        private final KeyEvent.DispatcherState mDispatcherState = new KeyEvent.DispatcherState();
        private final WindowManager mWindowManager;
        final Handler mHandler;
        private WindowManager.LayoutParams mWindowParams;
        private Surface mSurface;
        private final Context mContext;
        private FrameLayout mOverlayViewContainer;
        private View mOverlayView;
        private OverlayViewCleanUpTask mOverlayViewCleanUpTask;
        private boolean mOverlayViewEnabled;
        private IBinder mWindowToken;
        private Rect mOverlayFrame;
        private long mStartPositionMs = Long.MIN_VALUE;
        private long mCurrentPositionMs = Long.MIN_VALUE;
        private final TimeShiftPositionTrackingRunnable mTimeShiftPositionTrackingRunnable = new TimeShiftPositionTrackingRunnable();
        private final Object mLock = new Object();
        private ITvInputSessionCallback mSessionCallback;
        private final List<Runnable> mPendingActions = new ArrayList<Runnable>();

        public Session(Context context) {
            this.mContext = context;
            this.mWindowManager = (WindowManager)context.getSystemService("window");
            this.mHandler = new Handler(context.getMainLooper());
        }

        public void setOverlayViewEnabled(final boolean enable) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (enable == mOverlayViewEnabled) {
                        return;
                    }
                    mOverlayViewEnabled = enable;
                    if (enable) {
                        if (mWindowToken != null) {
                            this.createOverlayView(mWindowToken, mOverlayFrame);
                        }
                    } else {
                        this.removeOverlayView(false);
                    }
                }
            });
        }

        public void notifySessionEvent(final String eventType, final Bundle eventArgs) {
            Preconditions.checkNotNull(eventType);
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onSessionEvent(eventType, eventArgs);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in sending event (event=" + eventType + ")", e);
                    }
                }
            });
        }

        public void notifyChannelRetuned(final Uri channelUri) {
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onChannelRetuned(channelUri);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyChannelRetuned", e);
                    }
                }
            });
        }

        public void notifyTracksChanged(List<TvTrackInfo> tracks) {
            final ArrayList<TvTrackInfo> tracksCopy = new ArrayList<TvTrackInfo>(tracks);
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onTracksChanged(tracksCopy);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyTracksChanged", e);
                    }
                }
            });
        }

        public void notifyTrackSelected(final int type, final String trackId) {
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onTrackSelected(type, trackId);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyTrackSelected", e);
                    }
                }
            });
        }

        public void notifyVideoAvailable() {
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onVideoAvailable();
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyVideoAvailable", e);
                    }
                }
            });
        }

        public void notifyVideoUnavailable(final int reason) {
            if (reason < 0 || reason > 4) {
                Log.e(TvInputService.TAG, "notifyVideoUnavailable - unknown reason: " + reason);
            }
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onVideoUnavailable(reason);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyVideoUnavailable", e);
                    }
                }
            });
        }

        public void notifyContentAllowed() {
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onContentAllowed();
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyContentAllowed", e);
                    }
                }
            });
        }

        public void notifyContentBlocked(final TvContentRating rating) {
            Preconditions.checkNotNull(rating);
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onContentBlocked(rating.flattenToString());
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyContentBlocked", e);
                    }
                }
            });
        }

        public void notifyTimeShiftStatusChanged(final int status) {
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    this.timeShiftEnablePositionTracking(status == 3);
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onTimeShiftStatusChanged(status);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyTimeShiftStatusChanged", e);
                    }
                }
            });
        }

        private void notifyTimeShiftStartPositionChanged(final long timeMs) {
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onTimeShiftStartPositionChanged(timeMs);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyTimeShiftStartPositionChanged", e);
                    }
                }
            });
        }

        private void notifyTimeShiftCurrentPositionChanged(final long timeMs) {
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onTimeShiftCurrentPositionChanged(timeMs);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyTimeShiftCurrentPositionChanged", e);
                    }
                }
            });
        }

        public void layoutSurface(final int left, final int top, final int right, final int bottom) {
            if (left > right || top > bottom) {
                throw new IllegalArgumentException("Invalid parameter");
            }
            this.executeOrPostRunnableOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mSessionCallback != null) {
                            mSessionCallback.onLayoutSurface(left, top, right, bottom);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in layoutSurface", e);
                    }
                }
            });
        }

        public abstract void onRelease();

        public void onSetMain(boolean isMain) {
        }

        public abstract boolean onSetSurface(Surface var1);

        public void onSurfaceChanged(int format, int width, int height) {
        }

        public void onOverlayViewSizeChanged(int width, int height) {
        }

        public abstract void onSetStreamVolume(float var1);

        public abstract boolean onTune(Uri var1);

        public boolean onTune(Uri channelUri, Bundle params) {
            return this.onTune(channelUri);
        }

        public abstract void onSetCaptionEnabled(boolean var1);

        public void onUnblockContent(TvContentRating unblockedRating) {
        }

        public boolean onSelectTrack(int type, String trackId) {
            return false;
        }

        public void onAppPrivateCommand(String action, Bundle data) {
        }

        public View onCreateOverlayView() {
            return null;
        }

        public void onTimeShiftPlay(Uri recordedProgramUri) {
        }

        public void onTimeShiftPause() {
        }

        public void onTimeShiftResume() {
        }

        public void onTimeShiftSeekTo(long timeMs) {
        }

        public void onTimeShiftSetPlaybackParams(PlaybackParams params) {
        }

        public long onTimeShiftGetStartPosition() {
            return Long.MIN_VALUE;
        }

        public long onTimeShiftGetCurrentPosition() {
            return Long.MIN_VALUE;
        }

        @Override
        public boolean onKeyDown(int keyCode, KeyEvent event) {
            return false;
        }

        @Override
        public boolean onKeyLongPress(int keyCode, KeyEvent event) {
            return false;
        }

        @Override
        public boolean onKeyMultiple(int keyCode, int count, KeyEvent event) {
            return false;
        }

        @Override
        public boolean onKeyUp(int keyCode, KeyEvent event) {
            return false;
        }

        public boolean onTouchEvent(MotionEvent event) {
            return false;
        }

        public boolean onTrackballEvent(MotionEvent event) {
            return false;
        }

        public boolean onGenericMotionEvent(MotionEvent event) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release() {
            this.onRelease();
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
            Object object = this.mLock;
            synchronized (object) {
                this.mSessionCallback = null;
                this.mPendingActions.clear();
            }
            this.removeOverlayView(true);
            this.mHandler.removeCallbacks(this.mTimeShiftPositionTrackingRunnable);
        }

        void setMain(boolean isMain) {
            this.onSetMain(isMain);
        }

        void setSurface(Surface surface) {
            this.onSetSurface(surface);
            if (this.mSurface != null) {
                this.mSurface.release();
            }
            this.mSurface = surface;
        }

        void dispatchSurfaceChanged(int format, int width, int height) {
            this.onSurfaceChanged(format, width, height);
        }

        void setStreamVolume(float volume) {
            this.onSetStreamVolume(volume);
        }

        void tune(Uri channelUri, Bundle params) {
            this.mCurrentPositionMs = Long.MIN_VALUE;
            this.onTune(channelUri, params);
        }

        void setCaptionEnabled(boolean enabled) {
            this.onSetCaptionEnabled(enabled);
        }

        void selectTrack(int type, String trackId) {
            this.onSelectTrack(type, trackId);
        }

        void unblockContent(String unblockedRating) {
            this.onUnblockContent(TvContentRating.unflattenFromString(unblockedRating));
        }

        void appPrivateCommand(String action, Bundle data) {
            this.onAppPrivateCommand(action, data);
        }

        void createOverlayView(IBinder windowToken, Rect frame) {
            if (this.mOverlayViewContainer != null) {
                this.removeOverlayView(false);
            }
            this.mWindowToken = windowToken;
            this.mOverlayFrame = frame;
            this.onOverlayViewSizeChanged(frame.right - frame.left, frame.bottom - frame.top);
            if (!this.mOverlayViewEnabled) {
                return;
            }
            this.mOverlayView = this.onCreateOverlayView();
            if (this.mOverlayView == null) {
                return;
            }
            if (this.mOverlayViewCleanUpTask != null) {
                this.mOverlayViewCleanUpTask.cancel(true);
                this.mOverlayViewCleanUpTask = null;
            }
            this.mOverlayViewContainer = new FrameLayout(this.mContext.getApplicationContext());
            this.mOverlayViewContainer.addView(this.mOverlayView);
            int type = 1004;
            int flags = 536;
            if (ActivityManager.isHighEndGfx()) {
                flags |= 0x1000000;
            }
            this.mWindowParams = new WindowManager.LayoutParams(frame.right - frame.left, frame.bottom - frame.top, frame.left, frame.top, type, flags, -2);
            this.mWindowParams.privateFlags |= 0x40;
            this.mWindowParams.gravity = 0x800033;
            this.mWindowParams.token = windowToken;
            this.mWindowManager.addView(this.mOverlayViewContainer, this.mWindowParams);
        }

        void relayoutOverlayView(Rect frame) {
            if (this.mOverlayFrame == null || this.mOverlayFrame.width() != frame.width() || this.mOverlayFrame.height() != frame.height()) {
                this.onOverlayViewSizeChanged(frame.right - frame.left, frame.bottom - frame.top);
            }
            this.mOverlayFrame = frame;
            if (!this.mOverlayViewEnabled || this.mOverlayViewContainer == null) {
                return;
            }
            this.mWindowParams.x = frame.left;
            this.mWindowParams.y = frame.top;
            this.mWindowParams.width = frame.right - frame.left;
            this.mWindowParams.height = frame.bottom - frame.top;
            this.mWindowManager.updateViewLayout(this.mOverlayViewContainer, this.mWindowParams);
        }

        void removeOverlayView(boolean clearWindowToken) {
            if (clearWindowToken) {
                this.mWindowToken = null;
                this.mOverlayFrame = null;
            }
            if (this.mOverlayViewContainer != null) {
                this.mOverlayViewContainer.removeView(this.mOverlayView);
                this.mOverlayView = null;
                this.mWindowManager.removeView(this.mOverlayViewContainer);
                this.mOverlayViewContainer = null;
                this.mWindowParams = null;
            }
        }

        void timeShiftPlay(Uri recordedProgramUri) {
            this.mCurrentPositionMs = 0L;
            this.onTimeShiftPlay(recordedProgramUri);
        }

        void timeShiftPause() {
            this.onTimeShiftPause();
        }

        void timeShiftResume() {
            this.onTimeShiftResume();
        }

        void timeShiftSeekTo(long timeMs) {
            this.onTimeShiftSeekTo(timeMs);
        }

        void timeShiftSetPlaybackParams(PlaybackParams params) {
            this.onTimeShiftSetPlaybackParams(params);
        }

        void timeShiftEnablePositionTracking(boolean enable) {
            if (enable) {
                this.mHandler.post(this.mTimeShiftPositionTrackingRunnable);
            } else {
                this.mHandler.removeCallbacks(this.mTimeShiftPositionTrackingRunnable);
                this.mStartPositionMs = Long.MIN_VALUE;
                this.mCurrentPositionMs = Long.MIN_VALUE;
            }
        }

        void scheduleOverlayViewCleanup() {
            FrameLayout overlayViewParent = this.mOverlayViewContainer;
            if (overlayViewParent != null) {
                this.mOverlayViewCleanUpTask = new OverlayViewCleanUpTask();
                this.mOverlayViewCleanUpTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, overlayViewParent);
            }
        }

        int dispatchInputEvent(InputEvent event, InputEventReceiver receiver) {
            boolean isNavigationKey = false;
            boolean skipDispatchToOverlayView = false;
            if (event instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)event;
                if (keyEvent.dispatch(this, this.mDispatcherState, this)) {
                    return 1;
                }
                isNavigationKey = TvInputService.isNavigationKey(keyEvent.getKeyCode());
                skipDispatchToOverlayView = KeyEvent.isMediaKey(keyEvent.getKeyCode()) || keyEvent.getKeyCode() == 222;
            } else if (event instanceof MotionEvent) {
                MotionEvent motionEvent = (MotionEvent)event;
                int source = motionEvent.getSource();
                if (motionEvent.isTouchEvent() ? this.onTouchEvent(motionEvent) : ((source & 4) != 0 ? this.onTrackballEvent(motionEvent) : this.onGenericMotionEvent(motionEvent))) {
                    return 1;
                }
            }
            if (this.mOverlayViewContainer == null || !this.mOverlayViewContainer.isAttachedToWindow() || skipDispatchToOverlayView) {
                return 0;
            }
            if (!this.mOverlayViewContainer.hasWindowFocus()) {
                this.mOverlayViewContainer.getViewRootImpl().windowFocusChanged(true, true);
            }
            if (isNavigationKey && this.mOverlayViewContainer.hasFocusable()) {
                this.mOverlayViewContainer.getViewRootImpl().dispatchInputEvent(event);
                return 1;
            }
            this.mOverlayViewContainer.getViewRootImpl().dispatchInputEvent(event, receiver);
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize(ITvInputSessionCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mSessionCallback = callback;
                for (Runnable runnable : this.mPendingActions) {
                    runnable.run();
                }
                this.mPendingActions.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeOrPostRunnableOnMainThread(Runnable action) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSessionCallback == null) {
                    this.mPendingActions.add(action);
                } else if (this.mHandler.getLooper().isCurrentThread()) {
                    action.run();
                } else {
                    this.mHandler.post(action);
                }
            }
        }

        private final class TimeShiftPositionTrackingRunnable
        implements Runnable {
            private TimeShiftPositionTrackingRunnable() {
            }

            @Override
            public void run() {
                long currentPositionMs;
                long startPositionMs = Session.this.onTimeShiftGetStartPosition();
                if (Session.this.mStartPositionMs == Long.MIN_VALUE || Session.this.mStartPositionMs != startPositionMs) {
                    Session.this.mStartPositionMs = startPositionMs;
                    Session.this.notifyTimeShiftStartPositionChanged(startPositionMs);
                }
                if ((currentPositionMs = Session.this.onTimeShiftGetCurrentPosition()) < Session.this.mStartPositionMs) {
                    Log.w(TvInputService.TAG, "Current position (" + currentPositionMs + ") cannot be earlier than" + " start position (" + Session.this.mStartPositionMs + "). Reset to the start " + "position.");
                    currentPositionMs = Session.this.mStartPositionMs;
                }
                if (Session.this.mCurrentPositionMs == Long.MIN_VALUE || Session.this.mCurrentPositionMs != currentPositionMs) {
                    Session.this.mCurrentPositionMs = currentPositionMs;
                    Session.this.notifyTimeShiftCurrentPositionChanged(currentPositionMs);
                }
                Session.this.mHandler.removeCallbacks(Session.this.mTimeShiftPositionTrackingRunnable);
                Session.this.mHandler.postDelayed(Session.this.mTimeShiftPositionTrackingRunnable, 1000L);
            }
        }
    }
}

