/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.media.AudioAttributes;
import android.media.IAudioService;
import android.media.IPlayer;
import android.media.VolumeShaper;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import java.lang.ref.WeakReference;
import java.util.Objects;

public abstract class PlayerBase {
    private static final String TAG = "PlayerBase";
    private static final boolean DEBUG = false;
    private static IAudioService sService;
    private static final boolean DEBUG_APP_OPS = false;
    protected AudioAttributes mAttributes;
    protected float mLeftVolume = 1.0f;
    protected float mRightVolume = 1.0f;
    protected float mAuxEffectSendLevel = 0.0f;
    private IAppOpsService mAppOps;
    private IAppOpsCallback mAppOpsCallback;
    private boolean mHasAppOpsPlayAudio = true;
    private final Object mLock = new Object();
    private final int mImplType;
    private int mPlayerIId;
    private int mState;
    private int mStartDelayMs = 0;
    private float mPanMultiplierL = 1.0f;
    private float mPanMultiplierR = 1.0f;

    PlayerBase(AudioAttributes attr2, int implType) {
        if (attr2 == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        this.mAttributes = attr2;
        this.mImplType = implType;
        this.mState = 1;
    }

    protected void baseRegisterPlayer() {
        int newPiid = -1;
        IBinder b = ServiceManager.getService("appops");
        this.mAppOps = IAppOpsService.Stub.asInterface(b);
        this.updateAppOpsPlayAudio();
        this.mAppOpsCallback = new IAppOpsCallbackWrapper(this);
        try {
            this.mAppOps.startWatchingMode(28, ActivityThread.currentPackageName(), this.mAppOpsCallback);
        }
        catch (RemoteException e) {
            this.mHasAppOpsPlayAudio = false;
        }
        try {
            newPiid = PlayerBase.getService().trackPlayer(new PlayerIdCard(this.mImplType, this.mAttributes, new IPlayerWrapper(this)));
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to audio service, player will not be tracked", e);
        }
        this.mPlayerIId = newPiid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseUpdateAudioAttributes(AudioAttributes attr2) {
        if (attr2 == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        try {
            PlayerBase.getService().playerAttributes(this.mPlayerIId, attr2);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to audio service, STARTED state will not be tracked", e);
        }
        Object object = this.mLock;
        synchronized (object) {
            boolean attributesChanged = this.mAttributes != attr2;
            this.mAttributes = attr2;
            this.updateAppOpsPlayAudio_sync(attributesChanged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseStart() {
        Object object;
        try {
            object = this.mLock;
            synchronized (object) {
                this.mState = 2;
                PlayerBase.getService().playerEvent(this.mPlayerIId, this.mState);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to audio service, STARTED state will not be tracked", e);
        }
        object = this.mLock;
        synchronized (object) {
            if (this.isRestricted_sync()) {
                this.playerSetVolume(true, 0.0f, 0.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseSetStartDelayMs(int delayMs) {
        Object object = this.mLock;
        synchronized (object) {
            this.mStartDelayMs = Math.max(delayMs, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getStartDelayMs() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mStartDelayMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basePause() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mState = 3;
                PlayerBase.getService().playerEvent(this.mPlayerIId, this.mState);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to audio service, PAUSED state will not be tracked", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseStop() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mState = 4;
                PlayerBase.getService().playerEvent(this.mPlayerIId, this.mState);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to audio service, STOPPED state will not be tracked", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseSetPan(float pan) {
        float p = Math.min(Math.max(-1.0f, pan), 1.0f);
        Object object = this.mLock;
        synchronized (object) {
            if (p >= 0.0f) {
                this.mPanMultiplierL = 1.0f - p;
                this.mPanMultiplierR = 1.0f;
            } else {
                this.mPanMultiplierL = 1.0f;
                this.mPanMultiplierR = 1.0f + p;
            }
        }
        this.baseSetVolume(this.mLeftVolume, this.mRightVolume);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseSetVolume(float leftVolume, float rightVolume) {
        boolean isRestricted;
        Object object = this.mLock;
        synchronized (object) {
            this.mLeftVolume = leftVolume;
            this.mRightVolume = rightVolume;
            isRestricted = this.isRestricted_sync();
        }
        this.playerSetVolume(isRestricted, leftVolume * this.mPanMultiplierL, rightVolume * this.mPanMultiplierR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int baseSetAuxEffectSendLevel(float level) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAuxEffectSendLevel = level;
            if (this.isRestricted_sync()) {
                return 0;
            }
        }
        return this.playerSetAuxEffectSendLevel(false, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseRelease() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mState != 0) {
                    PlayerBase.getService().releasePlayer(this.mPlayerIId);
                    this.mState = 0;
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to audio service, the player will still be tracked", e);
        }
        try {
            if (this.mAppOps != null) {
                this.mAppOps.stopWatchingMode(this.mAppOpsCallback);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAppOpsPlayAudio() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateAppOpsPlayAudio_sync(false);
        }
    }

    void updateAppOpsPlayAudio_sync(boolean attributesChanged) {
        boolean oldHasAppOpsPlayAudio = this.mHasAppOpsPlayAudio;
        try {
            int mode = 1;
            if (this.mAppOps != null) {
                mode = this.mAppOps.checkAudioOperation(28, this.mAttributes.getUsage(), Process.myUid(), ActivityThread.currentPackageName());
            }
            this.mHasAppOpsPlayAudio = mode == 0;
        }
        catch (RemoteException e) {
            this.mHasAppOpsPlayAudio = false;
        }
        try {
            if (oldHasAppOpsPlayAudio != this.mHasAppOpsPlayAudio || attributesChanged) {
                PlayerBase.getService().playerHasOpPlayAudio(this.mPlayerIId, this.mHasAppOpsPlayAudio);
                if (!this.isRestricted_sync()) {
                    this.playerSetVolume(false, this.mLeftVolume * this.mPanMultiplierL, this.mRightVolume * this.mPanMultiplierR);
                    this.playerSetAuxEffectSendLevel(false, this.mAuxEffectSendLevel);
                } else {
                    this.playerSetVolume(true, 0.0f, 0.0f);
                    this.playerSetAuxEffectSendLevel(true, 0.0f);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isRestricted_sync() {
        if (this.mHasAppOpsPlayAudio) {
            return false;
        }
        if ((this.mAttributes.getAllFlags() & 0x40) != 0) {
            return false;
        }
        if ((this.mAttributes.getAllFlags() & 1) != 0 && this.mAttributes.getUsage() == 13) {
            boolean cameraSoundForced = false;
            try {
                cameraSoundForced = PlayerBase.getService().isCameraSoundForced();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Cannot access AudioService in isRestricted_sync()");
            }
            catch (NullPointerException e) {
                Log.e(TAG, "Null AudioService in isRestricted_sync()");
            }
            if (cameraSoundForced) {
                return false;
            }
        }
        return true;
    }

    private static IAudioService getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    public void setStartDelayMs(int delayMs) {
        this.baseSetStartDelayMs(delayMs);
    }

    abstract void playerSetVolume(boolean var1, float var2, float var3);

    abstract int playerApplyVolumeShaper(VolumeShaper.Configuration var1, VolumeShaper.Operation var2);

    abstract VolumeShaper.State playerGetVolumeShaperState(int var1);

    abstract int playerSetAuxEffectSendLevel(boolean var1, float var2);

    abstract void playerStart();

    abstract void playerPause();

    abstract void playerStop();

    public static void deprecateStreamTypeForPlayback(int streamType, String className, String opName) throws IllegalArgumentException {
        if (streamType == 10) {
            throw new IllegalArgumentException("Use of STREAM_ACCESSIBILITY is reserved for volume control");
        }
        Log.w(className, "Use of stream types is deprecated for operations other than volume control");
        Log.w(className, "See the documentation of " + opName + " for what to use instead with " + "android.media.AudioAttributes to qualify your playback use case");
    }

    public static class PlayerIdCard
    implements Parcelable {
        public final int mPlayerType;
        public static final int AUDIO_ATTRIBUTES_NONE = 0;
        public static final int AUDIO_ATTRIBUTES_DEFINED = 1;
        public final AudioAttributes mAttributes;
        public final IPlayer mIPlayer;
        public static final Parcelable.Creator<PlayerIdCard> CREATOR = new Parcelable.Creator<PlayerIdCard>(){

            @Override
            public PlayerIdCard createFromParcel(Parcel p) {
                return new PlayerIdCard(p);
            }

            public PlayerIdCard[] newArray(int size) {
                return new PlayerIdCard[size];
            }
        };

        PlayerIdCard(int type, AudioAttributes attr2, IPlayer iplayer) {
            this.mPlayerType = type;
            this.mAttributes = attr2;
            this.mIPlayer = iplayer;
        }

        public int hashCode() {
            return Objects.hash(this.mPlayerType);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mPlayerType);
            this.mAttributes.writeToParcel(dest, 0);
            dest.writeStrongBinder(this.mIPlayer == null ? null : this.mIPlayer.asBinder());
        }

        private PlayerIdCard(Parcel in) {
            this.mPlayerType = in.readInt();
            this.mAttributes = AudioAttributes.CREATOR.createFromParcel(in);
            IBinder b = in.readStrongBinder();
            this.mIPlayer = b == null ? null : IPlayer.Stub.asInterface(b);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof PlayerIdCard)) {
                return false;
            }
            PlayerIdCard that = (PlayerIdCard)o;
            return this.mPlayerType == that.mPlayerType && this.mAttributes.equals(that.mAttributes);
        }
    }

    private static class IPlayerWrapper
    extends IPlayer.Stub {
        private final WeakReference<PlayerBase> mWeakPB;

        public IPlayerWrapper(PlayerBase pb) {
            this.mWeakPB = new WeakReference<PlayerBase>(pb);
        }

        @Override
        public void start() {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.playerStart();
            }
        }

        @Override
        public void pause() {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.playerPause();
            }
        }

        @Override
        public void stop() {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.playerStop();
            }
        }

        @Override
        public void setVolume(float vol) {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.baseSetVolume(vol, vol);
            }
        }

        @Override
        public void setPan(float pan) {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.baseSetPan(pan);
            }
        }

        @Override
        public void setStartDelayMs(int delayMs) {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.baseSetStartDelayMs(delayMs);
            }
        }

        @Override
        public void applyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.playerApplyVolumeShaper(configuration, operation);
            }
        }
    }

    private static class IAppOpsCallbackWrapper
    extends IAppOpsCallback.Stub {
        private final WeakReference<PlayerBase> mWeakPB;

        public IAppOpsCallbackWrapper(PlayerBase pb) {
            this.mWeakPB = new WeakReference<PlayerBase>(pb);
        }

        @Override
        public void opChanged(int op, int uid, String packageName) {
            PlayerBase pb;
            if (op == 28 && (pb = (PlayerBase)this.mWeakPB.get()) != null) {
                pb.updateAppOpsPlayAudio();
            }
        }
    }
}

