/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioAttributes;
import android.media.SoundPool;
import android.util.Log;

public class MediaActionSound {
    private static final int NUM_MEDIA_SOUND_STREAMS = 1;
    private SoundPool mSoundPool;
    private SoundState[] mSounds;
    private static final String[] SOUND_FILES = new String[]{"/system/media/audio/ui/camera_click.ogg", "/system/media/audio/ui/camera_focus.ogg", "/system/media/audio/ui/VideoRecord.ogg", "/system/media/audio/ui/VideoStop.ogg"};
    private static final String TAG = "MediaActionSound";
    public static final int SHUTTER_CLICK = 0;
    public static final int FOCUS_COMPLETE = 1;
    public static final int START_VIDEO_RECORDING = 2;
    public static final int STOP_VIDEO_RECORDING = 3;
    private static final int STATE_NOT_LOADED = 0;
    private static final int STATE_LOADING = 1;
    private static final int STATE_LOADING_PLAY_REQUESTED = 2;
    private static final int STATE_LOADED = 3;
    private SoundPool.OnLoadCompleteListener mLoadCompleteListener = new SoundPool.OnLoadCompleteListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
            for (SoundState sound : MediaActionSound.this.mSounds) {
                if (sound.id != sampleId) continue;
                int playSoundId = 0;
                SoundState soundState = sound;
                synchronized (soundState) {
                    if (status != 0) {
                        sound.state = 0;
                        sound.id = 0;
                        Log.e(MediaActionSound.TAG, "OnLoadCompleteListener() error: " + status + " loading sound: " + sound.name);
                        return;
                    }
                    switch (sound.state) {
                        case 1: {
                            sound.state = 3;
                            break;
                        }
                        case 2: {
                            playSoundId = sound.id;
                            sound.state = 3;
                            break;
                        }
                        default: {
                            Log.e(MediaActionSound.TAG, "OnLoadCompleteListener() called in wrong state: " + sound.state + " for sound: " + sound.name);
                        }
                    }
                }
                if (playSoundId == 0) break;
                soundPool.play(playSoundId, 1.0f, 1.0f, 0, 0, 1.0f);
                break;
            }
        }
    };

    public MediaActionSound() {
        this.mSoundPool = new SoundPool.Builder().setMaxStreams(1).setAudioAttributes(new AudioAttributes.Builder().setUsage(13).setFlags(1).setContentType(4).build()).build();
        this.mSoundPool.setOnLoadCompleteListener(this.mLoadCompleteListener);
        this.mSounds = new SoundState[SOUND_FILES.length];
        for (int i = 0; i < this.mSounds.length; ++i) {
            this.mSounds[i] = new SoundState(i);
        }
    }

    private int loadSound(SoundState sound) {
        int id2 = this.mSoundPool.load(SOUND_FILES[sound.name], 1);
        if (id2 > 0) {
            sound.state = 1;
            sound.id = id2;
        }
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(int soundName) {
        SoundState sound;
        if (soundName < 0 || soundName >= SOUND_FILES.length) {
            throw new RuntimeException("Unknown sound requested: " + soundName);
        }
        SoundState soundState = sound = this.mSounds[soundName];
        synchronized (soundState) {
            switch (sound.state) {
                case 0: {
                    if (this.loadSound(sound) > 0) break;
                    Log.e(TAG, "load() error loading sound: " + soundName);
                    break;
                }
                default: {
                    Log.e(TAG, "load() called in wrong state: " + sound + " for sound: " + soundName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(int soundName) {
        SoundState sound;
        if (soundName < 0 || soundName >= SOUND_FILES.length) {
            throw new RuntimeException("Unknown sound requested: " + soundName);
        }
        SoundState soundState = sound = this.mSounds[soundName];
        synchronized (soundState) {
            switch (sound.state) {
                case 0: {
                    this.loadSound(sound);
                    if (this.loadSound(sound) <= 0) {
                        Log.e(TAG, "play() error loading sound: " + soundName);
                        break;
                    }
                }
                case 1: {
                    sound.state = 2;
                    break;
                }
                case 3: {
                    this.mSoundPool.play(sound.id, 1.0f, 1.0f, 0, 0, 1.0f);
                    break;
                }
                default: {
                    Log.e(TAG, "play() called in wrong state: " + sound.state + " for sound: " + soundName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.mSoundPool != null) {
            SoundState[] soundStateArray = this.mSounds;
            int n = soundStateArray.length;
            for (int i = 0; i < n; ++i) {
                SoundState sound;
                SoundState soundState = sound = soundStateArray[i];
                synchronized (soundState) {
                    sound.state = 0;
                    sound.id = 0;
                    continue;
                }
            }
            this.mSoundPool.release();
            this.mSoundPool = null;
        }
    }

    private class SoundState {
        public final int name;
        public int id;
        public int state;

        public SoundState(int name) {
            this.name = name;
            this.id = 0;
            this.state = 0;
        }
    }
}

