/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.util.ArrayList;
import java.util.List;

public class EncoderCapabilities {
    private static final String TAG = "EncoderCapabilities";

    public static int[] getOutputFileFormats() {
        int nFormats = EncoderCapabilities.native_get_num_file_formats();
        if (nFormats == 0) {
            return null;
        }
        int[] formats = new int[nFormats];
        for (int i = 0; i < nFormats; ++i) {
            formats[i] = EncoderCapabilities.native_get_file_format(i);
        }
        return formats;
    }

    public static List<VideoEncoderCap> getVideoEncoders() {
        int nEncoders = EncoderCapabilities.native_get_num_video_encoders();
        if (nEncoders == 0) {
            return null;
        }
        ArrayList<VideoEncoderCap> encoderList = new ArrayList<VideoEncoderCap>();
        for (int i = 0; i < nEncoders; ++i) {
            encoderList.add(EncoderCapabilities.native_get_video_encoder_cap(i));
        }
        return encoderList;
    }

    public static List<AudioEncoderCap> getAudioEncoders() {
        int nEncoders = EncoderCapabilities.native_get_num_audio_encoders();
        if (nEncoders == 0) {
            return null;
        }
        ArrayList<AudioEncoderCap> encoderList = new ArrayList<AudioEncoderCap>();
        for (int i = 0; i < nEncoders; ++i) {
            encoderList.add(EncoderCapabilities.native_get_audio_encoder_cap(i));
        }
        return encoderList;
    }

    private EncoderCapabilities() {
    }

    private static final native void native_init();

    private static final native int native_get_num_file_formats();

    private static final native int native_get_file_format(int var0);

    private static final native int native_get_num_video_encoders();

    private static final native VideoEncoderCap native_get_video_encoder_cap(int var0);

    private static final native int native_get_num_audio_encoders();

    private static final native AudioEncoderCap native_get_audio_encoder_cap(int var0);

    static {
        System.loadLibrary("media_jni");
        EncoderCapabilities.native_init();
    }

    public static class AudioEncoderCap {
        public final int mCodec;
        public final int mMinChannels;
        public final int mMaxChannels;
        public final int mMinSampleRate;
        public final int mMaxSampleRate;
        public final int mMinBitRate;
        public final int mMaxBitRate;

        private AudioEncoderCap(int codec, int minBitRate, int maxBitRate, int minSampleRate, int maxSampleRate, int minChannels, int maxChannels) {
            this.mCodec = codec;
            this.mMinBitRate = minBitRate;
            this.mMaxBitRate = maxBitRate;
            this.mMinSampleRate = minSampleRate;
            this.mMaxSampleRate = maxSampleRate;
            this.mMinChannels = minChannels;
            this.mMaxChannels = maxChannels;
        }
    }

    public static class VideoEncoderCap {
        public final int mCodec;
        public final int mMinBitRate;
        public final int mMaxBitRate;
        public final int mMinFrameRate;
        public final int mMaxFrameRate;
        public final int mMinFrameWidth;
        public final int mMaxFrameWidth;
        public final int mMinFrameHeight;
        public final int mMaxFrameHeight;

        private VideoEncoderCap(int codec, int minBitRate, int maxBitRate, int minFrameRate, int maxFrameRate, int minFrameWidth, int maxFrameWidth, int minFrameHeight, int maxFrameHeight) {
            this.mCodec = codec;
            this.mMinBitRate = minBitRate;
            this.mMaxBitRate = maxBitRate;
            this.mMinFrameRate = minFrameRate;
            this.mMaxFrameRate = maxFrameRate;
            this.mMinFrameWidth = minFrameWidth;
            this.mMaxFrameWidth = maxFrameWidth;
            this.mMinFrameHeight = minFrameHeight;
            this.mMaxFrameHeight = maxFrameHeight;
        }
    }
}

