/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.util.Log;
import com.android.internal.util.Preconditions;
import dalvik.system.CloseGuard;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class UsbRequest {
    private static final String TAG = "UsbRequest";
    private static final int MAX_USBFS_BUFFER_SIZE = 16384;
    private long mNativeContext;
    private UsbEndpoint mEndpoint;
    private ByteBuffer mBuffer;
    private int mLength;
    private Object mClientData;
    private UsbDeviceConnection mConnection;
    private boolean mIsUsingNewQueue;
    private ByteBuffer mTempBuffer;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final Object mLock = new Object();

    public boolean initialize(UsbDeviceConnection connection, UsbEndpoint endpoint) {
        this.mEndpoint = endpoint;
        this.mConnection = Preconditions.checkNotNull(connection, "connection");
        boolean wasInitialized = this.native_init(connection, endpoint.getAddress(), endpoint.getAttributes(), endpoint.getMaxPacketSize(), endpoint.getInterval());
        if (wasInitialized) {
            this.mCloseGuard.open("close");
        }
        return wasInitialized;
    }

    public void close() {
        if (this.mNativeContext != 0L) {
            this.mEndpoint = null;
            this.mConnection = null;
            this.native_close();
            this.mCloseGuard.close();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public UsbEndpoint getEndpoint() {
        return this.mEndpoint;
    }

    public Object getClientData() {
        return this.mClientData;
    }

    public void setClientData(Object data) {
        this.mClientData = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean queue(ByteBuffer buffer, int length) {
        boolean result;
        boolean out = this.mEndpoint.getDirection() == 0;
        Object object = this.mLock;
        synchronized (object) {
            this.mBuffer = buffer;
            this.mLength = length;
            if (buffer.isDirect()) {
                result = this.native_queue_direct(buffer, length, out);
            } else if (buffer.hasArray()) {
                result = this.native_queue_array(buffer.array(), length, out);
            } else {
                throw new IllegalArgumentException("buffer is not direct and has no array");
            }
            if (!result) {
                this.mBuffer = null;
                this.mLength = 0;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queue(ByteBuffer buffer) {
        boolean wasQueued;
        Preconditions.checkState(this.mNativeContext != 0L, "request is not initialized");
        Preconditions.checkState(!this.mIsUsingNewQueue, "this request is currently queued");
        boolean isSend = this.mEndpoint.getDirection() == 0;
        Object object = this.mLock;
        synchronized (object) {
            this.mBuffer = buffer;
            if (buffer == null) {
                this.mIsUsingNewQueue = true;
                wasQueued = this.native_queue(null, 0, 0);
            } else {
                Preconditions.checkArgumentInRange(buffer.remaining(), 0, 16384, "number of remaining bytes");
                Preconditions.checkArgument(!buffer.isReadOnly() || isSend, "buffer can not be read-only when receiving data");
                if (!buffer.isDirect()) {
                    this.mTempBuffer = ByteBuffer.allocateDirect(this.mBuffer.remaining());
                    if (isSend) {
                        this.mBuffer.mark();
                        this.mTempBuffer.put(this.mBuffer);
                        this.mTempBuffer.flip();
                        this.mBuffer.reset();
                    }
                    buffer = this.mTempBuffer;
                }
                this.mIsUsingNewQueue = true;
                wasQueued = this.native_queue(buffer, buffer.position(), buffer.remaining());
            }
        }
        if (!wasQueued) {
            this.mIsUsingNewQueue = false;
            this.mTempBuffer = null;
            this.mBuffer = null;
        }
        return wasQueued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dequeue(boolean useBufferOverflowInsteadOfIllegalArg) {
        boolean isSend = this.mEndpoint.getDirection() == 0;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsUsingNewQueue) {
                int bytesTransferred = this.native_dequeue_direct();
                this.mIsUsingNewQueue = false;
                if (this.mBuffer != null) {
                    if (this.mTempBuffer == null) {
                        this.mBuffer.position(this.mBuffer.position() + bytesTransferred);
                    } else {
                        this.mTempBuffer.limit(bytesTransferred);
                        try {
                            if (isSend) {
                                this.mBuffer.position(this.mBuffer.position() + bytesTransferred);
                            }
                            this.mBuffer.put(this.mTempBuffer);
                        }
                        finally {
                            this.mTempBuffer = null;
                        }
                    }
                }
            } else {
                int bytesTransferred = this.mBuffer.isDirect() ? this.native_dequeue_direct() : this.native_dequeue_array(this.mBuffer.array(), this.mLength, isSend);
                if (bytesTransferred >= 0) {
                    int bytesToStore = Math.min(bytesTransferred, this.mLength);
                    try {
                        this.mBuffer.position(bytesToStore);
                    }
                    catch (IllegalArgumentException e) {
                        if (useBufferOverflowInsteadOfIllegalArg) {
                            Log.e(TAG, "Buffer " + this.mBuffer + " does not have enough space to read " + bytesToStore + " bytes", e);
                            throw new BufferOverflowException();
                        }
                        throw e;
                    }
                }
            }
            this.mBuffer = null;
            this.mLength = 0;
        }
    }

    public boolean cancel() {
        return this.native_cancel();
    }

    private native boolean native_init(UsbDeviceConnection var1, int var2, int var3, int var4, int var5);

    private native void native_close();

    private native boolean native_queue(ByteBuffer var1, int var2, int var3);

    private native boolean native_queue_array(byte[] var1, int var2, boolean var3);

    private native int native_dequeue_array(byte[] var1, int var2, boolean var3);

    private native boolean native_queue_direct(ByteBuffer var1, int var2, boolean var3);

    private native int native_dequeue_direct();

    private native boolean native_cancel();
}

