/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.RippleDrawable;
import android.view.DisplayListCanvas;
import android.view.RenderNodeAnimator;
import java.util.ArrayList;

abstract class RippleComponent {
    private final RippleDrawable mOwner;
    protected final Rect mBounds;
    private boolean mHasDisplayListCanvas;
    private boolean mHasPendingHardwareAnimator;
    private RenderNodeAnimatorSet mHardwareAnimator;
    private Animator mSoftwareAnimator;
    private boolean mHasMaxRadius;
    protected float mTargetRadius;
    protected float mDensityScale;
    private final boolean mForceSoftware;

    public RippleComponent(RippleDrawable owner, Rect bounds, boolean forceSoftware) {
        this.mOwner = owner;
        this.mBounds = bounds;
        this.mForceSoftware = forceSoftware;
    }

    public void onBoundsChange() {
        if (!this.mHasMaxRadius) {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
            this.onTargetRadiusChanged(this.mTargetRadius);
        }
    }

    public final void setup(float maxRadius, int densityDpi) {
        if (maxRadius >= 0.0f) {
            this.mHasMaxRadius = true;
            this.mTargetRadius = maxRadius;
        } else {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
        }
        this.mDensityScale = (float)densityDpi * 0.00625f;
        this.onTargetRadiusChanged(this.mTargetRadius);
    }

    private static float getTargetRadius(Rect bounds) {
        float halfWidth = (float)bounds.width() / 2.0f;
        float halfHeight = (float)bounds.height() / 2.0f;
        return (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
    }

    public final void enter(boolean fast) {
        this.cancel();
        this.mSoftwareAnimator = this.createSoftwareEnter(fast);
        if (this.mSoftwareAnimator != null) {
            this.mSoftwareAnimator.start();
        }
    }

    public final void exit() {
        this.cancel();
        if (this.mHasDisplayListCanvas) {
            this.mHasPendingHardwareAnimator = true;
            this.invalidateSelf();
        } else {
            this.mSoftwareAnimator = this.createSoftwareExit();
            this.mSoftwareAnimator.start();
        }
    }

    public void cancel() {
        this.cancelSoftwareAnimations();
        this.endHardwareAnimations();
    }

    public void end() {
        this.endSoftwareAnimations();
        this.endHardwareAnimations();
    }

    public boolean draw(Canvas c, Paint p) {
        boolean hasDisplayListCanvas;
        boolean bl = hasDisplayListCanvas = !this.mForceSoftware && c.isHardwareAccelerated() && c instanceof DisplayListCanvas;
        if (this.mHasDisplayListCanvas != hasDisplayListCanvas) {
            this.mHasDisplayListCanvas = hasDisplayListCanvas;
            if (!hasDisplayListCanvas) {
                this.endHardwareAnimations();
            }
        }
        if (hasDisplayListCanvas) {
            DisplayListCanvas hw = (DisplayListCanvas)c;
            this.startPendingAnimation(hw, p);
            if (this.mHardwareAnimator != null) {
                return this.drawHardware(hw);
            }
        }
        return this.drawSoftware(c, p);
    }

    public void getBounds(Rect bounds) {
        int r = (int)Math.ceil(this.mTargetRadius);
        bounds.set(-r, -r, r, r);
    }

    private void startPendingAnimation(DisplayListCanvas hw, Paint p) {
        if (this.mHasPendingHardwareAnimator) {
            this.mHasPendingHardwareAnimator = false;
            this.mHardwareAnimator = this.createHardwareExit(new Paint(p));
            this.mHardwareAnimator.start(hw);
            this.jumpValuesToExit();
        }
    }

    private void cancelSoftwareAnimations() {
        if (this.mSoftwareAnimator != null) {
            this.mSoftwareAnimator.cancel();
            this.mSoftwareAnimator = null;
        }
    }

    private void endSoftwareAnimations() {
        if (this.mSoftwareAnimator != null) {
            this.mSoftwareAnimator.end();
            this.mSoftwareAnimator = null;
        }
    }

    private void endHardwareAnimations() {
        if (this.mHardwareAnimator != null) {
            this.mHardwareAnimator.end();
            this.mHardwareAnimator = null;
        }
        if (this.mHasPendingHardwareAnimator) {
            this.mHasPendingHardwareAnimator = false;
            this.jumpValuesToExit();
        }
    }

    protected final void invalidateSelf() {
        this.mOwner.invalidateSelf(false);
    }

    protected final boolean isHardwareAnimating() {
        return this.mHardwareAnimator != null && this.mHardwareAnimator.isRunning() || this.mHasPendingHardwareAnimator;
    }

    protected final void onHotspotBoundsChanged() {
        if (!this.mHasMaxRadius) {
            float halfWidth = (float)this.mBounds.width() / 2.0f;
            float halfHeight = (float)this.mBounds.height() / 2.0f;
            float targetRadius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
            this.onTargetRadiusChanged(targetRadius);
        }
    }

    protected void onTargetRadiusChanged(float targetRadius) {
    }

    protected abstract Animator createSoftwareEnter(boolean var1);

    protected abstract Animator createSoftwareExit();

    protected abstract RenderNodeAnimatorSet createHardwareExit(Paint var1);

    protected abstract boolean drawHardware(DisplayListCanvas var1);

    protected abstract boolean drawSoftware(Canvas var1, Paint var2);

    protected abstract void jumpValuesToExit();

    public static class RenderNodeAnimatorSet {
        private final ArrayList<RenderNodeAnimator> mAnimators = new ArrayList();

        public void add(RenderNodeAnimator anim2) {
            this.mAnimators.add(anim2);
        }

        public void clear() {
            this.mAnimators.clear();
        }

        public void start(DisplayListCanvas target) {
            if (target == null) {
                throw new IllegalArgumentException("Hardware canvas must be non-null");
            }
            ArrayList<RenderNodeAnimator> animators = this.mAnimators;
            int N = animators.size();
            for (int i = 0; i < N; ++i) {
                RenderNodeAnimator anim2 = animators.get(i);
                anim2.setTarget(target);
                anim2.start();
            }
        }

        public void cancel() {
            ArrayList<RenderNodeAnimator> animators = this.mAnimators;
            int N = animators.size();
            for (int i = 0; i < N; ++i) {
                RenderNodeAnimator anim2 = animators.get(i);
                anim2.cancel();
            }
        }

        public void end() {
            ArrayList<RenderNodeAnimator> animators = this.mAnimators;
            int N = animators.size();
            for (int i = 0; i < N; ++i) {
                RenderNodeAnimator anim2 = animators.get(i);
                anim2.end();
            }
        }

        public boolean isRunning() {
            ArrayList<RenderNodeAnimator> animators = this.mAnimators;
            int N = animators.size();
            for (int i = 0; i < N; ++i) {
                RenderNodeAnimator anim2 = animators.get(i);
                if (!anim2.isRunning()) continue;
                return true;
            }
            return false;
        }
    }
}

