/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Shader;

public class BitmapShader
extends Shader {
    public Bitmap mBitmap;
    private int mTileX;
    private int mTileY;

    public BitmapShader(Bitmap bitmap, Shader.TileMode tileX, Shader.TileMode tileY) {
        this(bitmap, tileX.nativeInt, tileY.nativeInt);
    }

    private BitmapShader(Bitmap bitmap, int tileX, int tileY) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap must be non-null");
        }
        if (bitmap == this.mBitmap && tileX == this.mTileX && tileY == this.mTileY) {
            return;
        }
        this.mBitmap = bitmap;
        this.mTileX = tileX;
        this.mTileY = tileY;
    }

    @Override
    long createNativeInstance(long nativeMatrix) {
        return BitmapShader.nativeCreate(nativeMatrix, this.mBitmap, this.mTileX, this.mTileY);
    }

    @Override
    protected Shader copy() {
        BitmapShader copy = new BitmapShader(this.mBitmap, this.mTileX, this.mTileY);
        this.copyLocalMatrix(copy);
        return copy;
    }

    private static native long nativeCreate(long var0, Bitmap var2, int var3, int var4);
}

