/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;

public class CropRectFilter
extends Filter {
    @GenerateFieldPort(name="xorigin")
    private int mXorigin;
    @GenerateFieldPort(name="yorigin")
    private int mYorigin;
    @GenerateFieldPort(name="width")
    private int mOutputWidth;
    @GenerateFieldPort(name="height")
    private int mOutputHeight;
    @GenerateFieldPort(name="tile_size", hasDefault=true)
    private int mTileSize = 640;
    private Program mProgram;
    private int mWidth = 0;
    private int mHeight = 0;
    private int mTarget = 0;

    public CropRectFilter(String name) {
        super(name);
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }

    public void initProgram(FilterContext context, int target) {
        switch (target) {
            case 3: {
                ShaderProgram shaderProgram = ShaderProgram.createIdentity(context);
                shaderProgram.setMaximumTileSize(this.mTileSize);
                this.mProgram = shaderProgram;
                break;
            }
            default: {
                throw new RuntimeException("Filter Sharpen does not support frames of target " + target + "!");
            }
        }
        this.mTarget = target;
    }

    @Override
    public void fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mProgram != null) {
            this.updateSourceRect(this.mWidth, this.mHeight);
        }
    }

    @Override
    public void process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat inputFormat = input.getFormat();
        MutableFrameFormat outputFormat = ImageFormat.create(this.mOutputWidth, this.mOutputHeight, 3, 3);
        Frame output = context.getFrameManager().newFrame(outputFormat);
        if (this.mProgram == null || inputFormat.getTarget() != this.mTarget) {
            this.initProgram(context, inputFormat.getTarget());
        }
        if (inputFormat.getWidth() != this.mWidth || inputFormat.getHeight() != this.mHeight) {
            this.updateSourceRect(inputFormat.getWidth(), inputFormat.getHeight());
        }
        this.mProgram.process(input, output);
        this.pushOutput("image", output);
        output.release();
    }

    void updateSourceRect(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        ((ShaderProgram)this.mProgram).setSourceRect((float)this.mXorigin / (float)this.mWidth, (float)this.mYorigin / (float)this.mHeight, (float)this.mOutputWidth / (float)this.mWidth, (float)this.mOutputHeight / (float)this.mHeight);
    }
}

