/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.base;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;

public class RetargetFilter
extends Filter {
    @GenerateFinalPort(name="target", hasDefault=false)
    private String mTargetString;
    private MutableFrameFormat mOutputFormat;
    private int mTarget = -1;

    public RetargetFilter(String name) {
        super(name);
    }

    @Override
    public void setupPorts() {
        this.mTarget = FrameFormat.readTargetString(this.mTargetString);
        this.addInputPort("frame");
        this.addOutputBasedOnInput("frame", "frame");
    }

    @Override
    public FrameFormat getOutputFormat(String portName, FrameFormat inputFormat) {
        MutableFrameFormat retargeted = inputFormat.mutableCopy();
        retargeted.setTarget(this.mTarget);
        return retargeted;
    }

    @Override
    public void process(FilterContext context) {
        Frame input = this.pullInput("frame");
        Frame output = context.getFrameManager().duplicateFrameToTarget(input, this.mTarget);
        this.pushOutput("frame", output);
        output.release();
    }
}

