/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.base;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.format.ImageFormat;

public class GLTextureSource
extends Filter {
    @GenerateFieldPort(name="texId")
    private int mTexId;
    @GenerateFieldPort(name="width")
    private int mWidth;
    @GenerateFieldPort(name="height")
    private int mHeight;
    @GenerateFieldPort(name="repeatFrame", hasDefault=true)
    private boolean mRepeatFrame = false;
    @GenerateFieldPort(name="timestamp", hasDefault=true)
    private long mTimestamp = -1L;
    private Frame mFrame;

    public GLTextureSource(String name) {
        super(name);
    }

    @Override
    public void setupPorts() {
        this.addOutputPort("frame", ImageFormat.create(3, 3));
    }

    @Override
    public void fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mFrame != null) {
            this.mFrame.release();
            this.mFrame = null;
        }
    }

    @Override
    public void process(FilterContext context) {
        if (this.mFrame == null) {
            MutableFrameFormat outputFormat = ImageFormat.create(this.mWidth, this.mHeight, 3, 3);
            this.mFrame = context.getFrameManager().newBoundFrame(outputFormat, 100, this.mTexId);
            this.mFrame.setTimestamp(this.mTimestamp);
        }
        this.pushOutput("frame", this.mFrame);
        if (!this.mRepeatFrame) {
            this.closeOutputPort("frame");
        }
    }

    @Override
    public void tearDown(FilterContext context) {
        if (this.mFrame != null) {
            this.mFrame.release();
        }
    }
}

