/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.animation.Animator;
import android.animation.StateListAnimator;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.ComplexColor;
import android.content.res.Configuration;
import android.content.res.ConfigurationBoundResourceCache;
import android.content.res.ResourcesImpl;
import android.content.res.TypedArray;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.graphics.Movie;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableInflater;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.Pools;
import android.util.TypedValue;
import android.view.DisplayAdjustments;
import android.view.ViewDebug;
import android.view.ViewHierarchyEncoder;
import com.android.internal.R;
import com.android.internal.util.GrowingArrayUtils;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParserException;

public class Resources {
    static final String TAG = "Resources";
    private static final Object sSync = new Object();
    static Resources mSystem = null;
    private ResourcesImpl mResourcesImpl;
    final Pools.SynchronizedPool<TypedArray> mTypedArrayPool = new Pools.SynchronizedPool(5);
    private DrawableInflater mDrawableInflater;
    private final Object mTmpValueLock = new Object();
    private TypedValue mTmpValue = new TypedValue();
    final ClassLoader mClassLoader;
    private final ArrayList<WeakReference<Theme>> mThemeRefs = new ArrayList();

    public static int selectDefaultTheme(int curTheme, int targetSdkVersion) {
        return Resources.selectSystemTheme(curTheme, targetSdkVersion, 16973829, 16973931, 16974120, 16974143);
    }

    public static int selectSystemTheme(int curTheme, int targetSdkVersion, int orig, int holo, int dark, int deviceDefault) {
        if (curTheme != 0) {
            return curTheme;
        }
        if (targetSdkVersion < 11) {
            return orig;
        }
        if (targetSdkVersion < 14) {
            return holo;
        }
        if (targetSdkVersion < 24) {
            return dark;
        }
        return deviceDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resources getSystem() {
        Object object = sSync;
        synchronized (object) {
            Resources ret = mSystem;
            if (ret == null) {
                mSystem = ret = new Resources();
            }
            return ret;
        }
    }

    @Deprecated
    public Resources(AssetManager assets, DisplayMetrics metrics, Configuration config) {
        this(null);
        this.mResourcesImpl = new ResourcesImpl(assets, metrics, config, new DisplayAdjustments());
    }

    public Resources(ClassLoader classLoader) {
        this.mClassLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }

    private Resources() {
        this(null);
        DisplayMetrics metrics = new DisplayMetrics();
        metrics.setToDefaults();
        Configuration config = new Configuration();
        config.setToDefaults();
        this.mResourcesImpl = new ResourcesImpl(AssetManager.getSystem(), metrics, config, new DisplayAdjustments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImpl(ResourcesImpl impl) {
        if (impl == this.mResourcesImpl) {
            return;
        }
        this.mResourcesImpl = impl;
        ArrayList<WeakReference<Theme>> arrayList = this.mThemeRefs;
        synchronized (arrayList) {
            int count = this.mThemeRefs.size();
            for (int i = 0; i < count; ++i) {
                Theme theme;
                WeakReference<Theme> weakThemeRef = this.mThemeRefs.get(i);
                Theme theme2 = theme = weakThemeRef != null ? (Theme)weakThemeRef.get() : null;
                if (theme == null) continue;
                theme.setImpl(this.mResourcesImpl.newThemeImpl(theme.getKey()));
            }
        }
    }

    public ResourcesImpl getImpl() {
        return this.mResourcesImpl;
    }

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public final DrawableInflater getDrawableInflater() {
        if (this.mDrawableInflater == null) {
            this.mDrawableInflater = new DrawableInflater(this, this.mClassLoader);
        }
        return this.mDrawableInflater;
    }

    public ConfigurationBoundResourceCache<Animator> getAnimatorCache() {
        return this.mResourcesImpl.getAnimatorCache();
    }

    public ConfigurationBoundResourceCache<StateListAnimator> getStateListAnimatorCache() {
        return this.mResourcesImpl.getStateListAnimatorCache();
    }

    public CharSequence getText(int id2) throws NotFoundException {
        CharSequence res = this.mResourcesImpl.getAssets().getResourceText(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("String resource ID #0x" + Integer.toHexString(id2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Typeface getFont(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            Typeface typeface = impl.loadFont(this, value, id2);
            if (typeface != null) {
                Typeface typeface2 = typeface;
                return typeface2;
            }
        }
        finally {
            this.releaseTempTypedValue(value);
        }
        throw new NotFoundException("Font resource ID #0x" + Integer.toHexString(id2));
    }

    Typeface getFont(TypedValue value, int id2) throws NotFoundException {
        return this.mResourcesImpl.loadFont(this, value, id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preloadFonts(int id2) {
        TypedArray array2 = this.obtainTypedArray(id2);
        try {
            int size = array2.length();
            for (int i = 0; i < size; ++i) {
                array2.getFont(i);
            }
        }
        finally {
            array2.recycle();
        }
    }

    public CharSequence getQuantityText(int id2, int quantity) throws NotFoundException {
        return this.mResourcesImpl.getQuantityText(id2, quantity);
    }

    public String getString(int id2) throws NotFoundException {
        return this.getText(id2).toString();
    }

    public String getString(int id2, Object ... formatArgs) throws NotFoundException {
        String raw2 = this.getString(id2);
        return String.format(this.mResourcesImpl.getConfiguration().getLocales().get(0), raw2, formatArgs);
    }

    public String getQuantityString(int id2, int quantity, Object ... formatArgs) throws NotFoundException {
        String raw2 = this.getQuantityText(id2, quantity).toString();
        return String.format(this.mResourcesImpl.getConfiguration().getLocales().get(0), raw2, formatArgs);
    }

    public String getQuantityString(int id2, int quantity) throws NotFoundException {
        return this.getQuantityText(id2, quantity).toString();
    }

    public CharSequence getText(int id2, CharSequence def) {
        CharSequence res = id2 != 0 ? this.mResourcesImpl.getAssets().getResourceText(id2) : null;
        return res != null ? res : def;
    }

    public CharSequence[] getTextArray(int id2) throws NotFoundException {
        CharSequence[] res = this.mResourcesImpl.getAssets().getResourceTextArray(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Text array resource ID #0x" + Integer.toHexString(id2));
    }

    public String[] getStringArray(int id2) throws NotFoundException {
        String[] res = this.mResourcesImpl.getAssets().getResourceStringArray(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("String array resource ID #0x" + Integer.toHexString(id2));
    }

    public int[] getIntArray(int id2) throws NotFoundException {
        int[] res = this.mResourcesImpl.getAssets().getArrayIntResource(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Int array resource ID #0x" + Integer.toHexString(id2));
    }

    public TypedArray obtainTypedArray(int id2) throws NotFoundException {
        ResourcesImpl impl = this.mResourcesImpl;
        int len = impl.getAssets().getArraySize(id2);
        if (len < 0) {
            throw new NotFoundException("Array resource ID #0x" + Integer.toHexString(id2));
        }
        TypedArray array2 = TypedArray.obtain(this, len);
        array2.mLength = impl.getAssets().retrieveArray(id2, array2.mData);
        array2.mIndices[0] = 0;
        return array2;
    }

    public float getDimension(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type == 5) {
                float f = TypedValue.complexToDimension(value.data, impl.getDisplayMetrics());
                return f;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    public int getDimensionPixelOffset(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type == 5) {
                int n = TypedValue.complexToDimensionPixelOffset(value.data, impl.getDisplayMetrics());
                return n;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    public int getDimensionPixelSize(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type == 5) {
                int n = TypedValue.complexToDimensionPixelSize(value.data, impl.getDisplayMetrics());
                return n;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    public float getFraction(int id2, int base, int pbase) {
        TypedValue value = this.obtainTempTypedValue();
        try {
            this.mResourcesImpl.getValue(id2, value, true);
            if (value.type == 6) {
                float f = TypedValue.complexToFraction(value.data, base, pbase);
                return f;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @Deprecated
    public Drawable getDrawable(int id2) throws NotFoundException {
        Drawable d = this.getDrawable(id2, null);
        if (d != null && d.canApplyTheme()) {
            Log.w(TAG, "Drawable " + this.getResourceName(id2) + " has unresolved theme " + "attributes! Consider using Resources.getDrawable(int, Theme) or " + "Context.getDrawable(int).", new RuntimeException());
        }
        return d;
    }

    public Drawable getDrawable(int id2, Theme theme) throws NotFoundException {
        return this.getDrawableForDensity(id2, 0, theme);
    }

    @Deprecated
    public Drawable getDrawableForDensity(int id2, int density) throws NotFoundException {
        return this.getDrawableForDensity(id2, density, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getDrawableForDensity(int id2, int density, Theme theme) {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValueForDensity(id2, density, value, true);
            Drawable drawable2 = impl.loadDrawable(this, value, id2, density, theme);
            return drawable2;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    Drawable loadDrawable(TypedValue value, int id2, int density, Theme theme) throws NotFoundException {
        return this.mResourcesImpl.loadDrawable(this, value, id2, density, theme);
    }

    public Movie getMovie(int id2) throws NotFoundException {
        InputStream is = this.openRawResource(id2);
        Movie movie = Movie.decodeStream(is);
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return movie;
    }

    @Deprecated
    public int getColor(int id2) throws NotFoundException {
        return this.getColor(id2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColor(int id2, Theme theme) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                int n = value.data;
                return n;
            }
            if (value.type != 3) {
                throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
            }
            ColorStateList csl = impl.loadColorStateList(this, value, id2, theme);
            int n = csl.getDefaultColor();
            return n;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @Deprecated
    public ColorStateList getColorStateList(int id2) throws NotFoundException {
        ColorStateList csl = this.getColorStateList(id2, null);
        if (csl != null && csl.canApplyTheme()) {
            Log.w(TAG, "ColorStateList " + this.getResourceName(id2) + " has " + "unresolved theme attributes! Consider using " + "Resources.getColorStateList(int, Theme) or " + "Context.getColorStateList(int).", new RuntimeException());
        }
        return csl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorStateList getColorStateList(int id2, Theme theme) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            ColorStateList colorStateList = impl.loadColorStateList(this, value, id2, theme);
            return colorStateList;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    ColorStateList loadColorStateList(TypedValue value, int id2, Theme theme) throws NotFoundException {
        return this.mResourcesImpl.loadColorStateList(this, value, id2, theme);
    }

    public ComplexColor loadComplexColor(TypedValue value, int id2, Theme theme) {
        return this.mResourcesImpl.loadComplexColor(this, value, id2, theme);
    }

    public boolean getBoolean(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            this.mResourcesImpl.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                boolean bl = value.data != 0;
                return bl;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    public int getInteger(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            this.mResourcesImpl.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                int n = value.data;
                return n;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    public float getFloat(int id2) {
        TypedValue value = this.obtainTempTypedValue();
        try {
            this.mResourcesImpl.getValue(id2, value, true);
            if (value.type == 4) {
                float f = value.getFloat();
                return f;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    public XmlResourceParser getLayout(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "layout");
    }

    public XmlResourceParser getAnimation(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "anim");
    }

    public XmlResourceParser getXml(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openRawResource(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            InputStream inputStream = this.openRawResource(id2, value);
            return inputStream;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypedValue obtainTempTypedValue() {
        TypedValue tmpValue = null;
        Object object = this.mTmpValueLock;
        synchronized (object) {
            if (this.mTmpValue != null) {
                tmpValue = this.mTmpValue;
                this.mTmpValue = null;
            }
        }
        if (tmpValue == null) {
            return new TypedValue();
        }
        return tmpValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTempTypedValue(TypedValue value) {
        Object object = this.mTmpValueLock;
        synchronized (object) {
            if (this.mTmpValue == null) {
                this.mTmpValue = value;
            }
        }
    }

    public InputStream openRawResource(int id2, TypedValue value) throws NotFoundException {
        return this.mResourcesImpl.openRawResource(id2, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetFileDescriptor openRawResourceFd(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            AssetFileDescriptor assetFileDescriptor = this.mResourcesImpl.openRawResourceFd(id2, value);
            return assetFileDescriptor;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    public void getValue(int id2, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        this.mResourcesImpl.getValue(id2, outValue, resolveRefs);
    }

    public void getValueForDensity(int id2, int density, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        this.mResourcesImpl.getValueForDensity(id2, density, outValue, resolveRefs);
    }

    public void getValue(String name, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        this.mResourcesImpl.getValue(name, outValue, resolveRefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Theme newTheme() {
        Theme theme = new Theme();
        theme.setImpl(this.mResourcesImpl.newThemeImpl());
        ArrayList<WeakReference<Theme>> arrayList = this.mThemeRefs;
        synchronized (arrayList) {
            this.mThemeRefs.add(new WeakReference<Theme>(theme));
        }
        return theme;
    }

    public TypedArray obtainAttributes(AttributeSet set, int[] attrs) {
        int len = attrs.length;
        TypedArray array2 = TypedArray.obtain(this, len);
        XmlBlock.Parser parser = (XmlBlock.Parser)set;
        this.mResourcesImpl.getAssets().retrieveAttributes(parser.mParseState, attrs, array2.mData, array2.mIndices);
        array2.mXml = parser;
        return array2;
    }

    @Deprecated
    public void updateConfiguration(Configuration config, DisplayMetrics metrics) {
        this.updateConfiguration(config, metrics, null);
    }

    public void updateConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        this.mResourcesImpl.updateConfiguration(config, metrics, compat);
    }

    public static void updateSystemConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        if (mSystem != null) {
            mSystem.updateConfiguration(config, metrics, compat);
        }
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mResourcesImpl.getDisplayMetrics();
    }

    public DisplayAdjustments getDisplayAdjustments() {
        return this.mResourcesImpl.getDisplayAdjustments();
    }

    public Configuration getConfiguration() {
        return this.mResourcesImpl.getConfiguration();
    }

    public Configuration[] getSizeConfigurations() {
        return this.mResourcesImpl.getSizeConfigurations();
    }

    public CompatibilityInfo getCompatibilityInfo() {
        return this.mResourcesImpl.getCompatibilityInfo();
    }

    public void setCompatibilityInfo(CompatibilityInfo ci) {
        if (ci != null) {
            this.mResourcesImpl.updateConfiguration(null, null, ci);
        }
    }

    public int getIdentifier(String name, String defType, String defPackage) {
        return this.mResourcesImpl.getIdentifier(name, defType, defPackage);
    }

    public static boolean resourceHasPackage(int resid) {
        return resid >>> 24 != 0;
    }

    public String getResourceName(int resid) throws NotFoundException {
        return this.mResourcesImpl.getResourceName(resid);
    }

    public String getResourcePackageName(int resid) throws NotFoundException {
        return this.mResourcesImpl.getResourcePackageName(resid);
    }

    public String getResourceTypeName(int resid) throws NotFoundException {
        return this.mResourcesImpl.getResourceTypeName(resid);
    }

    public String getResourceEntryName(int resid) throws NotFoundException {
        return this.mResourcesImpl.getResourceEntryName(resid);
    }

    public void parseBundleExtras(XmlResourceParser parser, Bundle outBundle) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("extra")) {
                this.parseBundleExtra("extra", parser, outBundle);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseBundleExtra(String tagName, AttributeSet attrs, Bundle outBundle) throws XmlPullParserException {
        TypedArray sa = this.obtainAttributes(attrs, R.styleable.Extra);
        String name = sa.getString(0);
        if (name == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an android:name attribute at " + attrs.getPositionDescription());
        }
        TypedValue v = sa.peekValue(1);
        if (v == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an android:value or android:resource attribute at " + attrs.getPositionDescription());
        }
        if (v.type == 3) {
            CharSequence cs = v.coerceToString();
            outBundle.putCharSequence(name, cs);
        } else if (v.type == 18) {
            outBundle.putBoolean(name, v.data != 0);
        } else if (v.type >= 16 && v.type <= 31) {
            outBundle.putInt(name, v.data);
        } else {
            if (v.type != 4) {
                sa.recycle();
                throw new XmlPullParserException("<" + tagName + "> only supports string, integer, float, color, and boolean at " + attrs.getPositionDescription());
            }
            outBundle.putFloat(name, v.getFloat());
        }
        sa.recycle();
    }

    public final AssetManager getAssets() {
        return this.mResourcesImpl.getAssets();
    }

    public final void flushLayoutCache() {
        this.mResourcesImpl.flushLayoutCache();
    }

    public final void startPreloading() {
        this.mResourcesImpl.startPreloading();
    }

    public final void finishPreloading() {
        this.mResourcesImpl.finishPreloading();
    }

    public LongSparseArray<Drawable.ConstantState> getPreloadedDrawables() {
        return this.mResourcesImpl.getPreloadedDrawables();
    }

    XmlResourceParser loadXmlResourceParser(int id2, String type) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type == 3) {
                XmlResourceParser xmlResourceParser = impl.loadXmlResourceParser(value.string.toString(), id2, value.assetCookie, type);
                return xmlResourceParser;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    XmlResourceParser loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws NotFoundException {
        return this.mResourcesImpl.loadXmlResourceParser(file, id2, assetCookie, type);
    }

    public int calcConfigChanges(Configuration config) {
        return this.mResourcesImpl.calcConfigChanges(config);
    }

    public static TypedArray obtainAttributes(Resources res, Theme theme, AttributeSet set, int[] attrs) {
        if (theme == null) {
            return res.obtainAttributes(set, attrs);
        }
        return theme.obtainStyledAttributes(set, attrs, 0, 0);
    }

    static class ThemeKey
    implements Cloneable {
        int[] mResId;
        boolean[] mForce;
        int mCount;
        private int mHashCode = 0;

        ThemeKey() {
        }

        public void append(int resId, boolean force) {
            if (this.mResId == null) {
                this.mResId = new int[4];
            }
            if (this.mForce == null) {
                this.mForce = new boolean[4];
            }
            this.mResId = GrowingArrayUtils.append(this.mResId, this.mCount, resId);
            this.mForce = GrowingArrayUtils.append(this.mForce, this.mCount, force);
            ++this.mCount;
            this.mHashCode = 31 * (31 * this.mHashCode + resId) + (force ? 1 : 0);
        }

        public void setTo(ThemeKey other) {
            this.mResId = other.mResId == null ? null : (int[])other.mResId.clone();
            this.mForce = other.mForce == null ? null : (boolean[])other.mForce.clone();
            this.mCount = other.mCount;
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass() || this.hashCode() != o.hashCode()) {
                return false;
            }
            ThemeKey t = (ThemeKey)o;
            if (this.mCount != t.mCount) {
                return false;
            }
            int N = this.mCount;
            for (int i = 0; i < N; ++i) {
                if (this.mResId[i] == t.mResId[i] && this.mForce[i] == t.mForce[i]) continue;
                return false;
            }
            return true;
        }

        public ThemeKey clone() {
            ThemeKey other = new ThemeKey();
            other.mResId = this.mResId;
            other.mForce = this.mForce;
            other.mCount = this.mCount;
            other.mHashCode = this.mHashCode;
            return other;
        }
    }

    public final class Theme {
        private ResourcesImpl.ThemeImpl mThemeImpl;

        private Theme() {
        }

        void setImpl(ResourcesImpl.ThemeImpl impl) {
            this.mThemeImpl = impl;
        }

        public void applyStyle(int resId, boolean force) {
            this.mThemeImpl.applyStyle(resId, force);
        }

        public void setTo(Theme other) {
            this.mThemeImpl.setTo(other.mThemeImpl);
        }

        public TypedArray obtainStyledAttributes(int[] attrs) {
            return this.mThemeImpl.obtainStyledAttributes(this, null, attrs, 0, 0);
        }

        public TypedArray obtainStyledAttributes(int resId, int[] attrs) throws NotFoundException {
            return this.mThemeImpl.obtainStyledAttributes(this, null, attrs, 0, resId);
        }

        public TypedArray obtainStyledAttributes(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
            return this.mThemeImpl.obtainStyledAttributes(this, set, attrs, defStyleAttr, defStyleRes);
        }

        public TypedArray resolveAttributes(int[] values, int[] attrs) {
            return this.mThemeImpl.resolveAttributes(this, values, attrs);
        }

        public boolean resolveAttribute(int resid, TypedValue outValue, boolean resolveRefs) {
            return this.mThemeImpl.resolveAttribute(resid, outValue, resolveRefs);
        }

        public int[] getAllAttributes() {
            return this.mThemeImpl.getAllAttributes();
        }

        public Resources getResources() {
            return Resources.this;
        }

        public Drawable getDrawable(int id2) throws NotFoundException {
            return Resources.this.getDrawable(id2, this);
        }

        public int getChangingConfigurations() {
            return this.mThemeImpl.getChangingConfigurations();
        }

        public void dump(int priority, String tag, String prefix) {
            this.mThemeImpl.dump(priority, tag, prefix);
        }

        long getNativeTheme() {
            return this.mThemeImpl.getNativeTheme();
        }

        int getAppliedStyleResId() {
            return this.mThemeImpl.getAppliedStyleResId();
        }

        public ThemeKey getKey() {
            return this.mThemeImpl.getKey();
        }

        private String getResourceNameFromHexString(String hexString) {
            return Resources.this.getResourceName(Integer.parseInt(hexString, 16));
        }

        @ViewDebug.ExportedProperty(category="theme", hasAdjacentMapping=true)
        public String[] getTheme() {
            return this.mThemeImpl.getTheme();
        }

        public void encode(ViewHierarchyEncoder encoder) {
            encoder.beginObject(this);
            String[] properties = this.getTheme();
            for (int i = 0; i < properties.length; i += 2) {
                encoder.addProperty(properties[i], properties[i + 1]);
            }
            encoder.endObject();
        }

        public void rebase() {
            this.mThemeImpl.rebase();
        }
    }

    public static class NotFoundException
    extends RuntimeException {
        public NotFoundException() {
        }

        public NotFoundException(String name) {
            super(name);
        }

        public NotFoundException(String name, Exception cause) {
            super(name, cause);
        }
    }
}

