/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothMap;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public final class BluetoothMap
implements BluetoothProfile {
    private static final String TAG = "BluetoothMap";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.map.profile.action.CONNECTION_STATE_CHANGED";
    private volatile IBluetoothMap mService;
    private final Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private BluetoothAdapter mAdapter;
    public static final int STATE_ERROR = -1;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_CANCELED = 2;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothStateChange(boolean up) {
            Log.d(BluetoothMap.TAG, "onBluetoothStateChange: up=" + up);
            if (!up) {
                ServiceConnection serviceConnection = BluetoothMap.this.mConnection;
                synchronized (serviceConnection) {
                    try {
                        BluetoothMap.this.mService = null;
                        BluetoothMap.this.mContext.unbindService(BluetoothMap.this.mConnection);
                    }
                    catch (Exception re) {
                        Log.e(BluetoothMap.TAG, "", re);
                    }
                }
            }
            ServiceConnection serviceConnection = BluetoothMap.this.mConnection;
            synchronized (serviceConnection) {
                try {
                    if (BluetoothMap.this.mService == null) {
                        BluetoothMap.this.doBind();
                    }
                }
                catch (Exception re) {
                    Log.e(BluetoothMap.TAG, "", re);
                }
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            BluetoothMap.log("Proxy object connected");
            BluetoothMap.this.mService = IBluetoothMap.Stub.asInterface(Binder.allowBlocking(service));
            if (BluetoothMap.this.mServiceListener != null) {
                BluetoothMap.this.mServiceListener.onServiceConnected(9, BluetoothMap.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName className) {
            BluetoothMap.log("Proxy object disconnected");
            BluetoothMap.this.mService = null;
            if (BluetoothMap.this.mServiceListener != null) {
                BluetoothMap.this.mServiceListener.onServiceDisconnected(9);
            }
        }
    };

    BluetoothMap(Context context, BluetoothProfile.ServiceListener l) {
        Log.d(TAG, "Create BluetoothMap proxy object");
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        this.doBind();
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothMap.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth MAP Service with " + intent);
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e(TAG, "", e);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e(TAG, "", re);
                }
            }
        }
        this.mServiceListener = null;
    }

    public int getState() {
        IBluetoothMap service = this.mService;
        if (service != null) {
            try {
                return service.getState();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        }
        return -1;
    }

    public BluetoothDevice getClient() {
        IBluetoothMap service = this.mService;
        if (service != null) {
            try {
                return service.getClient();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        }
        return null;
    }

    public boolean isConnected(BluetoothDevice device) {
        IBluetoothMap service = this.mService;
        if (service != null) {
            try {
                return service.isConnected(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    public boolean connect(BluetoothDevice device) {
        BluetoothMap.log("connect(" + device + ")" + "not supported for MAPS");
        return false;
    }

    public boolean disconnect(BluetoothDevice device) {
        BluetoothMap.log("disconnect(" + device + ")");
        IBluetoothMap service = this.mService;
        if (service != null && this.isEnabled() && BluetoothMap.isValidDevice(device)) {
            try {
                return service.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public static boolean doesClassMatchSink(BluetoothClass btClass) {
        switch (btClass.getDeviceClass()) {
            case 256: 
            case 260: 
            case 264: 
            case 268: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        BluetoothMap.log("getConnectedDevices()");
        IBluetoothMap service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        BluetoothMap.log("getDevicesMatchingStates()");
        IBluetoothMap service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public int getConnectionState(BluetoothDevice device) {
        BluetoothMap.log("getConnectionState(" + device + ")");
        IBluetoothMap service = this.mService;
        if (service != null && this.isEnabled() && BluetoothMap.isValidDevice(device)) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    public boolean setPriority(BluetoothDevice device, int priority) {
        BluetoothMap.log("setPriority(" + device + ", " + priority + ")");
        IBluetoothMap service = this.mService;
        if (service != null && this.isEnabled() && BluetoothMap.isValidDevice(device)) {
            if (priority != 0 && priority != 100) {
                return false;
            }
            try {
                return service.setPriority(device, priority);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public int getPriority(BluetoothDevice device) {
        IBluetoothMap service = this.mService;
        if (service != null && this.isEnabled() && BluetoothMap.isValidDevice(device)) {
            try {
                return service.getPriority(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    private boolean isEnabled() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && adapter.getState() == 12) {
            return true;
        }
        BluetoothMap.log("Bluetooth is Not enabled");
        return false;
    }

    private static boolean isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }
}

