/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.app.Service;
import android.app.usage.CacheQuotaHint;
import android.app.usage.ICacheQuotaService;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallback;
import android.util.Log;
import android.util.Pair;
import java.util.List;

public abstract class CacheQuotaService
extends Service {
    private static final String TAG = "CacheQuotaService";
    public static final String SERVICE_INTERFACE = "android.app.usage.CacheQuotaService";
    public static final String REQUEST_LIST_KEY = "requests";
    private CacheQuotaServiceWrapper mWrapper;
    private Handler mHandler;

    @Override
    public void onCreate() {
        super.onCreate();
        this.mWrapper = new CacheQuotaServiceWrapper();
        this.mHandler = new ServiceHandler(this.getMainLooper());
    }

    @Override
    public IBinder onBind(Intent intent) {
        return this.mWrapper;
    }

    public abstract List<CacheQuotaHint> onComputeCacheQuotaHints(List<CacheQuotaHint> var1);

    private final class ServiceHandler
    extends Handler {
        public static final int MSG_SEND_LIST = 1;

        public ServiceHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            int action = msg.what;
            switch (action) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    List<CacheQuotaHint> processed = CacheQuotaService.this.onComputeCacheQuotaHints((List)pair.second);
                    Bundle data = new Bundle();
                    data.putParcelableList(CacheQuotaService.REQUEST_LIST_KEY, processed);
                    RemoteCallback callback = (RemoteCallback)pair.first;
                    callback.sendResult(data);
                    break;
                }
                default: {
                    Log.w(CacheQuotaService.TAG, "Handling unknown message: " + action);
                }
            }
        }
    }

    private final class CacheQuotaServiceWrapper
    extends ICacheQuotaService.Stub {
        private CacheQuotaServiceWrapper() {
        }

        @Override
        public void computeCacheQuotaHints(RemoteCallback callback, List<CacheQuotaHint> requests) {
            Pair<RemoteCallback, List<CacheQuotaHint>> pair = Pair.create(callback, requests);
            Message msg = CacheQuotaService.this.mHandler.obtainMessage(1, pair);
            CacheQuotaService.this.mHandler.sendMessage(msg);
        }
    }
}

