/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.app.admin.NetworkEvent;
import android.os.Parcel;
import android.os.Parcelable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DnsEvent
extends NetworkEvent
implements Parcelable {
    private final String hostname;
    private final String[] ipAddresses;
    private final int ipAddressesCount;
    public static final Parcelable.Creator<DnsEvent> CREATOR = new Parcelable.Creator<DnsEvent>(){

        @Override
        public DnsEvent createFromParcel(Parcel in) {
            if (in.readInt() != 1) {
                return null;
            }
            return new DnsEvent(in);
        }

        public DnsEvent[] newArray(int size) {
            return new DnsEvent[size];
        }
    };

    public DnsEvent(String hostname, String[] ipAddresses, int ipAddressesCount, String packageName, long timestamp) {
        super(packageName, timestamp);
        this.hostname = hostname;
        this.ipAddresses = ipAddresses;
        this.ipAddressesCount = ipAddressesCount;
    }

    private DnsEvent(Parcel in) {
        this.hostname = in.readString();
        this.ipAddresses = in.createStringArray();
        this.ipAddressesCount = in.readInt();
        this.packageName = in.readString();
        this.timestamp = in.readLong();
    }

    public String getHostname() {
        return this.hostname;
    }

    public List<InetAddress> getInetAddresses() {
        if (this.ipAddresses == null || this.ipAddresses.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>(this.ipAddresses.length);
        for (String ipAddress : this.ipAddresses) {
            try {
                inetAddresses.add(InetAddress.getByName(ipAddress));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return inetAddresses;
    }

    public int getTotalResolvedAddressCount() {
        return this.ipAddressesCount;
    }

    public String toString() {
        return String.format("DnsEvent(%s, %s, %d, %d, %s)", this.hostname, this.ipAddresses == null ? "NONE" : String.join((CharSequence)" ", this.ipAddresses), this.ipAddressesCount, this.timestamp, this.packageName);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(1);
        out.writeString(this.hostname);
        out.writeStringArray(this.ipAddresses);
        out.writeInt(this.ipAddressesCount);
        out.writeString(this.packageName);
        out.writeLong(this.timestamp);
    }
}

