/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.IWallpaperManager;
import android.app.IWallpaperManagerCallback;
import android.app.WallpaperColors;
import android.app.WallpaperInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.DeadSystemException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.view.WindowManagerGlobal;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;

public class WallpaperManager {
    private static String TAG = "WallpaperManager";
    private static boolean DEBUG = false;
    private float mWallpaperXStep = -1.0f;
    private float mWallpaperYStep = -1.0f;
    private static final String PROP_WALLPAPER = "ro.config.wallpaper";
    private static final String PROP_LOCK_WALLPAPER = "ro.config.lock_wallpaper";
    private static final String PROP_WALLPAPER_COMPONENT = "ro.config.wallpaper_component";
    public static final String ACTION_CROP_AND_SET_WALLPAPER = "android.service.wallpaper.CROP_AND_SET_WALLPAPER";
    public static final String ACTION_LIVE_WALLPAPER_CHOOSER = "android.service.wallpaper.LIVE_WALLPAPER_CHOOSER";
    public static final String ACTION_CHANGE_LIVE_WALLPAPER = "android.service.wallpaper.CHANGE_LIVE_WALLPAPER";
    public static final String EXTRA_LIVE_WALLPAPER_COMPONENT = "android.service.wallpaper.extra.LIVE_WALLPAPER_COMPONENT";
    public static final String WALLPAPER_PREVIEW_META_DATA = "android.wallpaper.preview";
    public static final String COMMAND_TAP = "android.wallpaper.tap";
    public static final String COMMAND_SECONDARY_TAP = "android.wallpaper.secondaryTap";
    public static final String COMMAND_DROP = "android.home.drop";
    public static final String EXTRA_NEW_WALLPAPER_ID = "android.service.wallpaper.extra.ID";
    public static final int FLAG_SYSTEM = 1;
    public static final int FLAG_LOCK = 2;
    private final Context mContext;
    private static final Object sSync = new Object[0];
    private static Globals sGlobals;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initGlobals(Looper looper) {
        Object object = sSync;
        synchronized (object) {
            if (sGlobals == null) {
                sGlobals = new Globals(looper);
            }
        }
    }

    WallpaperManager(Context context, Handler handler) {
        this.mContext = context;
        WallpaperManager.initGlobals(context.getMainLooper());
    }

    public static WallpaperManager getInstance(Context context) {
        return (WallpaperManager)context.getSystemService("wallpaper");
    }

    public IWallpaperManager getIWallpaperManager() {
        return sGlobals.mService;
    }

    public Drawable getDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, true, 1);
        if (bm != null) {
            BitmapDrawable dr = new BitmapDrawable(this.mContext.getResources(), bm);
            ((Drawable)dr).setDither(false);
            return dr;
        }
        return null;
    }

    public Drawable getBuiltInDrawable() {
        return this.getBuiltInDrawable(0, 0, false, 0.0f, 0.0f, 1);
    }

    public Drawable getBuiltInDrawable(int which) {
        return this.getBuiltInDrawable(0, 0, false, 0.0f, 0.0f, which);
    }

    public Drawable getBuiltInDrawable(int outWidth, int outHeight, boolean scaleToFit, float horizontalAlignment, float verticalAlignment) {
        return this.getBuiltInDrawable(outWidth, outHeight, scaleToFit, horizontalAlignment, verticalAlignment, 1);
    }

    public Drawable getBuiltInDrawable(int outWidth, int outHeight, boolean scaleToFit, float horizontalAlignment, float verticalAlignment, int which) {
        RectF cropRectF;
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        if (which != 1 && which != 2) {
            throw new IllegalArgumentException("Must request exactly one kind of wallpaper");
        }
        Resources resources = this.mContext.getResources();
        horizontalAlignment = Math.max(0.0f, Math.min(1.0f, horizontalAlignment));
        verticalAlignment = Math.max(0.0f, Math.min(1.0f, verticalAlignment));
        InputStream wpStream = WallpaperManager.openDefaultWallpaper(this.mContext, which);
        if (wpStream == null) {
            if (DEBUG) {
                Log.w(TAG, "default wallpaper stream " + which + " is null");
            }
            return null;
        }
        BufferedInputStream is = new BufferedInputStream(wpStream);
        if (outWidth <= 0 || outHeight <= 0) {
            Bitmap fullSize = BitmapFactory.decodeStream(is, null, null);
            return new BitmapDrawable(resources, fullSize);
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream(is, null, options);
        if (options.outWidth == 0 || options.outHeight == 0) {
            Log.e(TAG, "default wallpaper dimensions are 0");
            return null;
        }
        int inWidth = options.outWidth;
        int inHeight = options.outHeight;
        is = new BufferedInputStream(WallpaperManager.openDefaultWallpaper(this.mContext, which));
        outWidth = Math.min(inWidth, outWidth);
        outHeight = Math.min(inHeight, outHeight);
        if (scaleToFit) {
            cropRectF = WallpaperManager.getMaxCropRect(inWidth, inHeight, outWidth, outHeight, horizontalAlignment, verticalAlignment);
        } else {
            float left = (float)(inWidth - outWidth) * horizontalAlignment;
            float right = left + (float)outWidth;
            float top = (float)(inHeight - outHeight) * verticalAlignment;
            float bottom = top + (float)outHeight;
            cropRectF = new RectF(left, top, right, bottom);
        }
        Rect roundedTrueCrop = new Rect();
        cropRectF.roundOut(roundedTrueCrop);
        if (roundedTrueCrop.width() <= 0 || roundedTrueCrop.height() <= 0) {
            Log.w(TAG, "crop has bad values for full size image");
            return null;
        }
        int scaleDownSampleSize = Math.min(roundedTrueCrop.width() / outWidth, roundedTrueCrop.height() / outHeight);
        BitmapRegionDecoder decoder = null;
        try {
            decoder = BitmapRegionDecoder.newInstance(is, true);
        }
        catch (IOException e) {
            Log.w(TAG, "cannot open region decoder for default wallpaper");
        }
        Bitmap crop = null;
        if (decoder != null) {
            BitmapFactory.Options options2 = new BitmapFactory.Options();
            if (scaleDownSampleSize > 1) {
                options2.inSampleSize = scaleDownSampleSize;
            }
            crop = decoder.decodeRegion(roundedTrueCrop, options2);
            decoder.recycle();
        }
        if (crop == null) {
            is = new BufferedInputStream(WallpaperManager.openDefaultWallpaper(this.mContext, which));
            Bitmap fullSize = null;
            BitmapFactory.Options options3 = new BitmapFactory.Options();
            if (scaleDownSampleSize > 1) {
                options3.inSampleSize = scaleDownSampleSize;
            }
            if ((fullSize = BitmapFactory.decodeStream(is, null, options3)) != null) {
                crop = Bitmap.createBitmap(fullSize, roundedTrueCrop.left, roundedTrueCrop.top, roundedTrueCrop.width(), roundedTrueCrop.height());
            }
        }
        if (crop == null) {
            Log.w(TAG, "cannot decode default wallpaper");
            return null;
        }
        if (outWidth > 0 && outHeight > 0 && (crop.getWidth() != outWidth || crop.getHeight() != outHeight)) {
            Matrix m = new Matrix();
            RectF cropRect = new RectF(0.0f, 0.0f, crop.getWidth(), crop.getHeight());
            RectF returnRect = new RectF(0.0f, 0.0f, outWidth, outHeight);
            m.setRectToRect(cropRect, returnRect, Matrix.ScaleToFit.FILL);
            Bitmap tmp = Bitmap.createBitmap((int)returnRect.width(), (int)returnRect.height(), Bitmap.Config.ARGB_8888);
            if (tmp != null) {
                Canvas c = new Canvas(tmp);
                Paint p = new Paint();
                p.setFilterBitmap(true);
                c.drawBitmap(crop, m, p);
                crop = tmp;
            }
        }
        return new BitmapDrawable(resources, crop);
    }

    private static RectF getMaxCropRect(int inWidth, int inHeight, int outWidth, int outHeight, float horizontalAlignment, float verticalAlignment) {
        RectF cropRect = new RectF();
        if ((float)inWidth / (float)inHeight > (float)outWidth / (float)outHeight) {
            cropRect.top = 0.0f;
            cropRect.bottom = inHeight;
            float cropWidth = (float)outWidth * ((float)inHeight / (float)outHeight);
            cropRect.left = ((float)inWidth - cropWidth) * horizontalAlignment;
            cropRect.right = cropRect.left + cropWidth;
        } else {
            cropRect.left = 0.0f;
            cropRect.right = inWidth;
            float cropHeight = (float)outHeight * ((float)inWidth / (float)outWidth);
            cropRect.top = ((float)inHeight - cropHeight) * verticalAlignment;
            cropRect.bottom = cropRect.top + cropHeight;
        }
        return cropRect;
    }

    public Drawable peekDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, false, 1);
        if (bm != null) {
            BitmapDrawable dr = new BitmapDrawable(this.mContext.getResources(), bm);
            ((Drawable)dr).setDither(false);
            return dr;
        }
        return null;
    }

    public Drawable getFastDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, true, 1);
        if (bm != null) {
            return new FastBitmapDrawable(bm);
        }
        return null;
    }

    public Drawable peekFastDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, false, 1);
        if (bm != null) {
            return new FastBitmapDrawable(bm);
        }
        return null;
    }

    public Bitmap getBitmap() {
        return this.getBitmapAsUser(this.mContext.getUserId());
    }

    public Bitmap getBitmapAsUser(int userId) {
        return sGlobals.peekWallpaperBitmap(this.mContext, true, 1, userId);
    }

    public ParcelFileDescriptor getWallpaperFile(int which) {
        return this.getWallpaperFile(which, this.mContext.getUserId());
    }

    public void addOnColorsChangedListener(OnColorsChangedListener listener, Handler handler) {
        this.addOnColorsChangedListener(listener, handler, this.mContext.getUserId());
    }

    public void addOnColorsChangedListener(OnColorsChangedListener listener, Handler handler, int userId) {
        sGlobals.addOnColorsChangedListener(listener, handler, userId);
    }

    public void removeOnColorsChangedListener(OnColorsChangedListener callback) {
        this.removeOnColorsChangedListener(callback, this.mContext.getUserId());
    }

    public void removeOnColorsChangedListener(OnColorsChangedListener callback, int userId) {
        sGlobals.removeOnColorsChangedListener(callback, userId);
    }

    public WallpaperColors getWallpaperColors(int which) {
        return this.getWallpaperColors(which, this.mContext.getUserId());
    }

    public WallpaperColors getWallpaperColors(int which, int userId) {
        return sGlobals.getWallpaperColors(which, userId);
    }

    public ParcelFileDescriptor getWallpaperFile(int which, int userId) {
        if (which != 1 && which != 2) {
            throw new IllegalArgumentException("Must request exactly one kind of wallpaper");
        }
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            Bundle outParams = new Bundle();
            return sGlobals.mService.getWallpaper(this.mContext.getOpPackageName(), null, which, outParams, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SecurityException e) {
            if (this.mContext.getApplicationInfo().targetSdkVersion <= 26) {
                Log.w(TAG, "No permission to access wallpaper, suppressing exception to avoid crashing legacy app.");
                return null;
            }
            throw e;
        }
    }

    public void forgetLoadedWallpaper() {
        sGlobals.forgetLoadedWallpaper();
    }

    public WallpaperInfo getWallpaperInfo() {
        try {
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            return sGlobals.mService.getWallpaperInfo(UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getWallpaperId(int which) {
        return this.getWallpaperIdForUser(which, this.mContext.getUserId());
    }

    public int getWallpaperIdForUser(int which, int userId) {
        try {
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            return sGlobals.mService.getWallpaperIdForUser(which, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Intent getCropAndSetWallpaperIntent(Uri imageUri) {
        if (imageUri == null) {
            throw new IllegalArgumentException("Image URI must not be null");
        }
        if (!"content".equals(imageUri.getScheme())) {
            throw new IllegalArgumentException("Image URI must be of the content scheme type");
        }
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent cropAndSetWallpaperIntent = new Intent(ACTION_CROP_AND_SET_WALLPAPER, imageUri);
        cropAndSetWallpaperIntent.addFlags(1);
        Intent homeIntent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME");
        ResolveInfo resolvedHome = packageManager.resolveActivity(homeIntent, 65536);
        if (resolvedHome != null) {
            cropAndSetWallpaperIntent.setPackage(resolvedHome.activityInfo.packageName);
            List<ResolveInfo> cropAppList = packageManager.queryIntentActivities(cropAndSetWallpaperIntent, 0);
            if (cropAppList.size() > 0) {
                return cropAndSetWallpaperIntent;
            }
        }
        String cropperPackage = this.mContext.getString(17039691);
        cropAndSetWallpaperIntent.setPackage(cropperPackage);
        List<ResolveInfo> cropAppList = packageManager.queryIntentActivities(cropAndSetWallpaperIntent, 0);
        if (cropAppList.size() > 0) {
            return cropAndSetWallpaperIntent;
        }
        throw new IllegalArgumentException("Cannot use passed URI to set wallpaper; check that the type returned by ContentProvider matches image/*");
    }

    public void setResource(int resid) throws IOException {
        this.setResource(resid, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setResource(int resid, int which) throws IOException {
        Bundle result;
        block5: {
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            result = new Bundle();
            WallpaperSetCompletion completion = new WallpaperSetCompletion();
            try {
                Resources resources = this.mContext.getResources();
                ParcelFileDescriptor fd = sGlobals.mService.setWallpaper("res:" + resources.getResourceName(resid), this.mContext.getOpPackageName(), null, false, result, which, completion, UserHandle.myUserId());
                if (fd == null) break block5;
                ParcelFileDescriptor.AutoCloseOutputStream fos = null;
                boolean ok = false;
                try {
                    fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                    this.copyStreamToWallpaperFile(resources.openRawResource(resid), fos);
                    ((FileOutputStream)fos).close();
                    completion.waitForCompletion();
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fos);
                    throw throwable;
                }
                IoUtils.closeQuietly(fos);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result.getInt(EXTRA_NEW_WALLPAPER_ID, 0);
    }

    public void setBitmap(Bitmap bitmap) throws IOException {
        this.setBitmap(bitmap, null, true);
    }

    public int setBitmap(Bitmap fullImage, Rect visibleCropHint, boolean allowBackup) throws IOException {
        return this.setBitmap(fullImage, visibleCropHint, allowBackup, 3);
    }

    public int setBitmap(Bitmap fullImage, Rect visibleCropHint, boolean allowBackup, int which) throws IOException {
        return this.setBitmap(fullImage, visibleCropHint, allowBackup, which, UserHandle.myUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBitmap(Bitmap fullImage, Rect visibleCropHint, boolean allowBackup, int which, int userId) throws IOException {
        Bundle result;
        block5: {
            this.validateRect(visibleCropHint);
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            result = new Bundle();
            WallpaperSetCompletion completion = new WallpaperSetCompletion();
            try {
                ParcelFileDescriptor fd = sGlobals.mService.setWallpaper(null, this.mContext.getOpPackageName(), visibleCropHint, allowBackup, result, which, completion, userId);
                if (fd == null) break block5;
                ParcelFileDescriptor.AutoCloseOutputStream fos = null;
                try {
                    fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                    fullImage.compress(Bitmap.CompressFormat.PNG, 90, fos);
                    ((FileOutputStream)fos).close();
                    completion.waitForCompletion();
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fos);
                    throw throwable;
                }
                IoUtils.closeQuietly(fos);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result.getInt(EXTRA_NEW_WALLPAPER_ID, 0);
    }

    private final void validateRect(Rect rect) {
        if (rect != null && rect.isEmpty()) {
            throw new IllegalArgumentException("visibleCrop rectangle must be valid and non-empty");
        }
    }

    public void setStream(InputStream bitmapData) throws IOException {
        this.setStream(bitmapData, null, true);
    }

    private void copyStreamToWallpaperFile(InputStream data, FileOutputStream fos) throws IOException {
        int amt;
        byte[] buffer = new byte[32768];
        while ((amt = data.read(buffer)) > 0) {
            fos.write(buffer, 0, amt);
        }
    }

    public int setStream(InputStream bitmapData, Rect visibleCropHint, boolean allowBackup) throws IOException {
        return this.setStream(bitmapData, visibleCropHint, allowBackup, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setStream(InputStream bitmapData, Rect visibleCropHint, boolean allowBackup, int which) throws IOException {
        Bundle result;
        block5: {
            this.validateRect(visibleCropHint);
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            result = new Bundle();
            WallpaperSetCompletion completion = new WallpaperSetCompletion();
            try {
                ParcelFileDescriptor fd = sGlobals.mService.setWallpaper(null, this.mContext.getOpPackageName(), visibleCropHint, allowBackup, result, which, completion, UserHandle.myUserId());
                if (fd == null) break block5;
                ParcelFileDescriptor.AutoCloseOutputStream fos = null;
                try {
                    fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                    this.copyStreamToWallpaperFile(bitmapData, fos);
                    ((FileOutputStream)fos).close();
                    completion.waitForCompletion();
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fos);
                    throw throwable;
                }
                IoUtils.closeQuietly(fos);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result.getInt(EXTRA_NEW_WALLPAPER_ID, 0);
    }

    public boolean hasResourceWallpaper(int resid) {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            Resources resources = this.mContext.getResources();
            String name = "res:" + resources.getResourceName(resid);
            return sGlobals.mService.hasNamedWallpaper(name);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getDesiredMinimumWidth() {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return sGlobals.mService.getWidthHint();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getDesiredMinimumHeight() {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return sGlobals.mService.getHeightHint();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void suggestDesiredDimensions(int minimumWidth, int minimumHeight) {
        try {
            int maximumTextureSize;
            try {
                maximumTextureSize = SystemProperties.getInt("sys.max_texture_size", 0);
            }
            catch (Exception e) {
                maximumTextureSize = 0;
            }
            if (maximumTextureSize > 0 && (minimumWidth > maximumTextureSize || minimumHeight > maximumTextureSize)) {
                float aspect = (float)minimumHeight / (float)minimumWidth;
                if (minimumWidth > minimumHeight) {
                    minimumWidth = maximumTextureSize;
                    minimumHeight = (int)((double)((float)minimumWidth * aspect) + 0.5);
                } else {
                    minimumHeight = maximumTextureSize;
                    minimumWidth = (int)((double)((float)minimumHeight / aspect) + 0.5);
                }
            }
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            sGlobals.mService.setDimensionHints(minimumWidth, minimumHeight, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setDisplayPadding(Rect padding) {
        try {
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            sGlobals.mService.setDisplayPadding(padding, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setDisplayOffset(IBinder windowToken, int x, int y) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperDisplayOffset(windowToken, x, y);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void clearWallpaper() {
        this.clearWallpaper(2, this.mContext.getUserId());
        this.clearWallpaper(1, this.mContext.getUserId());
    }

    public void clearWallpaper(int which, int userId) {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            sGlobals.mService.clearWallpaper(this.mContext.getOpPackageName(), which, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean setWallpaperComponent(ComponentName name) {
        return this.setWallpaperComponent(name, UserHandle.myUserId());
    }

    public boolean setWallpaperComponent(ComponentName name, int userId) {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            sGlobals.mService.setWallpaperComponentChecked(name, this.mContext.getOpPackageName(), userId);
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setWallpaperOffsets(IBinder windowToken, float xOffset, float yOffset) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperPosition(windowToken, xOffset, yOffset, this.mWallpaperXStep, this.mWallpaperYStep);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setWallpaperOffsetSteps(float xStep, float yStep) {
        this.mWallpaperXStep = xStep;
        this.mWallpaperYStep = yStep;
    }

    public void sendWallpaperCommand(IBinder windowToken, String action, int x, int y, int z, Bundle extras) {
        try {
            WindowManagerGlobal.getWindowSession().sendWallpaperCommand(windowToken, action, x, y, z, extras, false);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isWallpaperSupported() {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return sGlobals.mService.isWallpaperSupported(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isSetWallpaperAllowed() {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return sGlobals.mService.isSetWallpaperAllowed(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void clearWallpaperOffsets(IBinder windowToken) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperPosition(windowToken, -1.0f, -1.0f, -1.0f, -1.0f);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void clear() throws IOException {
        this.setStream(WallpaperManager.openDefaultWallpaper(this.mContext, 1), null, false);
    }

    public void clear(int which) throws IOException {
        if ((which & 1) != 0) {
            this.clear();
        }
        if ((which & 2) != 0) {
            this.clearWallpaper(2, this.mContext.getUserId());
        }
    }

    public static InputStream openDefaultWallpaper(Context context, int which) {
        File file;
        if (which == 2) {
            return null;
        }
        String whichProp = PROP_WALLPAPER;
        int defaultResId = 17302115;
        String path = SystemProperties.get(whichProp);
        if (!TextUtils.isEmpty(path) && (file = new File(path)).exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            return context.getResources().openRawResource(defaultResId);
        }
        catch (Resources.NotFoundException notFoundException) {
            return null;
        }
    }

    public static ComponentName getDefaultWallpaperComponent(Context context) {
        ComponentName cn;
        String flat = SystemProperties.get(PROP_WALLPAPER_COMPONENT);
        if (!TextUtils.isEmpty(flat) && (cn = ComponentName.unflattenFromString(flat)) != null) {
            return cn;
        }
        flat = context.getString(17039757);
        if (!TextUtils.isEmpty(flat) && (cn = ComponentName.unflattenFromString(flat)) != null) {
            return cn;
        }
        return null;
    }

    public boolean setLockWallpaperCallback(IWallpaperManagerCallback callback) {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return sGlobals.mService.setLockWallpaperCallback(callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isWallpaperBackupEligible(int which) {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return sGlobals.mService.isWallpaperBackupEligible(which, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception querying wallpaper backup eligibility: " + e.getMessage());
            return false;
        }
    }

    public static interface OnColorsChangedListener {
        public void onColorsChanged(WallpaperColors var1, int var2);

        default public void onColorsChanged(WallpaperColors colors, int which, int userId) {
            this.onColorsChanged(colors, which);
        }
    }

    private class WallpaperSetCompletion
    extends IWallpaperManagerCallback.Stub {
        final CountDownLatch mLatch = new CountDownLatch(1);

        public void waitForCompletion() {
            try {
                this.mLatch.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void onWallpaperChanged() throws RemoteException {
            this.mLatch.countDown();
        }

        @Override
        public void onWallpaperColorsChanged(WallpaperColors colors, int which, int userId) throws RemoteException {
            sGlobals.onWallpaperColorsChanged(colors, which, userId);
        }
    }

    private static class Globals
    extends IWallpaperManagerCallback.Stub {
        private final IWallpaperManager mService;
        private boolean mColorCallbackRegistered;
        private final ArrayList<Pair<OnColorsChangedListener, Handler>> mColorListeners = new ArrayList();
        private Bitmap mCachedWallpaper;
        private int mCachedWallpaperUserId;
        private Bitmap mDefaultWallpaper;
        private Handler mMainLooperHandler;

        Globals(Looper looper) {
            IBinder b = ServiceManager.getService("wallpaper");
            this.mService = IWallpaperManager.Stub.asInterface(b);
            this.mMainLooperHandler = new Handler(looper);
            this.forgetLoadedWallpaper();
        }

        @Override
        public void onWallpaperChanged() {
            this.forgetLoadedWallpaper();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOnColorsChangedListener(OnColorsChangedListener callback, Handler handler, int userId) {
            Globals globals = this;
            synchronized (globals) {
                if (!this.mColorCallbackRegistered) {
                    try {
                        this.mService.registerWallpaperColorsCallback(this, userId);
                        this.mColorCallbackRegistered = true;
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Can't register for color updates", e);
                    }
                }
                this.mColorListeners.add(new Pair<OnColorsChangedListener, Handler>(callback, handler));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeOnColorsChangedListener(OnColorsChangedListener callback, int userId) {
            Globals globals = this;
            synchronized (globals) {
                this.mColorListeners.removeIf(pair -> pair.first == callback);
                if (this.mColorListeners.size() == 0 && this.mColorCallbackRegistered) {
                    this.mColorCallbackRegistered = false;
                    try {
                        this.mService.unregisterWallpaperColorsCallback(this, userId);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Can't unregister color updates", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWallpaperColorsChanged(WallpaperColors colors, int which, int userId) {
            Globals globals = this;
            synchronized (globals) {
                for (Pair<OnColorsChangedListener, Handler> listener : this.mColorListeners) {
                    Handler handler = (Handler)listener.second;
                    if (listener.second == null) {
                        handler = this.mMainLooperHandler;
                    }
                    handler.post(() -> {
                        boolean stillExists;
                        Globals globals = sGlobals;
                        synchronized (globals) {
                            stillExists = this.mColorListeners.contains(listener);
                        }
                        if (stillExists) {
                            ((OnColorsChangedListener)pair.first).onColorsChanged(colors, which, userId);
                        }
                    });
                }
            }
        }

        WallpaperColors getWallpaperColors(int which, int userId) {
            if (which != 2 && which != 1) {
                throw new IllegalArgumentException("Must request colors for exactly one kind of wallpaper");
            }
            try {
                return this.mService.getWallpaperColors(which, userId);
            }
            catch (RemoteException remoteException) {
                return null;
            }
        }

        public Bitmap peekWallpaperBitmap(Context context, boolean returnDefault, int which) {
            return this.peekWallpaperBitmap(context, returnDefault, which, context.getUserId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Bitmap peekWallpaperBitmap(Context context, boolean returnDefault, int which, int userId) {
            if (this.mService != null) {
                try {
                    if (!this.mService.isWallpaperSupported(context.getOpPackageName())) {
                        return null;
                    }
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            Globals e = this;
            synchronized (e) {
                if (this.mCachedWallpaper != null && this.mCachedWallpaperUserId == userId) {
                    return this.mCachedWallpaper;
                }
                this.mCachedWallpaper = null;
                this.mCachedWallpaperUserId = 0;
                try {
                    this.mCachedWallpaper = this.getCurrentWallpaperLocked(context, userId);
                    this.mCachedWallpaperUserId = userId;
                }
                catch (OutOfMemoryError e2) {
                    Log.w(TAG, "Out of memory loading the current wallpaper: " + e2);
                }
                catch (SecurityException e3) {
                    if (context.getApplicationInfo().targetSdkVersion <= 26) {
                        Log.w(TAG, "No permission to access wallpaper, suppressing exception to avoid crashing legacy app.");
                    }
                    throw e3;
                }
                if (this.mCachedWallpaper != null) {
                    return this.mCachedWallpaper;
                }
            }
            if (returnDefault) {
                Bitmap defaultWallpaper = this.mDefaultWallpaper;
                if (defaultWallpaper == null) {
                    defaultWallpaper = this.getDefaultWallpaper(context, which);
                    Globals globals = this;
                    synchronized (globals) {
                        this.mDefaultWallpaper = defaultWallpaper;
                    }
                }
                return defaultWallpaper;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void forgetLoadedWallpaper() {
            Globals globals = this;
            synchronized (globals) {
                this.mCachedWallpaper = null;
                this.mCachedWallpaperUserId = 0;
                this.mDefaultWallpaper = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Bitmap getCurrentWallpaperLocked(Context context, int userId) {
            if (this.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                return null;
            }
            try {
                Bundle params = new Bundle();
                ParcelFileDescriptor fd = this.mService.getWallpaper(context.getOpPackageName(), this, 1, params, userId);
                if (fd == null) return null;
                try {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    Bitmap bitmap = BitmapFactory.decodeFileDescriptor(fd.getFileDescriptor(), null, options);
                    return bitmap;
                }
                catch (OutOfMemoryError e) {
                    Log.w(TAG, "Can't decode file", e);
                    return null;
                }
                finally {
                    IoUtils.closeQuietly(fd);
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Bitmap getDefaultWallpaper(Context context, int which) {
            InputStream is = WallpaperManager.openDefaultWallpaper(context, which);
            if (is != null) {
                try {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    Bitmap bitmap = BitmapFactory.decodeStream(is, null, options);
                    return bitmap;
                }
                catch (OutOfMemoryError e) {
                    Log.w(TAG, "Can't decode stream", e);
                }
                finally {
                    IoUtils.closeQuietly(is);
                }
            }
            return null;
        }
    }

    static class FastBitmapDrawable
    extends Drawable {
        private final Bitmap mBitmap;
        private final int mWidth;
        private final int mHeight;
        private int mDrawLeft;
        private int mDrawTop;
        private final Paint mPaint;

        private FastBitmapDrawable(Bitmap bitmap) {
            this.mBitmap = bitmap;
            this.mWidth = bitmap.getWidth();
            this.mHeight = bitmap.getHeight();
            this.setBounds(0, 0, this.mWidth, this.mHeight);
            this.mPaint = new Paint();
            this.mPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC));
        }

        @Override
        public void draw(Canvas canvas) {
            canvas.drawBitmap(this.mBitmap, this.mDrawLeft, this.mDrawTop, this.mPaint);
        }

        @Override
        public int getOpacity() {
            return -1;
        }

        @Override
        public void setBounds(int left, int top, int right, int bottom) {
            this.mDrawLeft = left + (right - left - this.mWidth) / 2;
            this.mDrawTop = top + (bottom - top - this.mHeight) / 2;
        }

        @Override
        public void setAlpha(int alpha) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public void setDither(boolean dither) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public void setFilterBitmap(boolean filter) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public int getIntrinsicWidth() {
            return this.mWidth;
        }

        @Override
        public int getIntrinsicHeight() {
            return this.mHeight;
        }

        @Override
        public int getMinimumWidth() {
            return this.mWidth;
        }

        @Override
        public int getMinimumHeight() {
            return this.mHeight;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetWallpaperFlags {
    }
}

