/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;

public final class GestureDescription {
    private static final int MAX_STROKE_COUNT = 10;
    private static final long MAX_GESTURE_DURATION_MS = 60000L;
    private final List<StrokeDescription> mStrokes = new ArrayList<StrokeDescription>();
    private final float[] mTempPos = new float[2];

    public static int getMaxStrokeCount() {
        return 10;
    }

    public static long getMaxGestureDuration() {
        return 60000L;
    }

    private GestureDescription() {
    }

    private GestureDescription(List<StrokeDescription> strokes) {
        this.mStrokes.addAll(strokes);
    }

    public int getStrokeCount() {
        return this.mStrokes.size();
    }

    public StrokeDescription getStroke(int index) {
        return this.mStrokes.get(index);
    }

    private long getNextKeyPointAtLeast(long offset) {
        long nextKeyPoint = Long.MAX_VALUE;
        for (int i = 0; i < this.mStrokes.size(); ++i) {
            long thisEndTime;
            long thisStartTime = this.mStrokes.get((int)i).mStartTime;
            if (thisStartTime < nextKeyPoint && thisStartTime >= offset) {
                nextKeyPoint = thisStartTime;
            }
            if ((thisEndTime = this.mStrokes.get((int)i).mEndTime) >= nextKeyPoint || thisEndTime < offset) continue;
            nextKeyPoint = thisEndTime;
        }
        return nextKeyPoint == Long.MAX_VALUE ? -1L : nextKeyPoint;
    }

    private int getPointsForTime(long time, TouchPoint[] touchPoints) {
        int numPointsFound = 0;
        for (int i = 0; i < this.mStrokes.size(); ++i) {
            StrokeDescription strokeDescription = this.mStrokes.get(i);
            if (!strokeDescription.hasPointForTime(time)) continue;
            touchPoints[numPointsFound].mStrokeId = strokeDescription.getId();
            touchPoints[numPointsFound].mContinuedStrokeId = strokeDescription.getContinuedStrokeId();
            touchPoints[numPointsFound].mIsStartOfPath = strokeDescription.getContinuedStrokeId() < 0 && time == strokeDescription.mStartTime;
            touchPoints[numPointsFound].mIsEndOfPath = !strokeDescription.willContinue() && time == strokeDescription.mEndTime;
            strokeDescription.getPosForTime(time, this.mTempPos);
            touchPoints[numPointsFound].mX = Math.round(this.mTempPos[0]);
            touchPoints[numPointsFound].mY = Math.round(this.mTempPos[1]);
            ++numPointsFound;
        }
        return numPointsFound;
    }

    private static long getTotalDuration(List<StrokeDescription> paths) {
        long latestEnd = Long.MIN_VALUE;
        for (int i = 0; i < paths.size(); ++i) {
            StrokeDescription path = paths.get(i);
            latestEnd = Math.max(latestEnd, path.mEndTime);
        }
        return Math.max(latestEnd, 0L);
    }

    public static class MotionEventGenerator {
        private static TouchPoint[] sCurrentTouchPoints;

        public static List<GestureStep> getGestureStepsFromGestureDescription(GestureDescription description, int sampleTimeMs) {
            ArrayList<GestureStep> gestureSteps = new ArrayList<GestureStep>();
            TouchPoint[] currentTouchPoints = MotionEventGenerator.getCurrentTouchPoints(description.getStrokeCount());
            int currentTouchPointSize = 0;
            long timeSinceGestureStart = 0L;
            long nextKeyPointTime = description.getNextKeyPointAtLeast(timeSinceGestureStart);
            while (nextKeyPointTime >= 0L) {
                timeSinceGestureStart = currentTouchPointSize == 0 ? nextKeyPointTime : Math.min(nextKeyPointTime, timeSinceGestureStart + (long)sampleTimeMs);
                currentTouchPointSize = description.getPointsForTime(timeSinceGestureStart, currentTouchPoints);
                gestureSteps.add(new GestureStep(timeSinceGestureStart, currentTouchPointSize, currentTouchPoints));
                nextKeyPointTime = description.getNextKeyPointAtLeast(timeSinceGestureStart + 1L);
            }
            return gestureSteps;
        }

        private static TouchPoint[] getCurrentTouchPoints(int requiredCapacity) {
            if (sCurrentTouchPoints == null || sCurrentTouchPoints.length < requiredCapacity) {
                sCurrentTouchPoints = new TouchPoint[requiredCapacity];
                for (int i = 0; i < requiredCapacity; ++i) {
                    MotionEventGenerator.sCurrentTouchPoints[i] = new TouchPoint();
                }
            }
            return sCurrentTouchPoints;
        }
    }

    public static class GestureStep
    implements Parcelable {
        public long timeSinceGestureStart;
        public int numTouchPoints;
        public TouchPoint[] touchPoints;
        public static final Parcelable.Creator<GestureStep> CREATOR = new Parcelable.Creator<GestureStep>(){

            @Override
            public GestureStep createFromParcel(Parcel in) {
                return new GestureStep(in);
            }

            public GestureStep[] newArray(int size) {
                return new GestureStep[size];
            }
        };

        public GestureStep(long timeSinceGestureStart, int numTouchPoints, TouchPoint[] touchPointsToCopy) {
            this.timeSinceGestureStart = timeSinceGestureStart;
            this.numTouchPoints = numTouchPoints;
            this.touchPoints = new TouchPoint[numTouchPoints];
            for (int i = 0; i < numTouchPoints; ++i) {
                this.touchPoints[i] = new TouchPoint(touchPointsToCopy[i]);
            }
        }

        public GestureStep(Parcel parcel) {
            this.timeSinceGestureStart = parcel.readLong();
            Parcelable[] parcelables = parcel.readParcelableArray(TouchPoint.class.getClassLoader());
            this.numTouchPoints = parcelables == null ? 0 : parcelables.length;
            this.touchPoints = new TouchPoint[this.numTouchPoints];
            for (int i = 0; i < this.numTouchPoints; ++i) {
                this.touchPoints[i] = (TouchPoint)parcelables[i];
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.timeSinceGestureStart);
            dest.writeParcelableArray(this.touchPoints, flags);
        }
    }

    public static class TouchPoint
    implements Parcelable {
        private static final int FLAG_IS_START_OF_PATH = 1;
        private static final int FLAG_IS_END_OF_PATH = 2;
        public int mStrokeId;
        public int mContinuedStrokeId;
        public boolean mIsStartOfPath;
        public boolean mIsEndOfPath;
        public float mX;
        public float mY;
        public static final Parcelable.Creator<TouchPoint> CREATOR = new Parcelable.Creator<TouchPoint>(){

            @Override
            public TouchPoint createFromParcel(Parcel in) {
                return new TouchPoint(in);
            }

            public TouchPoint[] newArray(int size) {
                return new TouchPoint[size];
            }
        };

        public TouchPoint() {
        }

        public TouchPoint(TouchPoint pointToCopy) {
            this.copyFrom(pointToCopy);
        }

        public TouchPoint(Parcel parcel) {
            this.mStrokeId = parcel.readInt();
            this.mContinuedStrokeId = parcel.readInt();
            int startEnd = parcel.readInt();
            this.mIsStartOfPath = (startEnd & 1) != 0;
            this.mIsEndOfPath = (startEnd & 2) != 0;
            this.mX = parcel.readFloat();
            this.mY = parcel.readFloat();
        }

        public void copyFrom(TouchPoint other) {
            this.mStrokeId = other.mStrokeId;
            this.mContinuedStrokeId = other.mContinuedStrokeId;
            this.mIsStartOfPath = other.mIsStartOfPath;
            this.mIsEndOfPath = other.mIsEndOfPath;
            this.mX = other.mX;
            this.mY = other.mY;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mStrokeId);
            dest.writeInt(this.mContinuedStrokeId);
            int startEnd = this.mIsStartOfPath ? 1 : 0;
            dest.writeInt(startEnd |= this.mIsEndOfPath ? 2 : 0);
            dest.writeFloat(this.mX);
            dest.writeFloat(this.mY);
        }
    }

    public static class StrokeDescription {
        private static final int INVALID_STROKE_ID = -1;
        static int sIdCounter;
        Path mPath;
        long mStartTime;
        long mEndTime;
        private float mTimeToLengthConversion;
        private PathMeasure mPathMeasure;
        float[] mTapLocation;
        int mId;
        boolean mContinued;
        int mContinuedStrokeId = -1;

        public StrokeDescription(Path path, long startTime, long duration) {
            this(path, startTime, duration, false);
        }

        public StrokeDescription(Path path, long startTime, long duration, boolean willContinue) {
            this.mContinued = willContinue;
            Preconditions.checkArgument(duration > 0L, "Duration must be positive");
            Preconditions.checkArgument(startTime >= 0L, "Start time must not be negative");
            Preconditions.checkArgument(!path.isEmpty(), "Path is empty");
            RectF bounds = new RectF();
            path.computeBounds(bounds, false);
            Preconditions.checkArgument(bounds.bottom >= 0.0f && bounds.top >= 0.0f && bounds.right >= 0.0f && bounds.left >= 0.0f, "Path bounds must not be negative");
            this.mPath = new Path(path);
            this.mPathMeasure = new PathMeasure(path, false);
            if (this.mPathMeasure.getLength() == 0.0f) {
                Path tempPath = new Path(path);
                tempPath.lineTo(-1.0f, -1.0f);
                this.mTapLocation = new float[2];
                PathMeasure pathMeasure = new PathMeasure(tempPath, false);
                pathMeasure.getPosTan(0.0f, this.mTapLocation, null);
            }
            if (this.mPathMeasure.nextContour()) {
                throw new IllegalArgumentException("Path has more than one contour");
            }
            this.mPathMeasure.setPath(this.mPath, false);
            this.mStartTime = startTime;
            this.mEndTime = startTime + duration;
            this.mTimeToLengthConversion = this.getLength() / (float)duration;
            this.mId = sIdCounter++;
        }

        public Path getPath() {
            return new Path(this.mPath);
        }

        public long getStartTime() {
            return this.mStartTime;
        }

        public long getDuration() {
            return this.mEndTime - this.mStartTime;
        }

        public int getId() {
            return this.mId;
        }

        public StrokeDescription continueStroke(Path path, long startTime, long duration, boolean willContinue) {
            if (!this.mContinued) {
                throw new IllegalStateException("Only strokes marked willContinue can be continued");
            }
            StrokeDescription strokeDescription = new StrokeDescription(path, startTime, duration, willContinue);
            strokeDescription.mContinuedStrokeId = this.mId;
            return strokeDescription;
        }

        public boolean willContinue() {
            return this.mContinued;
        }

        public int getContinuedStrokeId() {
            return this.mContinuedStrokeId;
        }

        float getLength() {
            return this.mPathMeasure.getLength();
        }

        boolean getPosForTime(long time, float[] pos) {
            if (this.mTapLocation != null) {
                pos[0] = this.mTapLocation[0];
                pos[1] = this.mTapLocation[1];
                return true;
            }
            if (time == this.mEndTime) {
                return this.mPathMeasure.getPosTan(this.getLength(), pos, null);
            }
            float length = this.mTimeToLengthConversion * (float)(time - this.mStartTime);
            return this.mPathMeasure.getPosTan(length, pos, null);
        }

        boolean hasPointForTime(long time) {
            return time >= this.mStartTime && time <= this.mEndTime;
        }
    }

    public static class Builder {
        private final List<StrokeDescription> mStrokes = new ArrayList<StrokeDescription>();

        public Builder addStroke(StrokeDescription strokeDescription) {
            if (this.mStrokes.size() >= 10) {
                throw new IllegalStateException("Attempting to add too many strokes to a gesture");
            }
            this.mStrokes.add(strokeDescription);
            if (GestureDescription.getTotalDuration(this.mStrokes) > 60000L) {
                this.mStrokes.remove(strokeDescription);
                throw new IllegalStateException("Gesture would exceed maximum duration with new stroke");
            }
            return this;
        }

        public GestureDescription build() {
            if (this.mStrokes.size() == 0) {
                throw new IllegalStateException("Gestures must have at least one stroke");
            }
            return new GestureDescription(this.mStrokes);
        }
    }
}

