/*
 * Decompiled with CFR 0.152.
 */
package libcore.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import libcore.reflect.GenericArrayTypeImpl;
import libcore.reflect.ListOfTypes;
import libcore.reflect.ListOfVariables;
import libcore.reflect.ParameterizedTypeImpl;
import libcore.reflect.TypeVariableImpl;
import libcore.reflect.WildcardTypeImpl;
import libcore.util.EmptyArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericSignatureParser {
    public ListOfTypes exceptionTypes;
    public ListOfTypes parameterTypes;
    public TypeVariable[] formalTypeParameters;
    public Type returnType;
    public Type fieldType;
    public ListOfTypes interfaceTypes;
    public Type superclassType;
    public ClassLoader loader;
    GenericDeclaration genericDecl;
    char symbol;
    String identifier;
    private boolean eof;
    char[] buffer;
    int pos;

    public GenericSignatureParser(ClassLoader loader) {
        this.loader = loader;
    }

    void setInput(GenericDeclaration genericDecl, String input) {
        if (input != null) {
            this.genericDecl = genericDecl;
            this.buffer = input.toCharArray();
            this.eof = false;
            this.scanSymbol();
        } else {
            this.eof = true;
        }
    }

    public void parseForClass(GenericDeclaration genericDecl, String signature) {
        this.setInput(genericDecl, signature);
        if (!this.eof) {
            this.parseClassSignature();
        } else if (genericDecl instanceof Class) {
            Class c = (Class)genericDecl;
            this.formalTypeParameters = EmptyArray.TYPE_VARIABLE;
            this.superclassType = c.getSuperclass();
            Type[] interfaces = c.getInterfaces();
            this.interfaceTypes = interfaces.length == 0 ? ListOfTypes.EMPTY : new ListOfTypes(interfaces);
        } else {
            this.formalTypeParameters = EmptyArray.TYPE_VARIABLE;
            this.superclassType = Object.class;
            this.interfaceTypes = ListOfTypes.EMPTY;
        }
    }

    public void parseForMethod(GenericDeclaration genericDecl, String signature, Class<?>[] rawExceptionTypes) {
        this.setInput(genericDecl, signature);
        if (!this.eof) {
            this.parseMethodTypeSignature(rawExceptionTypes);
        } else {
            Method m = (Method)genericDecl;
            this.formalTypeParameters = EmptyArray.TYPE_VARIABLE;
            Type[] parameterTypes = m.getParameterTypes();
            this.parameterTypes = parameterTypes.length == 0 ? ListOfTypes.EMPTY : new ListOfTypes(parameterTypes);
            Type[] exceptionTypes = m.getExceptionTypes();
            this.exceptionTypes = exceptionTypes.length == 0 ? ListOfTypes.EMPTY : new ListOfTypes(exceptionTypes);
            this.returnType = m.getReturnType();
        }
    }

    public void parseForConstructor(GenericDeclaration genericDecl, String signature, Class<?>[] rawExceptionTypes) {
        this.setInput(genericDecl, signature);
        if (!this.eof) {
            this.parseMethodTypeSignature(rawExceptionTypes);
        } else {
            Constructor c = (Constructor)genericDecl;
            this.formalTypeParameters = EmptyArray.TYPE_VARIABLE;
            Type[] parameterTypes = c.getParameterTypes();
            this.parameterTypes = parameterTypes.length == 0 ? ListOfTypes.EMPTY : new ListOfTypes(parameterTypes);
            Type[] exceptionTypes = c.getExceptionTypes();
            this.exceptionTypes = exceptionTypes.length == 0 ? ListOfTypes.EMPTY : new ListOfTypes(exceptionTypes);
        }
    }

    public void parseForField(GenericDeclaration genericDecl, String signature) {
        this.setInput(genericDecl, signature);
        if (!this.eof) {
            this.fieldType = this.parseFieldTypeSignature();
        }
    }

    void parseClassSignature() {
        this.parseOptFormalTypeParameters();
        this.superclassType = this.parseClassTypeSignature();
        this.interfaceTypes = new ListOfTypes(16);
        while (this.symbol > '\u0000') {
            this.interfaceTypes.add(this.parseClassTypeSignature());
        }
    }

    void parseOptFormalTypeParameters() {
        ListOfVariables typeParams = new ListOfVariables();
        if (this.symbol == '<') {
            this.scanSymbol();
            typeParams.add(this.parseFormalTypeParameter());
            while (this.symbol != '>' && this.symbol > '\u0000') {
                typeParams.add(this.parseFormalTypeParameter());
            }
            this.expect('>');
        }
        this.formalTypeParameters = typeParams.getArray();
    }

    TypeVariableImpl<GenericDeclaration> parseFormalTypeParameter() {
        this.scanIdentifier();
        String name = this.identifier.intern();
        ListOfTypes bounds = new ListOfTypes(8);
        this.expect(':');
        if (this.symbol == 'L' || this.symbol == '[' || this.symbol == 'T') {
            bounds.add(this.parseFieldTypeSignature());
        }
        while (this.symbol == ':') {
            this.scanSymbol();
            bounds.add(this.parseFieldTypeSignature());
        }
        return new TypeVariableImpl<GenericDeclaration>(this.genericDecl, name, bounds);
    }

    Type parseFieldTypeSignature() {
        switch (this.symbol) {
            case 'L': {
                return this.parseClassTypeSignature();
            }
            case '[': {
                this.scanSymbol();
                return new GenericArrayTypeImpl(this.parseTypeSignature());
            }
            case 'T': {
                return this.parseTypeVariableSignature();
            }
        }
        throw new GenericSignatureFormatError();
    }

    Type parseClassTypeSignature() {
        ParameterizedTypeImpl parentType;
        this.expect('L');
        StringBuilder qualIdent = new StringBuilder();
        this.scanIdentifier();
        while (this.symbol == '/') {
            this.scanSymbol();
            qualIdent.append(this.identifier).append(".");
            this.scanIdentifier();
        }
        qualIdent.append(this.identifier);
        ListOfTypes typeArgs = this.parseOptTypeArguments();
        ParameterizedTypeImpl type = parentType = new ParameterizedTypeImpl(null, qualIdent.toString(), typeArgs, this.loader);
        while (this.symbol == '.') {
            this.scanSymbol();
            this.scanIdentifier();
            qualIdent.append("$").append(this.identifier);
            typeArgs = this.parseOptTypeArguments();
            type = new ParameterizedTypeImpl(parentType, qualIdent.toString(), typeArgs, this.loader);
        }
        this.expect(';');
        return type;
    }

    ListOfTypes parseOptTypeArguments() {
        ListOfTypes typeArgs = new ListOfTypes(8);
        if (this.symbol == '<') {
            this.scanSymbol();
            typeArgs.add(this.parseTypeArgument());
            while (this.symbol != '>' && this.symbol > '\u0000') {
                typeArgs.add(this.parseTypeArgument());
            }
            this.expect('>');
        }
        return typeArgs;
    }

    Type parseTypeArgument() {
        ListOfTypes extendsBound = new ListOfTypes(1);
        ListOfTypes superBound = new ListOfTypes(1);
        if (this.symbol == '*') {
            this.scanSymbol();
            extendsBound.add((Type)((Object)Object.class));
            return new WildcardTypeImpl(extendsBound, superBound);
        }
        if (this.symbol == '+') {
            this.scanSymbol();
            extendsBound.add(this.parseFieldTypeSignature());
            return new WildcardTypeImpl(extendsBound, superBound);
        }
        if (this.symbol == '-') {
            this.scanSymbol();
            superBound.add(this.parseFieldTypeSignature());
            extendsBound.add((Type)((Object)Object.class));
            return new WildcardTypeImpl(extendsBound, superBound);
        }
        return this.parseFieldTypeSignature();
    }

    TypeVariableImpl<GenericDeclaration> parseTypeVariableSignature() {
        this.expect('T');
        this.scanIdentifier();
        this.expect(';');
        return new TypeVariableImpl<GenericDeclaration>(this.genericDecl, this.identifier);
    }

    Type parseTypeSignature() {
        switch (this.symbol) {
            case 'B': {
                this.scanSymbol();
                return Byte.TYPE;
            }
            case 'C': {
                this.scanSymbol();
                return Character.TYPE;
            }
            case 'D': {
                this.scanSymbol();
                return Double.TYPE;
            }
            case 'F': {
                this.scanSymbol();
                return Float.TYPE;
            }
            case 'I': {
                this.scanSymbol();
                return Integer.TYPE;
            }
            case 'J': {
                this.scanSymbol();
                return Long.TYPE;
            }
            case 'S': {
                this.scanSymbol();
                return Short.TYPE;
            }
            case 'Z': {
                this.scanSymbol();
                return Boolean.TYPE;
            }
        }
        return this.parseFieldTypeSignature();
    }

    void parseMethodTypeSignature(Class<?>[] rawExceptionTypes) {
        this.parseOptFormalTypeParameters();
        this.parameterTypes = new ListOfTypes(16);
        this.expect('(');
        while (this.symbol != ')' && this.symbol > '\u0000') {
            this.parameterTypes.add(this.parseTypeSignature());
        }
        this.expect(')');
        this.returnType = this.parseReturnType();
        if (this.symbol == '^') {
            this.exceptionTypes = new ListOfTypes(8);
            do {
                this.scanSymbol();
                if (this.symbol == 'T') {
                    this.exceptionTypes.add(this.parseTypeVariableSignature());
                    continue;
                }
                this.exceptionTypes.add(this.parseClassTypeSignature());
            } while (this.symbol == '^');
        } else {
            this.exceptionTypes = rawExceptionTypes != null ? new ListOfTypes(rawExceptionTypes) : new ListOfTypes(0);
        }
    }

    Type parseReturnType() {
        if (this.symbol != 'V') {
            return this.parseTypeSignature();
        }
        this.scanSymbol();
        return Void.TYPE;
    }

    void scanSymbol() {
        if (!this.eof) {
            if (this.pos < this.buffer.length) {
                this.symbol = this.buffer[this.pos];
                ++this.pos;
            } else {
                this.symbol = '\u0000';
                this.eof = true;
            }
        } else {
            throw new GenericSignatureFormatError();
        }
    }

    void expect(char c) {
        if (this.symbol != c) {
            throw new GenericSignatureFormatError();
        }
        this.scanSymbol();
    }

    static boolean isStopSymbol(char ch) {
        switch (ch) {
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void scanIdentifier() {
        if (this.eof) throw new GenericSignatureFormatError();
        StringBuilder identBuf = new StringBuilder(32);
        if (!GenericSignatureParser.isStopSymbol(this.symbol)) {
            identBuf.append(this.symbol);
            do {
                char ch;
                if ((ch = this.buffer[this.pos]) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || !GenericSignatureParser.isStopSymbol(ch)) {
                    identBuf.append(ch);
                    ++this.pos;
                    continue;
                }
                this.identifier = identBuf.toString();
                this.scanSymbol();
                return;
            } while (this.pos != this.buffer.length);
        } else {
            this.symbol = '\u0000';
            this.eof = true;
            throw new GenericSignatureFormatError();
        }
        this.identifier = identBuf.toString();
        this.symbol = '\u0000';
        this.eof = true;
    }
}

