/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.xpath.XPathFactory;
import libcore.io.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class XPathFactoryFinder {
    private static boolean debug = false;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static Properties cacheProps;
    private static boolean firstTime;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;

    private static void debugPrintln(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    public XPathFactoryFinder(ClassLoader loader) {
        this.classLoader = loader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        if (this.classLoader == Thread.currentThread().getContextClassLoader()) {
            XPathFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
            return;
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            XPathFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        XPathFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public XPathFactory newFactory(String uri) {
        if (uri == null) {
            throw new NullPointerException("uri == null");
        }
        XPathFactory f = this._newFactory(uri);
        if (debug) {
            if (f != null) {
                XPathFactoryFinder.debugPrintln("factory '" + f.getClass().getName() + "' was found for " + uri);
            } else {
                XPathFactoryFinder.debugPrintln("unable to find a factory for " + uri);
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPathFactory _newFactory(String uri) {
        XPathFactory xpf;
        block26: {
            String propertyName = SERVICE_CLASS.getName() + ":" + uri;
            try {
                String r;
                if (debug) {
                    XPathFactoryFinder.debugPrintln("Looking up system property '" + propertyName + "'");
                }
                if ((r = System.getProperty(propertyName)) != null && r.length() > 0) {
                    if (debug) {
                        XPathFactoryFinder.debugPrintln("The value is '" + r + "'");
                    }
                    if ((xpf = this.createInstance(r)) != null) {
                        return xpf;
                    }
                } else if (debug) {
                    XPathFactoryFinder.debugPrintln("The property is undefined.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String javah = System.getProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
            String factoryClassName = null;
            try {
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            File f = new File(configFile);
                            firstTime = false;
                            if (f.exists()) {
                                if (debug) {
                                    XPathFactoryFinder.debugPrintln("Read properties file " + f);
                                }
                                cacheProps.load(new FileInputStream(f));
                            }
                        }
                    }
                }
                factoryClassName = cacheProps.getProperty(propertyName);
                if (debug) {
                    XPathFactoryFinder.debugPrintln("found " + factoryClassName + " in $java.home/jaxp.properties");
                }
                if (factoryClassName != null && (xpf = this.createInstance(factoryClassName)) != null) {
                    return xpf;
                }
            }
            catch (Exception ex) {
                if (!debug) break block26;
                ex.printStackTrace();
            }
        }
        for (URL resource : this.createServiceFileIterator()) {
            if (debug) {
                XPathFactoryFinder.debugPrintln("looking into " + resource);
            }
            try {
                xpf = this.loadFromServicesFile(uri, resource.toExternalForm(), resource.openStream());
                if (xpf == null) continue;
                return xpf;
            }
            catch (IOException e) {
                if (!debug) continue;
                XPathFactoryFinder.debugPrintln("failed to read " + resource);
                e.printStackTrace();
            }
        }
        if (uri.equals("http://java.sun.com/jaxp/xpath/dom")) {
            if (debug) {
                XPathFactoryFinder.debugPrintln("attempting to use the platform default W3C DOM XPath lib");
            }
            return this.createInstance("org.apache.xpath.jaxp.XPathFactoryImpl");
        }
        if (debug) {
            XPathFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        }
        return null;
    }

    XPathFactory createInstance(String className) {
        block8: {
            try {
                Object o;
                if (debug) {
                    XPathFactoryFinder.debugPrintln("instantiating " + className);
                }
                Class<?> clazz = this.classLoader != null ? this.classLoader.loadClass(className) : Class.forName(className);
                if (debug) {
                    XPathFactoryFinder.debugPrintln("loaded it from " + XPathFactoryFinder.which(clazz));
                }
                if ((o = clazz.newInstance()) instanceof XPathFactory) {
                    return (XPathFactory)o;
                }
                if (debug) {
                    XPathFactoryFinder.debugPrintln(className + " is not assignable to " + SERVICE_CLASS.getName());
                }
            }
            catch (VirtualMachineError vme) {
                throw vme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (!debug) break block8;
                XPathFactoryFinder.debugPrintln("failed to instantiate " + className);
                t.printStackTrace();
            }
        }
        return null;
    }

    private XPathFactory loadFromServicesFile(String uri, String resourceName, InputStream in) {
        BufferedReader rd;
        if (debug) {
            XPathFactoryFinder.debugPrintln("Reading " + resourceName);
        }
        try {
            rd = new BufferedReader(new InputStreamReader(in, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(in), 80);
        }
        XPathFactory resultFactory = null;
        while (true) {
            String factoryClassName;
            try {
                factoryClassName = rd.readLine();
            }
            catch (IOException x) {
                break;
            }
            if (factoryClassName == null) break;
            int hashIndex = factoryClassName.indexOf(35);
            if (hashIndex != -1) {
                factoryClassName = factoryClassName.substring(0, hashIndex);
            }
            if ((factoryClassName = factoryClassName.trim()).length() == 0) continue;
            try {
                XPathFactory foundFactory = this.createInstance(factoryClassName);
                if (!foundFactory.isObjectModelSupported(uri)) continue;
                resultFactory = foundFactory;
            }
            catch (Exception ignored) {
                continue;
            }
            break;
        }
        IoUtils.closeQuietly(rd);
        return resultFactory;
    }

    private Iterable<URL> createServiceFileIterator() {
        if (this.classLoader == null) {
            URL resource = XPathFactoryFinder.class.getClassLoader().getResource(SERVICE_ID);
            return Collections.singleton(resource);
        }
        try {
            Enumeration<URL> e = this.classLoader.getResources(SERVICE_ID);
            if (debug && !e.hasMoreElements()) {
                XPathFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return Collections.list(e);
        }
        catch (IOException e) {
            if (debug) {
                XPathFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
                e.printStackTrace();
            }
            return Collections.emptySet();
        }
    }

    private static String which(Class clazz) {
        return XPathFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String classname, ClassLoader loader) {
        URL it;
        String classnameAsResource = classname.replace('.', '/') + ".class";
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return (it = loader.getResource(classnameAsResource)) != null ? it.toString() : null;
    }

    static {
        String val = System.getProperty("jaxp.debug");
        debug = val != null && !"false".equals(val);
        cacheProps = new Properties();
        firstTime = true;
        SERVICE_CLASS = XPathFactory.class;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }
}

