/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.util.Arrays;
import java.util.zip.DataFormatException;

public class Inflater {
    private int inLength;
    private int inRead;
    private boolean finished;
    private boolean needsDictionary;
    private long streamHandle = -1L;
    private final CloseGuard guard = CloseGuard.get();

    public Inflater() {
        this(false);
    }

    public Inflater(boolean noHeader) {
        this.streamHandle = this.createStream(noHeader);
        this.guard.open("end");
    }

    private native long createStream(boolean var1);

    public synchronized void end() {
        this.guard.close();
        if (this.streamHandle != -1L) {
            this.endImpl(this.streamHandle);
            this.inRead = 0;
            this.inLength = 0;
            this.streamHandle = -1L;
        }
    }

    private native void endImpl(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.end();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                super.finalize();
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
            throw throwable;
        }
        try {
            super.finalize();
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public synchronized int getAdler() {
        this.checkOpen();
        return this.getAdlerImpl(this.streamHandle);
    }

    private native int getAdlerImpl(long var1);

    public synchronized long getBytesRead() {
        this.checkOpen();
        return this.getTotalInImpl(this.streamHandle);
    }

    public synchronized long getBytesWritten() {
        this.checkOpen();
        return this.getTotalOutImpl(this.streamHandle);
    }

    public synchronized int getRemaining() {
        return this.inLength - this.inRead;
    }

    public synchronized int getTotalIn() {
        this.checkOpen();
        return (int)Math.min(this.getTotalInImpl(this.streamHandle), Integer.MAX_VALUE);
    }

    private native long getTotalInImpl(long var1);

    public synchronized int getTotalOut() {
        this.checkOpen();
        return (int)Math.min(this.getTotalOutImpl(this.streamHandle), Integer.MAX_VALUE);
    }

    private native long getTotalOutImpl(long var1);

    public int inflate(byte[] buf) throws DataFormatException {
        return this.inflate(buf, 0, buf.length);
    }

    public synchronized int inflate(byte[] buf, int offset, int byteCount) throws DataFormatException {
        Arrays.checkOffsetAndCount(buf.length, offset, byteCount);
        this.checkOpen();
        if (this.needsInput()) {
            return 0;
        }
        boolean neededDict = this.needsDictionary;
        this.needsDictionary = false;
        int result = this.inflateImpl(buf, offset, byteCount, this.streamHandle);
        if (this.needsDictionary && neededDict) {
            throw new DataFormatException("Needs dictionary");
        }
        return result;
    }

    private native int inflateImpl(byte[] var1, int var2, int var3, long var4);

    public synchronized boolean needsDictionary() {
        return this.needsDictionary;
    }

    public synchronized boolean needsInput() {
        return this.inRead == this.inLength;
    }

    public synchronized void reset() {
        this.checkOpen();
        this.finished = false;
        this.needsDictionary = false;
        this.inRead = 0;
        this.inLength = 0;
        this.resetImpl(this.streamHandle);
    }

    private native void resetImpl(long var1);

    public synchronized void setDictionary(byte[] dictionary) {
        this.setDictionary(dictionary, 0, dictionary.length);
    }

    public synchronized void setDictionary(byte[] dictionary, int offset, int byteCount) {
        this.checkOpen();
        Arrays.checkOffsetAndCount(dictionary.length, offset, byteCount);
        this.setDictionaryImpl(dictionary, offset, byteCount, this.streamHandle);
    }

    private native void setDictionaryImpl(byte[] var1, int var2, int var3, long var4);

    public synchronized void setInput(byte[] buf) {
        this.setInput(buf, 0, buf.length);
    }

    public synchronized void setInput(byte[] buf, int offset, int byteCount) {
        this.checkOpen();
        Arrays.checkOffsetAndCount(buf.length, offset, byteCount);
        this.inRead = 0;
        this.inLength = byteCount;
        this.setInputImpl(buf, offset, byteCount, this.streamHandle);
    }

    private native void setInputImpl(byte[] var1, int var2, int var3, long var4);

    synchronized int setFileInput(FileDescriptor fd, long offset, int byteCount) {
        this.checkOpen();
        this.inRead = 0;
        this.inLength = this.setFileInputImpl(fd, offset, byteCount, this.streamHandle);
        return this.inLength;
    }

    private native int setFileInputImpl(FileDescriptor var1, long var2, int var4, long var5);

    private void checkOpen() {
        if (this.streamHandle == -1L) {
            throw new IllegalStateException("attempt to use Inflater after calling end");
        }
    }
}

