/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.XMLParser;

class FilePreferencesImpl
extends AbstractPreferences {
    private static final String PREFS_FILE_NAME = "prefs.xml";
    private static String USER_HOME = System.getProperty("user.home") + "/.java/.userPrefs";
    private static String SYSTEM_HOME = System.getProperty("java.home") + "/.systemPrefs";
    private String path;
    private Properties prefs;
    private File prefsFile;
    private File dir;
    private Set<String> removed = new HashSet<String>();
    private Set<String> updated = new HashSet<String>();

    FilePreferencesImpl(boolean userNode) {
        super(null, "");
        this.userNode = userNode;
        this.path = userNode ? USER_HOME : SYSTEM_HOME;
        this.initPrefs();
    }

    private FilePreferencesImpl(AbstractPreferences parent, String name) {
        super(parent, name);
        this.path = ((FilePreferencesImpl)parent).path + File.separator + name;
        this.initPrefs();
    }

    private void initPrefs() {
        this.dir = new File(this.path);
        this.newNode = !this.dir.exists();
        this.prefsFile = new File(this.path + File.separator + PREFS_FILE_NAME);
        this.prefs = XMLParser.readXmlPreferences(this.prefsFile);
    }

    protected String[] childrenNamesSpi() throws BackingStoreException {
        String[] names = this.dir.list(new FilenameFilter(){

            public boolean accept(File parent, String name) {
                return new File(FilePreferencesImpl.this.path + File.separator + name).isDirectory();
            }
        });
        if (names == null) {
            throw new BackingStoreException("Cannot get child names for " + this.toString() + " (path is " + this.path + ")");
        }
        return names;
    }

    protected AbstractPreferences childSpi(String name) {
        FilePreferencesImpl child = new FilePreferencesImpl(this, name);
        return child;
    }

    protected void flushSpi() throws BackingStoreException {
        try {
            if (this.isRemoved()) {
                return;
            }
            Properties currentPrefs = XMLParser.readXmlPreferences(this.prefsFile);
            Iterator<String> it = this.removed.iterator();
            while (it.hasNext()) {
                currentPrefs.remove(it.next());
            }
            this.removed.clear();
            for (String key : this.updated) {
                currentPrefs.put(key, this.prefs.get(key));
            }
            this.updated.clear();
            this.prefs = currentPrefs;
            XMLParser.writeXmlPreferences(this.prefsFile, this.prefs);
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
    }

    protected String getSpi(String key) {
        try {
            if (this.prefs == null) {
                this.prefs = XMLParser.readXmlPreferences(this.prefsFile);
            }
            return this.prefs.getProperty(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String[] keysSpi() throws BackingStoreException {
        Set ks = this.prefs.keySet();
        return ks.toArray(new String[ks.size()]);
    }

    protected void putSpi(String name, String value) {
        this.prefs.setProperty(name, value);
        this.updated.add(name);
    }

    protected void removeNodeSpi() throws BackingStoreException {
        this.prefsFile.delete();
        boolean removeSucceed = this.dir.delete();
        if (!removeSucceed) {
            throw new BackingStoreException("Cannot remove " + this.toString());
        }
    }

    protected void removeSpi(String key) {
        this.prefs.remove(key);
        this.updated.remove(key);
        this.removed.add(key);
    }

    protected void syncSpi() throws BackingStoreException {
        this.flushSpi();
    }
}

