/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManifestReader {
    private final HashMap<String, Attributes.Name> attributeNameCache = new HashMap();
    private final UnsafeByteSequence valueBuffer = new UnsafeByteSequence(80);
    private final byte[] buf;
    private final int endOfMainSection;
    private int pos;
    private Attributes.Name name;
    private String value;
    private int consecutiveLineBreaks = 0;

    public ManifestReader(byte[] buf, Attributes main) throws IOException {
        this.buf = buf;
        while (this.readHeader()) {
            main.put(this.name, this.value);
        }
        this.endOfMainSection = this.pos;
    }

    public void readEntries(Map<String, Attributes> entries, Map<String, Manifest.Chunk> chunks) throws IOException {
        int mark = this.pos;
        while (this.readHeader()) {
            if (!Attributes.Name.NAME.equals(this.name)) {
                throw new IOException("Entry is not named");
            }
            String entryNameValue = this.value;
            Attributes entry = entries.get(entryNameValue);
            if (entry == null) {
                entry = new Attributes(12);
            }
            while (this.readHeader()) {
                entry.put(this.name, this.value);
            }
            if (chunks != null) {
                if (chunks.get(entryNameValue) != null) {
                    throw new IOException("A jar verifier does not support more than one entry with the same name");
                }
                chunks.put(entryNameValue, new Manifest.Chunk(mark, this.pos));
                mark = this.pos;
            }
            entries.put(entryNameValue, entry);
        }
    }

    public int getEndOfMainSection() {
        return this.endOfMainSection;
    }

    private boolean readHeader() throws IOException {
        if (this.consecutiveLineBreaks > 1) {
            this.consecutiveLineBreaks = 0;
            return false;
        }
        this.readName();
        this.consecutiveLineBreaks = 0;
        this.readValue();
        return this.consecutiveLineBreaks > 0;
    }

    private void readName() throws IOException {
        int mark = this.pos;
        while (this.pos < this.buf.length) {
            if (this.buf[this.pos++] != 58) continue;
            String nameString = new String(this.buf, mark, this.pos - mark - 1, StandardCharsets.US_ASCII);
            if (this.buf[this.pos++] != 32) {
                throw new IOException(String.format("Invalid value for attribute '%s'", nameString));
            }
            try {
                this.name = this.attributeNameCache.get(nameString);
                if (this.name == null) {
                    this.name = new Attributes.Name(nameString);
                    this.attributeNameCache.put(nameString, this.name);
                }
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage());
            }
            return;
        }
    }

    private void readValue() throws IOException {
        boolean lastCr = false;
        int mark = this.pos;
        int last = this.pos;
        this.valueBuffer.rewind();
        block6: while (this.pos < this.buf.length) {
            byte next = this.buf[this.pos++];
            switch (next) {
                case 0: {
                    throw new IOException("NUL character in a manifest");
                }
                case 10: {
                    if (lastCr) {
                        lastCr = false;
                        continue block6;
                    }
                    ++this.consecutiveLineBreaks;
                    continue block6;
                }
                case 13: {
                    lastCr = true;
                    ++this.consecutiveLineBreaks;
                    continue block6;
                }
                case 32: {
                    if (this.consecutiveLineBreaks != 1) break;
                    this.valueBuffer.write(this.buf, mark, last - mark);
                    mark = this.pos;
                    this.consecutiveLineBreaks = 0;
                    continue block6;
                }
            }
            if (this.consecutiveLineBreaks >= 1) {
                --this.pos;
                break;
            }
            last = this.pos;
        }
        this.valueBuffer.write(this.buf, mark, last - mark);
        this.value = this.valueBuffer.toString(StandardCharsets.UTF_8);
    }
}

