/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayQueue<E extends Delayed>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final transient ReentrantLock lock = new ReentrantLock();
    private final PriorityQueue<E> q = new PriorityQueue();
    private Thread leader = null;
    private final Condition available = this.lock.newCondition();

    public DelayQueue() {
    }

    public DelayQueue(Collection<? extends E> c) {
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.offer(e);
            if (this.q.peek() == e) {
                this.leader = null;
                this.available.signal();
            }
            boolean bl = true;
            Object var5_4 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock lock;
        block3: {
            E e;
            lock = this.lock;
            lock.lock();
            try {
                Delayed first = (Delayed)this.q.peek();
                if (first != null && first.getDelay(TimeUnit.NANOSECONDS) <= 0L) break block3;
                e = null;
                Object var5_5 = null;
                lock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                lock.unlock();
                throw throwable;
            }
            return e;
        }
        Delayed delayed = (Delayed)this.q.poll();
        Object var5_6 = null;
        lock.unlock();
        return (E)delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        while (true) {
            try {
                Object var7_5;
                Thread thisThread;
                long delay;
                while (true) {
                    Delayed first;
                    if ((first = (Delayed)this.q.peek()) == null) {
                        this.available.await();
                        continue;
                    }
                    delay = first.getDelay(TimeUnit.NANOSECONDS);
                    if (delay <= 0L) {
                        Delayed delayed = (Delayed)this.q.poll();
                        Object var9_6 = null;
                        if (this.leader == null && this.q.peek() != null) {
                            this.available.signal();
                        }
                        lock.unlock();
                        return (E)delayed;
                    }
                    first = null;
                    if (this.leader == null) break;
                    this.available.await();
                }
                this.leader = thisThread = Thread.currentThread();
                try {
                    this.available.awaitNanos(delay);
                    var7_5 = null;
                    if (this.leader != thisThread) continue;
                    this.leader = null;
                }
                catch (Throwable throwable) {
                    var7_5 = null;
                    if (this.leader == thisThread) {
                        this.leader = null;
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (this.leader == null && this.q.peek() != null) {
                    this.available.signal();
                }
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        nanos = unit.toNanos(timeout);
        lock = this.lock;
        lock.lockInterruptibly();
        while (true) lbl-1000:
        // 5 sources

        {
            first = (Delayed)this.q.peek();
            if (first != null) ** GOTO lbl28
            if (nanos > 0L) break block14;
            var8_7 = null;
            var16_11 = null;
            if (this.leader == null && this.q.peek() != null) {
                this.available.signal();
            }
            lock.unlock();
            break;
        }
        catch (Throwable var15_16) {
            var16_14 = null;
            if (this.leader == null && this.q.peek() != null) {
                this.available.signal();
            }
            lock.unlock();
            throw var15_16;
        }
        {
            block16: {
                block15: {
                    block14: {
                        return var8_7;
                    }
                    nanos = this.available.awaitNanos(nanos);
                    continue;
lbl28:
                    // 1 sources

                    delay = first.getDelay(TimeUnit.NANOSECONDS);
                    if (delay > 0L) break block15;
                    var10_8 = (Delayed)this.q.poll();
                    var16_12 = null;
                    if (this.leader == null && this.q.peek() != null) {
                        this.available.signal();
                    }
                    lock.unlock();
                    return (E)var10_8;
                }
                if (nanos > 0L) break block16;
                var10_8 = null;
                var16_13 = null;
                if (this.leader == null && this.q.peek() != null) {
                    this.available.signal();
                }
                lock.unlock();
                return (E)var10_8;
            }
            first = null;
            if (nanos < delay || this.leader != null) {
                nanos = this.available.awaitNanos(nanos);
                continue;
            }
            this.leader = thisThread = Thread.currentThread();
            try {
                timeLeft = this.available.awaitNanos(delay);
                nanos -= delay - timeLeft;
                var14_10 = null;
                if (this.leader != thisThread) continue;
                this.leader = null;
                continue;
            }
            catch (Throwable var13_15) {
                var14_10 = null;
                if (this.leader == thisThread) {
                    this.leader = null;
                }
                throw var13_15;
            }
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Delayed delayed;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            delayed = (Delayed)this.q.peek();
            Object var4_3 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
        return (E)delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.q.size();
            Object var4_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private E peekExpired() {
        Delayed first = (Delayed)this.q.peek();
        return (E)(first == null || first.getDelay(TimeUnit.NANOSECONDS) > 0L ? null : first);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e;
            int n = 0;
            while ((e = this.peekExpired()) != null) {
                c.add(e);
                this.q.poll();
                ++n;
            }
            int n2 = n;
            Object var6_6 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e;
            int n;
            for (n = 0; n < maxElements && (e = this.peekExpired()) != null; ++n) {
                c.add(e);
                this.q.poll();
            }
            int n2 = n;
            Object var7_7 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.clear();
            Object var3_2 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            Object var4_3 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            T[] TArray = this.q.toArray(a);
            Object var5_4 = null;
            lock.unlock();
            return TArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.q.remove(o);
            Object var5_4 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEQ(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Iterator<E> it = this.q.iterator();
            while (it.hasNext()) {
                if (o != it.next()) continue;
                it.remove();
                break;
            }
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.toArray());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] array2) {
            this.array = array2;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public E next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return (Delayed)this.array[this.cursor++];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            DelayQueue.this.removeEQ(this.array[this.lastRet]);
            this.lastRet = -1;
        }
    }
}

