/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.AbstractList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsafeArrayList<T>
extends AbstractList<T> {
    private final Class<T> elementType;
    private T[] array;
    private int size;

    public UnsafeArrayList(Class<T> elementType, int initialCapacity) {
        this.array = (Object[])Array.newInstance(elementType, initialCapacity);
        this.elementType = elementType;
    }

    @Override
    public boolean add(T element) {
        if (this.size == this.array.length) {
            Object[] newArray = (Object[])Array.newInstance(this.elementType, this.size * 2);
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
        this.array[this.size++] = element;
        ++this.modCount;
        return true;
    }

    public T[] array() {
        return this.array;
    }

    @Override
    public T get(int i) {
        return this.array[i];
    }

    @Override
    public int size() {
        return this.size;
    }
}

