/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;

public abstract class CharsetDecoder {
    private static final int INIT = 0;
    private static final int ONGOING = 1;
    private static final int END = 2;
    private static final int FLUSH = 3;
    private final float averageCharsPerByte;
    private final float maxCharsPerByte;
    private final Charset cs;
    private CodingErrorAction malformedInputAction;
    private CodingErrorAction unmappableCharacterAction;
    private String replacementChars;
    private int status;

    protected CharsetDecoder(Charset charset, float averageCharsPerByte, float maxCharsPerByte) {
        if (averageCharsPerByte <= 0.0f || maxCharsPerByte <= 0.0f) {
            throw new IllegalArgumentException("averageCharsPerByte and maxCharsPerByte must be positive");
        }
        if (averageCharsPerByte > maxCharsPerByte) {
            throw new IllegalArgumentException("averageCharsPerByte is greater than maxCharsPerByte");
        }
        this.averageCharsPerByte = averageCharsPerByte;
        this.maxCharsPerByte = maxCharsPerByte;
        this.cs = charset;
        this.status = 0;
        this.malformedInputAction = CodingErrorAction.REPORT;
        this.unmappableCharacterAction = CodingErrorAction.REPORT;
        this.replacementChars = "\ufffd";
    }

    public final float averageCharsPerByte() {
        return this.averageCharsPerByte;
    }

    public final Charset charset() {
        return this.cs;
    }

    public final CharBuffer decode(ByteBuffer in) throws CharacterCodingException {
        this.reset();
        int length = (int)((float)in.remaining() * this.averageCharsPerByte);
        CharBuffer output = CharBuffer.allocate(length);
        CoderResult result = null;
        while (true) {
            result = this.decode(in, output, false);
            this.checkCoderResult(result);
            if (result.isUnderflow()) break;
            if (!result.isOverflow()) continue;
            output = this.allocateMore(output);
        }
        result = this.decode(in, output, true);
        this.checkCoderResult(result);
        while (true) {
            result = this.flush(output);
            this.checkCoderResult(result);
            if (!result.isOverflow()) break;
            output = this.allocateMore(output);
        }
        output.flip();
        this.status = 3;
        return output;
    }

    private void checkCoderResult(CoderResult result) throws CharacterCodingException {
        if (result.isMalformed() && this.malformedInputAction == CodingErrorAction.REPORT) {
            throw new MalformedInputException(result.length());
        }
        if (result.isUnmappable() && this.unmappableCharacterAction == CodingErrorAction.REPORT) {
            throw new UnmappableCharacterException(result.length());
        }
    }

    private CharBuffer allocateMore(CharBuffer output) {
        if (output.capacity() == 0) {
            return CharBuffer.allocate(1);
        }
        CharBuffer result = CharBuffer.allocate(output.capacity() * 2);
        output.flip();
        result.put(output);
        return result;
    }

    public final CoderResult decode(ByteBuffer in, CharBuffer out, boolean endOfInput) {
        if (this.status == 3 || !endOfInput && this.status == 2) {
            throw new IllegalStateException();
        }
        CoderResult result = null;
        while (true) {
            CodingErrorAction action = null;
            try {
                result = this.decodeLoop(in, out);
            }
            catch (BufferOverflowException ex) {
                throw new CoderMalfunctionError(ex);
            }
            catch (BufferUnderflowException ex) {
                throw new CoderMalfunctionError(ex);
            }
            if (result.isUnderflow()) {
                int remaining = in.remaining();
                int n = this.status = endOfInput ? 2 : 1;
                if (endOfInput && remaining > 0) {
                    result = CoderResult.malformedForLength(remaining);
                } else {
                    return result;
                }
            }
            if (result.isOverflow()) {
                return result;
            }
            action = this.malformedInputAction;
            if (result.isUnmappable()) {
                action = this.unmappableCharacterAction;
            }
            if (action == CodingErrorAction.REPLACE) {
                if (out.remaining() < this.replacementChars.length()) {
                    return CoderResult.OVERFLOW;
                }
                out.put(this.replacementChars);
            } else if (action != CodingErrorAction.IGNORE) {
                return result;
            }
            in.position(in.position() + result.length());
        }
    }

    protected abstract CoderResult decodeLoop(ByteBuffer var1, CharBuffer var2);

    public Charset detectedCharset() {
        throw new UnsupportedOperationException();
    }

    public final CoderResult flush(CharBuffer out) {
        if (this.status != 2 && this.status != 0) {
            throw new IllegalStateException();
        }
        CoderResult result = this.implFlush(out);
        if (result == CoderResult.UNDERFLOW) {
            this.status = 3;
        }
        return result;
    }

    protected CoderResult implFlush(CharBuffer out) {
        return CoderResult.UNDERFLOW;
    }

    protected void implOnMalformedInput(CodingErrorAction newAction) {
    }

    protected void implOnUnmappableCharacter(CodingErrorAction newAction) {
    }

    protected void implReplaceWith(String newReplacement) {
    }

    protected void implReset() {
    }

    public boolean isAutoDetecting() {
        return false;
    }

    public boolean isCharsetDetected() {
        throw new UnsupportedOperationException();
    }

    public CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    public final float maxCharsPerByte() {
        return this.maxCharsPerByte;
    }

    public final CharsetDecoder onMalformedInput(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("newAction == null");
        }
        this.malformedInputAction = newAction;
        this.implOnMalformedInput(newAction);
        return this;
    }

    public final CharsetDecoder onUnmappableCharacter(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("newAction == null");
        }
        this.unmappableCharacterAction = newAction;
        this.implOnUnmappableCharacter(newAction);
        return this;
    }

    public final String replacement() {
        return this.replacementChars;
    }

    public final CharsetDecoder replaceWith(String replacement) {
        if (replacement == null) {
            throw new IllegalArgumentException("replacement == null");
        }
        if (replacement.isEmpty()) {
            throw new IllegalArgumentException("replacement.isEmpty()");
        }
        if ((float)replacement.length() > this.maxCharsPerByte()) {
            throw new IllegalArgumentException("replacement length > maxCharsPerByte: " + replacement.length() + " > " + this.maxCharsPerByte());
        }
        this.replacementChars = replacement;
        this.implReplaceWith(replacement);
        return this;
    }

    public final CharsetDecoder reset() {
        this.status = 0;
        this.implReset();
        return this;
    }

    public CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }
}

