/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.nio.channels.FileChannel;

public abstract class FileLock
implements AutoCloseable {
    private final FileChannel channel;
    private final long position;
    private final long size;
    private final boolean shared;

    protected FileLock(FileChannel channel, long position, long size, boolean shared) {
        if (position < 0L || size < 0L || position + size < 0L) {
            throw new IllegalArgumentException("position=" + position + " size=" + size);
        }
        this.channel = channel;
        this.position = position;
        this.size = size;
        this.shared = shared;
    }

    public final FileChannel channel() {
        return this.channel;
    }

    public final long position() {
        return this.position;
    }

    public final long size() {
        return this.size;
    }

    public final boolean isShared() {
        return this.shared;
    }

    public final boolean overlaps(long start, long length) {
        long end = this.position + this.size - 1L;
        long newEnd = start + length - 1L;
        return end >= start && this.position <= newEnd;
    }

    public abstract boolean isValid();

    public abstract void release() throws IOException;

    public final void close() throws IOException {
        this.release();
    }

    public final String toString() {
        return "FileLock[position=" + this.position + ", size=" + this.size + ", shared=" + this.shared + "]";
    }
}

