/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketUtils;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.FileChannelImpl;
import java.nio.FileDescriptorChannel;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.SelectorProvider;
import java.util.Arrays;
import libcore.io.ErrnoException;
import libcore.io.IoBridge;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.io.OsConstants;

class SocketChannelImpl
extends SocketChannel
implements FileDescriptorChannel {
    private static final int SOCKET_STATUS_UNINITIALIZED = -1;
    private static final int SOCKET_STATUS_UNCONNECTED = 0;
    private static final int SOCKET_STATUS_PENDING = 1;
    private static final int SOCKET_STATUS_CONNECTED = 2;
    private static final int SOCKET_STATUS_CLOSED = 3;
    private final FileDescriptor fd;
    private SocketAdapter socket = null;
    private InetSocketAddress connectAddress = null;
    private InetAddress localAddress = null;
    private int localPort;
    private int status = -1;
    private volatile boolean isBound = false;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();

    public SocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        this(selectorProvider, true);
    }

    public SocketChannelImpl(SelectorProvider selectorProvider, boolean connect) throws IOException {
        super(selectorProvider);
        this.status = 0;
        this.fd = connect ? IoBridge.socket(true) : new FileDescriptor();
    }

    public SocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor existingFd) throws IOException {
        super(selectorProvider);
        this.status = 2;
        this.fd = existingFd;
    }

    public synchronized Socket socket() {
        if (this.socket == null) {
            try {
                InetAddress addr = null;
                int port = 0;
                if (this.connectAddress != null) {
                    addr = this.connectAddress.getAddress();
                    port = this.connectAddress.getPort();
                }
                this.socket = new SocketAdapter(new PlainSocketImpl(this.fd, this.localPort, addr, port), this);
            }
            catch (SocketException e) {
                return null;
            }
        }
        return this.socket;
    }

    public synchronized boolean isConnected() {
        return this.status == 2;
    }

    synchronized void setConnected() {
        this.status = 2;
    }

    void setBound(boolean flag) {
        this.isBound = flag;
    }

    public synchronized boolean isConnectionPending() {
        return this.status == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean connect(SocketAddress socketAddress) throws IOException {
        boolean finished;
        InetSocketAddress inetSocketAddress;
        block12: {
            this.checkUnconnected();
            inetSocketAddress = SocketChannelImpl.validateAddress(socketAddress);
            InetAddress normalAddr = inetSocketAddress.getAddress();
            int port = inetSocketAddress.getPort();
            if (normalAddr.isAnyLocalAddress()) {
                normalAddr = InetAddress.getLocalHost();
            }
            finished = false;
            try {
                try {
                    if (this.isBlocking()) {
                        this.begin();
                    }
                    this.isBound = finished = IoBridge.connect(this.fd, normalAddr, port);
                }
                catch (IOException e) {
                    if (!this.isEINPROGRESS(e)) {
                        if (!this.isOpen()) throw e;
                        this.close();
                        finished = true;
                        throw e;
                    }
                    this.status = 1;
                    Object var8_7 = null;
                    if (this.isBlocking()) {
                        this.end(finished);
                    }
                    break block12;
                }
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (!this.isBlocking()) throw throwable;
                this.end(finished);
                throw throwable;
            }
            if (this.isBlocking()) {
                this.end(finished);
            }
        }
        this.initLocalAddressAndPort();
        this.connectAddress = inetSocketAddress;
        if (this.socket != null) {
            this.socket.socketImpl().initRemoteAddressAndPort(this.connectAddress.getAddress(), this.connectAddress.getPort());
        }
        SocketChannelImpl socketChannelImpl = this;
        synchronized (socketChannelImpl) {
            this.status = this.isBlocking() ? (finished ? 2 : 0) : 1;
            return finished;
        }
    }

    private boolean isEINPROGRESS(IOException e) {
        Throwable cause;
        if (this.isBlocking()) {
            return false;
        }
        if (e instanceof ConnectException && (cause = e.getCause()) instanceof ErrnoException) {
            return ((ErrnoException)cause).errno == OsConstants.EINPROGRESS;
        }
        return false;
    }

    private void initLocalAddressAndPort() {
        SocketAddress sa;
        try {
            sa = Libcore.os.getsockname(this.fd);
        }
        catch (ErrnoException errnoException) {
            throw new AssertionError((Object)errnoException);
        }
        InetSocketAddress isa = (InetSocketAddress)sa;
        this.localAddress = isa.getAddress();
        this.localPort = isa.getPort();
        if (this.socket != null) {
            this.socket.socketImpl().initLocalPort(this.localPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishConnect() throws IOException {
        SocketChannelImpl socketChannelImpl = this;
        synchronized (socketChannelImpl) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.status == 2) {
                return true;
            }
            if (this.status != 1) {
                throw new NoConnectionPendingException();
            }
        }
        boolean finished = false;
        try {
            try {
                this.begin();
                InetAddress inetAddress = this.connectAddress.getAddress();
                int port = this.connectAddress.getPort();
                this.isBound = finished = IoBridge.isConnected(this.fd, inetAddress, port, 0, 0);
            }
            catch (ConnectException e) {
                if (this.isOpen()) {
                    this.close();
                    finished = true;
                }
                throw e;
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.end(finished);
            throw throwable;
        }
        this.end(finished);
        SocketChannelImpl socketChannelImpl2 = this;
        synchronized (socketChannelImpl2) {
            this.status = finished ? 2 : this.status;
            this.isBound = finished;
        }
        return finished;
    }

    void finishAccept() {
        this.initLocalAddressAndPort();
    }

    public int read(ByteBuffer dst) throws IOException {
        dst.checkWritable();
        this.checkOpenConnected();
        if (!dst.hasRemaining()) {
            return 0;
        }
        return this.readImpl(dst);
    }

    public long read(ByteBuffer[] targets, int offset, int length) throws IOException {
        Arrays.checkOffsetAndCount(targets.length, offset, length);
        this.checkOpenConnected();
        int totalCount = FileChannelImpl.calculateTotalRemaining(targets, offset, length, true);
        if (totalCount == 0) {
            return 0L;
        }
        byte[] readArray = new byte[totalCount];
        ByteBuffer readBuffer = ByteBuffer.wrap(readArray);
        int readCount = this.readImpl(readBuffer);
        readBuffer.flip();
        if (readCount > 0) {
            int putLength;
            int index = offset;
            for (int left = readCount; left > 0; left -= putLength) {
                putLength = Math.min(targets[index].remaining(), left);
                targets[index].put(readArray, readCount - left, putLength);
                ++index;
            }
        }
        return readCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readImpl(ByteBuffer dst) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            int readCount = 0;
            try {
                if (this.isBlocking()) {
                    this.begin();
                }
                if ((readCount = IoBridge.recvfrom(true, this.fd, dst, 0, null, false)) > 0) {
                    dst.position(dst.position() + readCount);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.isBlocking()) {
                    this.end(readCount > 0);
                }
                throw throwable;
            }
            if (this.isBlocking()) {
                this.end(readCount > 0);
            }
            return readCount;
        }
    }

    public int write(ByteBuffer src) throws IOException {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        this.checkOpenConnected();
        if (!src.hasRemaining()) {
            return 0;
        }
        return this.writeImpl(src);
    }

    public long write(ByteBuffer[] sources, int offset, int length) throws IOException {
        int gap;
        int result;
        Arrays.checkOffsetAndCount(sources.length, offset, length);
        this.checkOpenConnected();
        int count = FileChannelImpl.calculateTotalRemaining(sources, offset, length, false);
        if (count == 0) {
            return 0L;
        }
        ByteBuffer writeBuf = ByteBuffer.allocate(count);
        for (int val = offset; val < length + offset; ++val) {
            ByteBuffer source = sources[val];
            int oldPosition = source.position();
            writeBuf.put(source);
            source.position(oldPosition);
        }
        writeBuf.flip();
        int val = offset;
        int written = result;
        for (result = this.writeImpl(writeBuf); result > 0; result -= gap) {
            ByteBuffer source = sources[val];
            gap = Math.min(result, source.remaining());
            source.position(source.position() + gap);
            ++val;
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeImpl(ByteBuffer src) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (!src.hasRemaining()) {
                return 0;
            }
            int writeCount = 0;
            try {
                if (this.isBlocking()) {
                    this.begin();
                }
                if ((writeCount = IoBridge.sendto(this.fd, src, 0, null, 0)) > 0) {
                    src.position(src.position() + writeCount);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.isBlocking()) {
                    this.end(writeCount >= 0);
                }
                throw throwable;
            }
            if (this.isBlocking()) {
                this.end(writeCount >= 0);
            }
            return writeCount;
        }
    }

    private synchronized void checkOpenConnected() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
    }

    private synchronized void checkUnconnected() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.status == 2) {
            throw new AlreadyConnectedException();
        }
        if (this.status == 1) {
            throw new ConnectionPendingException();
        }
    }

    static InetSocketAddress validateAddress(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new IllegalArgumentException("socketAddress == null");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        return inetSocketAddress;
    }

    public InetAddress getLocalAddress() throws UnknownHostException {
        return this.isBound ? this.localAddress : Inet4Address.ANY;
    }

    protected synchronized void implCloseSelectableChannel() throws IOException {
        if (this.status != 3) {
            this.status = 3;
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            } else {
                IoBridge.closeSocket(this.fd);
            }
        }
    }

    protected void implConfigureBlocking(boolean blocking) throws IOException {
        IoUtils.setBlocking(this.fd, blocking);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    private static class SocketChannelInputStream
    extends InputStream {
        private final SocketChannel channel;

        public SocketChannelInputStream(SocketChannel channel) {
            this.channel = channel;
        }

        public void close() throws IOException {
            this.channel.close();
        }

        public int read() throws IOException {
            if (!this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            ByteBuffer buf = ByteBuffer.allocate(1);
            int result = this.channel.read(buf);
            return result == -1 ? result : buf.get(0) & 0xFF;
        }

        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            Arrays.checkOffsetAndCount(buffer.length, byteOffset, byteCount);
            if (!this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            ByteBuffer buf = ByteBuffer.wrap(buffer, byteOffset, byteCount);
            return this.channel.read(buf);
        }
    }

    private static class SocketChannelOutputStream
    extends OutputStream {
        private final SocketChannel channel;

        public SocketChannelOutputStream(SocketChannel channel) {
            this.channel = channel;
        }

        public void close() throws IOException {
            this.channel.close();
        }

        public void write(byte[] buffer, int offset, int byteCount) throws IOException {
            Arrays.checkOffsetAndCount(buffer.length, offset, byteCount);
            ByteBuffer buf = ByteBuffer.wrap(buffer, offset, byteCount);
            if (!this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            this.channel.write(buf);
        }

        public void write(int oneByte) throws IOException {
            if (!this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put(0, (byte)(oneByte & 0xFF));
            this.channel.write(buffer);
        }
    }

    private static class SocketAdapter
    extends Socket {
        private final SocketChannelImpl channel;
        private final PlainSocketImpl socketImpl;

        SocketAdapter(PlainSocketImpl socketImpl, SocketChannelImpl channel) throws SocketException {
            super(socketImpl);
            this.socketImpl = socketImpl;
            this.channel = channel;
            SocketUtils.setCreated(this);
        }

        PlainSocketImpl socketImpl() {
            return this.socketImpl;
        }

        public SocketChannel getChannel() {
            return this.channel;
        }

        public boolean isBound() {
            return this.channel.isBound;
        }

        public boolean isConnected() {
            return this.channel.isConnected();
        }

        public InetAddress getLocalAddress() {
            try {
                return this.channel.getLocalAddress();
            }
            catch (UnknownHostException e) {
                return null;
            }
        }

        public void connect(SocketAddress remoteAddr, int timeout) throws IOException {
            if (!this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            if (this.isConnected()) {
                throw new AlreadyConnectedException();
            }
            super.connect(remoteAddr, timeout);
            this.channel.initLocalAddressAndPort();
            if (super.isConnected()) {
                this.channel.setConnected();
                this.channel.isBound = super.isBound();
            }
        }

        public void bind(SocketAddress localAddr) throws IOException {
            if (this.channel.isConnected()) {
                throw new AlreadyConnectedException();
            }
            if (1 == this.channel.status) {
                throw new ConnectionPendingException();
            }
            super.bind(localAddr);
            this.channel.initLocalAddressAndPort();
            this.channel.isBound = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            SocketChannelImpl socketChannelImpl = this.channel;
            synchronized (socketChannelImpl) {
                if (this.channel.isOpen()) {
                    this.channel.close();
                } else {
                    super.close();
                }
                this.channel.status = 3;
            }
        }

        public OutputStream getOutputStream() throws IOException {
            this.checkOpenAndConnected();
            if (this.isOutputShutdown()) {
                throw new SocketException("Socket output is shutdown");
            }
            return new SocketChannelOutputStream(this.channel);
        }

        public InputStream getInputStream() throws IOException {
            this.checkOpenAndConnected();
            if (this.isInputShutdown()) {
                throw new SocketException("Socket input is shutdown");
            }
            return new SocketChannelInputStream(this.channel);
        }

        private void checkOpenAndConnected() throws SocketException {
            if (!this.channel.isOpen()) {
                throw new SocketException("Socket is closed");
            }
            if (!this.channel.isConnected()) {
                throw new SocketException("Socket is not connected");
            }
        }

        public FileDescriptor getFileDescriptor$() {
            return this.socketImpl.getFD$();
        }
    }
}

