/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.LongArrayBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LongBuffer
extends Buffer
implements Comparable<LongBuffer> {
    public static LongBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        return new LongArrayBuffer(new long[capacity]);
    }

    public static LongBuffer wrap(long[] array2) {
        return LongBuffer.wrap(array2, 0, array2.length);
    }

    public static LongBuffer wrap(long[] array2, int start, int longCount) {
        Arrays.checkOffsetAndCount(array2.length, start, longCount);
        LongArrayBuffer buf = new LongArrayBuffer(array2);
        buf.position = start;
        buf.limit = start + longCount;
        return buf;
    }

    LongBuffer(int capacity) {
        super(3, capacity, null);
    }

    public final long[] array() {
        return this.protectedArray();
    }

    @Override
    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public abstract LongBuffer asReadOnlyBuffer();

    public abstract LongBuffer compact();

    @Override
    public int compareTo(LongBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            long otherLong;
            long thisLong = this.get(thisPos);
            if (thisLong != (otherLong = otherBuffer.get(otherPos))) {
                return thisLong < otherLong ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public abstract LongBuffer duplicate();

    public boolean equals(Object other) {
        if (!(other instanceof LongBuffer)) {
            return false;
        }
        LongBuffer otherBuffer = (LongBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            equalSoFar = this.get(myPosition++) == otherBuffer.get(otherPosition++);
        }
        return equalSoFar;
    }

    public abstract long get();

    public LongBuffer get(long[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public LongBuffer get(long[] dst, int dstOffset, int longCount) {
        Arrays.checkOffsetAndCount(dst.length, dstOffset, longCount);
        if (longCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (int i = dstOffset; i < dstOffset + longCount; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public abstract long get(int var1);

    @Override
    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public int hashCode() {
        int myPosition = this.position;
        int hash = 0;
        while (myPosition < this.limit) {
            long l = this.get(myPosition++);
            hash = hash + (int)l ^ (int)(l >> 32);
        }
        return hash;
    }

    @Override
    public abstract boolean isDirect();

    public abstract ByteOrder order();

    abstract long[] protectedArray();

    abstract int protectedArrayOffset();

    abstract boolean protectedHasArray();

    public abstract LongBuffer put(long var1);

    public final LongBuffer put(long[] src) {
        return this.put(src, 0, src.length);
    }

    public LongBuffer put(long[] src, int srcOffset, int longCount) {
        Arrays.checkOffsetAndCount(src.length, srcOffset, longCount);
        if (longCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = srcOffset; i < srcOffset + longCount; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public LongBuffer put(LongBuffer src) {
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (src == this) {
            throw new IllegalArgumentException("src == this");
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        long[] contents = new long[src.remaining()];
        src.get(contents);
        this.put(contents);
        return this;
    }

    public abstract LongBuffer put(int var1, long var2);

    public abstract LongBuffer slice();
}

