/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.SocketAddress;

public class Proxy {
    public static final Proxy NO_PROXY = new Proxy();
    private Type type;
    private SocketAddress address;

    public Proxy(Type type, SocketAddress sa) {
        if (type == Type.DIRECT || sa == null) {
            throw new IllegalArgumentException("Illegal Proxy.Type or SocketAddress argument");
        }
        this.type = type;
        this.address = sa;
    }

    private Proxy() {
        this.type = Type.DIRECT;
        this.address = null;
    }

    public Type type() {
        return this.type;
    }

    public SocketAddress address() {
        return this.address;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.type != null) {
            builder.append(this.type.toString());
        }
        builder.append("@");
        if (this.type != Type.DIRECT && this.address != null) {
            builder.append(this.address.toString());
        }
        return builder.toString();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Proxy)) {
            return false;
        }
        Proxy another = (Proxy)obj;
        return this.type == another.type && this.address.equals(another.address);
    }

    public final int hashCode() {
        int ret = 0;
        ret += this.type.hashCode();
        if (this.address != null) {
            ret += this.address.hashCode();
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DIRECT,
        HTTP,
        SOCKS;

    }
}

