/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;

public class InterfaceAddress {
    private final InetAddress address;
    private final InetAddress broadcastAddress;
    private final short prefixLength;

    InterfaceAddress(Inet4Address address, Inet4Address broadcastAddress, Inet4Address mask) {
        this.address = address;
        this.broadcastAddress = broadcastAddress;
        this.prefixLength = InterfaceAddress.countPrefixLength(mask);
    }

    InterfaceAddress(Inet6Address address, short prefixLength) {
        this.address = address;
        this.broadcastAddress = null;
        this.prefixLength = prefixLength;
    }

    private static short countPrefixLength(Inet4Address mask) {
        short count = 0;
        for (byte b : mask.ipaddress) {
            for (int i = 0; i < 8; ++i) {
                if ((b & 1 << i) == 0) continue;
                count = (short)(count + 1);
            }
        }
        return count;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InterfaceAddress)) {
            return false;
        }
        InterfaceAddress rhs = (InterfaceAddress)obj;
        return (this.address == null ? rhs.address == null : this.address.equals(rhs.address)) && rhs.prefixLength == this.prefixLength && (this.broadcastAddress == null ? rhs.broadcastAddress == null : this.broadcastAddress.equals(rhs.broadcastAddress));
    }

    public int hashCode() {
        int hashCode = this.address == null ? 0 : -this.address.hashCode();
        hashCode += this.broadcastAddress == null ? 0 : this.broadcastAddress.hashCode();
        return hashCode += this.prefixLength;
    }

    public String toString() {
        return this.address + "/" + this.prefixLength + " [" + this.broadcastAddress + "]";
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public InetAddress getBroadcast() {
        return this.broadcastAddress;
    }

    public short getNetworkPrefixLength() {
        return this.prefixLength;
    }
}

