/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class PushbackReader
extends FilterReader {
    char[] buf;
    int pos;

    public PushbackReader(Reader in) {
        super(in);
        this.buf = new char[1];
        this.pos = 1;
    }

    public PushbackReader(Reader in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new char[size];
        this.pos = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.buf = null;
            this.in.close();
        }
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (this.pos < this.buf.length) {
                return this.buf[this.pos++];
            }
            return this.in.read();
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.buf == null) {
            throw new IOException("PushbackReader is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] buffer, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            Arrays.checkOffsetAndCount(buffer.length, offset, count);
            int copiedChars = 0;
            int copyLength = 0;
            int newOffset = offset;
            if (this.pos < this.buf.length) {
                copyLength = this.buf.length - this.pos >= count ? count : this.buf.length - this.pos;
                System.arraycopy(this.buf, this.pos, buffer, newOffset, copyLength);
                newOffset += copyLength;
                copiedChars += copyLength;
                this.pos += copyLength;
            }
            if (copyLength == count) {
                return count;
            }
            int inCopied = this.in.read(buffer, newOffset, count - copiedChars);
            if (inCopied > 0) {
                return inCopied + copiedChars;
            }
            if (copiedChars == 0) {
                return inCopied;
            }
            return copiedChars;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Reader is closed");
            }
            return this.buf.length - this.pos > 0 || this.in.ready();
        }
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public void unread(char[] buffer) throws IOException {
        this.unread(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(char[] buffer, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (length > this.pos) {
                throw new IOException("Pushback buffer full");
            }
            Arrays.checkOffsetAndCount(buffer.length, offset, length);
            for (int i = offset + length - 1; i >= offset; --i) {
                this.unread(buffer[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(int oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (this.pos == 0) {
                throw new IOException("Pushback buffer full");
            }
            this.buf[--this.pos] = (char)oneChar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long charCount) throws IOException {
        if (charCount < 0L) {
            throw new IllegalArgumentException("charCount < 0: " + charCount);
        }
        Object object = this.lock;
        synchronized (object) {
            long inSkipped;
            this.checkNotClosed();
            if (charCount == 0L) {
                return 0L;
            }
            int availableFromBuffer = this.buf.length - this.pos;
            if (availableFromBuffer > 0) {
                long requiredFromIn = charCount - (long)availableFromBuffer;
                if (requiredFromIn <= 0L) {
                    this.pos = (int)((long)this.pos + charCount);
                    return charCount;
                }
                this.pos += availableFromBuffer;
                inSkipped = this.in.skip(requiredFromIn);
            } else {
                inSkipped = this.in.skip(charCount);
            }
            return inSkipped + (long)availableFromBuffer;
        }
    }
}

