/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.EmulatedFields;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

class EmulatedFieldsForDumping
extends ObjectOutputStream.PutField {
    private final ObjectOutputStream oos;
    private EmulatedFields emulatedFields;

    EmulatedFieldsForDumping(ObjectOutputStream oos, ObjectStreamClass streamClass) {
        this.oos = oos;
        this.emulatedFields = new EmulatedFields(streamClass.fields(), null);
    }

    EmulatedFields emulatedFields() {
        return this.emulatedFields;
    }

    public void put(String name, byte value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, char value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, double value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, float value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, int value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, long value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, Object value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, short value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, boolean value) {
        this.emulatedFields.put(name, value);
    }

    @Deprecated
    public void write(ObjectOutput output) throws IOException {
        if (!output.equals(this.oos)) {
            throw new IllegalArgumentException("Attempting to write to a different stream than the one that created this PutField");
        }
        for (EmulatedFields.ObjectSlot slot : this.emulatedFields.slots()) {
            Object fieldValue = slot.getFieldValue();
            Class<?> type = slot.getField().getType();
            if (type == Integer.TYPE) {
                output.writeInt(fieldValue != null ? (Integer)fieldValue : 0);
                continue;
            }
            if (type == Byte.TYPE) {
                output.writeByte(fieldValue != null ? (int)((Byte)fieldValue).byteValue() : 0);
                continue;
            }
            if (type == Character.TYPE) {
                output.writeChar(fieldValue != null ? (int)((Character)fieldValue).charValue() : 0);
                continue;
            }
            if (type == Short.TYPE) {
                output.writeShort(fieldValue != null ? (int)((Short)fieldValue).shortValue() : 0);
                continue;
            }
            if (type == Boolean.TYPE) {
                output.writeBoolean(fieldValue != null ? (Boolean)fieldValue : false);
                continue;
            }
            if (type == Long.TYPE) {
                output.writeLong(fieldValue != null ? (Long)fieldValue : 0L);
                continue;
            }
            if (type == Float.TYPE) {
                output.writeFloat(fieldValue != null ? ((Float)fieldValue).floatValue() : 0.0f);
                continue;
            }
            if (type == Double.TYPE) {
                output.writeDouble(fieldValue != null ? (Double)fieldValue : 0.0);
                continue;
            }
            output.writeObject(fieldValue);
        }
    }
}

