/*
 * Decompiled with CFR 0.152.
 */
package com.android.webview.chromium;

import android.webkit.WebBackForwardList;
import android.webkit.WebHistoryItem;
import com.android.org.chromium.content.browser.NavigationHistory;
import com.android.webview.chromium.WebHistoryItemChromium;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBackForwardListChromium
extends WebBackForwardList {
    private final List<WebHistoryItemChromium> mHistroryItemList;
    private final int mCurrentIndex;

    WebBackForwardListChromium(NavigationHistory nav_history) {
        this.mCurrentIndex = nav_history.getCurrentEntryIndex();
        this.mHistroryItemList = new ArrayList<WebHistoryItemChromium>(nav_history.getEntryCount());
        for (int i = 0; i < nav_history.getEntryCount(); ++i) {
            this.mHistroryItemList.add(new WebHistoryItemChromium(nav_history.getEntryAtIndex(i)));
        }
    }

    @Override
    public synchronized WebHistoryItem getCurrentItem() {
        if (this.getSize() == 0) {
            return null;
        }
        return this.getItemAtIndex(this.getCurrentIndex());
    }

    @Override
    public synchronized int getCurrentIndex() {
        return this.mCurrentIndex;
    }

    @Override
    public synchronized WebHistoryItem getItemAtIndex(int index) {
        if (index < 0 || index >= this.getSize()) {
            return null;
        }
        return this.mHistroryItemList.get(index);
    }

    @Override
    public synchronized int getSize() {
        return this.mHistroryItemList.size();
    }

    private WebBackForwardListChromium(List<WebHistoryItemChromium> list, int currentIndex) {
        this.mHistroryItemList = list;
        this.mCurrentIndex = currentIndex;
    }

    @Override
    protected synchronized WebBackForwardListChromium clone() {
        ArrayList<WebHistoryItemChromium> list = new ArrayList<WebHistoryItemChromium>(this.getSize());
        for (int i = 0; i < this.getSize(); ++i) {
            list.add(this.mHistroryItemList.get(i).clone());
        }
        return new WebBackForwardListChromium(list, this.mCurrentIndex);
    }
}

