/*
 * Decompiled with CFR 0.152.
 */
package com.android.webview.chromium;

import android.net.ParseException;
import android.net.WebAddress;
import android.util.Log;
import android.webkit.CookieManager;
import com.android.org.chromium.android_webview.AwCookieManager;

public class CookieManagerAdapter
extends CookieManager {
    private static final String LOGTAG = "CookieManager";
    AwCookieManager mChromeCookieManager;

    public CookieManagerAdapter(AwCookieManager chromeCookieManager) {
        this.mChromeCookieManager = chromeCookieManager;
    }

    public synchronized void setAcceptCookie(boolean accept) {
        this.mChromeCookieManager.setAcceptCookie(accept);
    }

    public synchronized boolean acceptCookie() {
        return this.mChromeCookieManager.acceptCookie();
    }

    public void setCookie(String url, String value) {
        try {
            this.mChromeCookieManager.setCookie(CookieManagerAdapter.fixupUrl(url), value);
        }
        catch (ParseException e) {
            Log.e(LOGTAG, "Not setting cookie due to error parsing URL: " + url, e);
        }
    }

    public String getCookie(String url) {
        try {
            return this.mChromeCookieManager.getCookie(CookieManagerAdapter.fixupUrl(url));
        }
        catch (ParseException e) {
            Log.e(LOGTAG, "Unable to get cookies due to error parsing URL: " + url, e);
            return null;
        }
    }

    public String getCookie(String url, boolean privateBrowsing) {
        return this.getCookie(url);
    }

    public synchronized String getCookie(WebAddress uri) {
        return this.mChromeCookieManager.getCookie(uri.toString());
    }

    public void removeSessionCookie() {
        this.mChromeCookieManager.removeSessionCookie();
    }

    public void removeAllCookie() {
        this.mChromeCookieManager.removeAllCookie();
    }

    public synchronized boolean hasCookies() {
        return this.mChromeCookieManager.hasCookies();
    }

    public synchronized boolean hasCookies(boolean privateBrowsing) {
        return this.mChromeCookieManager.hasCookies();
    }

    public void removeExpiredCookie() {
        this.mChromeCookieManager.removeExpiredCookie();
    }

    protected void flushCookieStore() {
        this.mChromeCookieManager.flushCookieStore();
    }

    protected boolean allowFileSchemeCookiesImpl() {
        return this.mChromeCookieManager.allowFileSchemeCookies();
    }

    protected void setAcceptFileSchemeCookiesImpl(boolean accept) {
        this.mChromeCookieManager.setAcceptFileSchemeCookies(accept);
    }

    private static String fixupUrl(String url) throws ParseException {
        return new WebAddress(url).toString();
    }
}

