/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wifi;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import java.io.FileDescriptor;
import java.io.PrintWriter;

final class WifiSettingsStore {
    private static final int WIFI_DISABLED = 0;
    private static final int WIFI_ENABLED = 1;
    private static final int WIFI_ENABLED_AIRPLANE_OVERRIDE = 2;
    private static final int WIFI_DISABLED_AIRPLANE_ON = 3;
    private int mPersistWifiState = 0;
    private boolean mAirplaneModeOn = false;
    private boolean mScanAlwaysAvailable;
    private final Context mContext;
    private boolean mCheckSavedStateAtBoot = false;

    WifiSettingsStore(Context context) {
        this.mContext = context;
        this.mAirplaneModeOn = this.getPersistedAirplaneModeOn();
        this.mPersistWifiState = this.getPersistedWifiState();
        this.mScanAlwaysAvailable = this.getPersistedScanAlwaysAvailable();
    }

    synchronized boolean isWifiToggleEnabled() {
        if (!this.mCheckSavedStateAtBoot) {
            this.mCheckSavedStateAtBoot = true;
            if (this.testAndClearWifiSavedState()) {
                return true;
            }
        }
        if (this.mAirplaneModeOn) {
            return this.mPersistWifiState == 2;
        }
        return this.mPersistWifiState != 0;
    }

    synchronized boolean isAirplaneModeOn() {
        return this.mAirplaneModeOn;
    }

    synchronized boolean isScanAlwaysAvailable() {
        return this.mScanAlwaysAvailable;
    }

    synchronized boolean handleWifiToggled(boolean wifiEnabled) {
        if (this.mAirplaneModeOn && !this.isAirplaneToggleable()) {
            return false;
        }
        if (wifiEnabled) {
            if (this.mAirplaneModeOn) {
                this.persistWifiState(2);
            } else {
                this.persistWifiState(1);
            }
        } else {
            this.persistWifiState(0);
        }
        return true;
    }

    synchronized boolean handleAirplaneModeToggled() {
        if (!this.isAirplaneSensitive()) {
            return false;
        }
        this.mAirplaneModeOn = this.getPersistedAirplaneModeOn();
        if (this.mAirplaneModeOn) {
            if (this.mPersistWifiState == 1) {
                this.persistWifiState(3);
            }
        } else if (this.testAndClearWifiSavedState() || this.mPersistWifiState == 2) {
            this.persistWifiState(1);
        }
        return true;
    }

    synchronized void handleWifiScanAlwaysAvailableToggled() {
        this.mScanAlwaysAvailable = this.getPersistedScanAlwaysAvailable();
    }

    void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("mPersistWifiState " + this.mPersistWifiState);
        pw.println("mAirplaneModeOn " + this.mAirplaneModeOn);
    }

    private void persistWifiState(int state) {
        ContentResolver cr = this.mContext.getContentResolver();
        this.mPersistWifiState = state;
        Settings.Global.putInt(cr, "wifi_on", state);
    }

    private boolean isAirplaneSensitive() {
        String airplaneModeRadios = Settings.Global.getString(this.mContext.getContentResolver(), "airplane_mode_radios");
        return airplaneModeRadios == null || airplaneModeRadios.contains("wifi");
    }

    private boolean isAirplaneToggleable() {
        String toggleableRadios = Settings.Global.getString(this.mContext.getContentResolver(), "airplane_mode_toggleable_radios");
        return toggleableRadios != null && toggleableRadios.contains("wifi");
    }

    private boolean testAndClearWifiSavedState() {
        ContentResolver cr = this.mContext.getContentResolver();
        int wifiSavedState = 0;
        try {
            wifiSavedState = Settings.Global.getInt(cr, "wifi_saved_state");
            if (wifiSavedState == 1) {
                Settings.Global.putInt(cr, "wifi_saved_state", 0);
            }
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        return wifiSavedState == 1;
    }

    private int getPersistedWifiState() {
        ContentResolver cr = this.mContext.getContentResolver();
        try {
            return Settings.Global.getInt(cr, "wifi_on");
        }
        catch (Settings.SettingNotFoundException e) {
            Settings.Global.putInt(cr, "wifi_on", 0);
            return 0;
        }
    }

    private boolean getPersistedAirplaneModeOn() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "airplane_mode_on", 0) == 1;
    }

    private boolean getPersistedScanAlwaysAvailable() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "wifi_scan_always_enabled", 0) == 1;
    }
}

