/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.app.ActivityManagerNative;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.IActivityManager;
import android.app.ProgressDialog;
import android.bluetooth.IBluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.INfcAdapter;
import android.os.Handler;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.SystemVibrator;
import android.os.UserHandle;
import android.os.Vibrator;
import android.os.storage.IMountService;
import android.os.storage.IMountShutdownObserver;
import android.util.Log;
import com.android.internal.telephony.ITelephony;
import com.android.server.power.PowerManagerService;

public final class ShutdownThread
extends Thread {
    private static final String TAG = "ShutdownThread";
    private static final int PHONE_STATE_POLL_SLEEP_MSEC = 500;
    private static final int MAX_BROADCAST_TIME = 10000;
    private static final int MAX_SHUTDOWN_WAIT_TIME = 20000;
    private static final int MAX_RADIO_WAIT_TIME = 12000;
    private static final int SHUTDOWN_VIBRATE_MS = 500;
    private static Object sIsStartedGuard = new Object();
    private static boolean sIsStarted = false;
    private static boolean mReboot;
    private static boolean mRebootSafeMode;
    private static String mRebootReason;
    public static final String SHUTDOWN_ACTION_PROPERTY = "sys.shutdown.requested";
    public static final String REBOOT_SAFEMODE_PROPERTY = "persist.sys.safemode";
    private static final ShutdownThread sInstance;
    private final Object mActionDoneSync = new Object();
    private boolean mActionDone;
    private Context mContext;
    private PowerManager mPowerManager;
    private PowerManager.WakeLock mCpuWakeLock;
    private PowerManager.WakeLock mScreenWakeLock;
    private Handler mHandler;
    private static AlertDialog sConfirmDialog;

    private ShutdownThread() {
    }

    public static void shutdown(Context context, boolean confirm) {
        mReboot = false;
        mRebootSafeMode = false;
        ShutdownThread.shutdownInner(context, confirm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdownInner(final Context context, boolean confirm) {
        Object object = sIsStartedGuard;
        synchronized (object) {
            if (sIsStarted) {
                Log.d(TAG, "Request to shutdown already running, returning.");
                return;
            }
        }
        int longPressBehavior = context.getResources().getInteger(17694748);
        int resourceId = mRebootSafeMode ? 17039552 : (longPressBehavior == 2 ? 17039550 : 17039549);
        Log.d(TAG, "Notifying thread to start shutdown longPressBehavior=" + longPressBehavior);
        if (confirm) {
            CloseDialogReceiver closer = new CloseDialogReceiver(context);
            if (sConfirmDialog != null) {
                sConfirmDialog.dismiss();
            }
            sConfirmDialog = new AlertDialog.Builder(context).setTitle(mRebootSafeMode ? 17039551 : 17039544).setMessage(resourceId).setPositiveButton(17039379, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ShutdownThread.beginShutdownSequence(context);
                }
            }).setNegativeButton(17039369, null).create();
            closer.dialog = sConfirmDialog;
            sConfirmDialog.setOnDismissListener(closer);
            sConfirmDialog.getWindow().setType(2009);
            sConfirmDialog.show();
        } else {
            ShutdownThread.beginShutdownSequence(context);
        }
    }

    public static void reboot(Context context, String reason, boolean confirm) {
        mReboot = true;
        mRebootSafeMode = false;
        mRebootReason = reason;
        ShutdownThread.shutdownInner(context, confirm);
    }

    public static void rebootSafeMode(Context context, boolean confirm) {
        mReboot = true;
        mRebootSafeMode = true;
        mRebootReason = null;
        ShutdownThread.shutdownInner(context, confirm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void beginShutdownSequence(Context context) {
        Object object = sIsStartedGuard;
        synchronized (object) {
            if (sIsStarted) {
                Log.d(TAG, "Shutdown sequence already running, returning.");
                return;
            }
            sIsStarted = true;
        }
        ProgressDialog pd = new ProgressDialog(context);
        pd.setTitle(context.getText(17039544));
        pd.setMessage(context.getText(17039548));
        pd.setIndeterminate(true);
        pd.setCancelable(false);
        pd.getWindow().setType(2009);
        pd.show();
        ShutdownThread.sInstance.mContext = context;
        ShutdownThread.sInstance.mPowerManager = (PowerManager)context.getSystemService("power");
        ShutdownThread.sInstance.mCpuWakeLock = null;
        try {
            ShutdownThread.sInstance.mCpuWakeLock = ShutdownThread.sInstance.mPowerManager.newWakeLock(1, "ShutdownThread-cpu");
            ShutdownThread.sInstance.mCpuWakeLock.setReferenceCounted(false);
            ShutdownThread.sInstance.mCpuWakeLock.acquire();
        }
        catch (SecurityException e) {
            Log.w(TAG, "No permission to acquire wake lock", e);
            ShutdownThread.sInstance.mCpuWakeLock = null;
        }
        ShutdownThread.sInstance.mScreenWakeLock = null;
        if (ShutdownThread.sInstance.mPowerManager.isScreenOn()) {
            try {
                ShutdownThread.sInstance.mScreenWakeLock = ShutdownThread.sInstance.mPowerManager.newWakeLock(26, "ShutdownThread-screen");
                ShutdownThread.sInstance.mScreenWakeLock.setReferenceCounted(false);
                ShutdownThread.sInstance.mScreenWakeLock.acquire();
            }
            catch (SecurityException e) {
                Log.w(TAG, "No permission to acquire wake lock", e);
                ShutdownThread.sInstance.mScreenWakeLock = null;
            }
        }
        ShutdownThread.sInstance.mHandler = new Handler(){};
        sInstance.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void actionDone() {
        Object object = this.mActionDoneSync;
        synchronized (object) {
            this.mActionDone = true;
            this.mActionDoneSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        BroadcastReceiver br = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ShutdownThread.this.actionDone();
            }
        };
        String reason = (mReboot ? "1" : "0") + (mRebootReason != null ? mRebootReason : "");
        SystemProperties.set(SHUTDOWN_ACTION_PROPERTY, reason);
        if (mRebootSafeMode) {
            SystemProperties.set(REBOOT_SAFEMODE_PROPERTY, "1");
        }
        Log.i(TAG, "Sending shutdown broadcast...");
        this.mActionDone = false;
        Intent intent = new Intent("android.intent.action.ACTION_SHUTDOWN");
        intent.addFlags(0x10000000);
        this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, null, br, this.mHandler, 0, null, null);
        long endTime = SystemClock.elapsedRealtime() + 10000L;
        Object object = this.mActionDoneSync;
        synchronized (object) {
            while (!this.mActionDone) {
                long delay = endTime - SystemClock.elapsedRealtime();
                if (delay <= 0L) {
                    Log.w(TAG, "Shutdown broadcast timed out");
                    break;
                }
                try {
                    this.mActionDoneSync.wait(delay);
                }
                catch (InterruptedException e) {}
            }
        }
        Log.i(TAG, "Shutting down activity manager...");
        IActivityManager am = ActivityManagerNative.asInterface(ServiceManager.checkService("activity"));
        if (am != null) {
            try {
                am.shutdown(10000);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        this.shutdownRadios(12000);
        IMountShutdownObserver.Stub observer = new IMountShutdownObserver.Stub(){

            public void onShutDownComplete(int statusCode) throws RemoteException {
                Log.w(ShutdownThread.TAG, "Result code " + statusCode + " from MountService.shutdown");
                ShutdownThread.this.actionDone();
            }
        };
        Log.i(TAG, "Shutting down MountService");
        this.mActionDone = false;
        long endShutTime = SystemClock.elapsedRealtime() + 20000L;
        Object object2 = this.mActionDoneSync;
        synchronized (object2) {
            try {
                IMountService mount = IMountService.Stub.asInterface(ServiceManager.checkService("mount"));
                if (mount != null) {
                    mount.shutdown(observer);
                } else {
                    Log.w(TAG, "MountService unavailable for shutdown");
                }
            }
            catch (Exception e) {
                Log.e(TAG, "Exception during MountService shutdown", e);
            }
            while (!this.mActionDone) {
                long delay = endShutTime - SystemClock.elapsedRealtime();
                if (delay <= 0L) {
                    Log.w(TAG, "Shutdown wait timed out");
                    break;
                }
                try {
                    this.mActionDoneSync.wait(delay);
                }
                catch (InterruptedException e) {}
            }
        }
        ShutdownThread.rebootOrShutdown(mReboot, mRebootReason);
    }

    private void shutdownRadios(int timeout) {
        final long endTime = SystemClock.elapsedRealtime() + (long)timeout;
        final boolean[] done = new boolean[1];
        Thread t = new Thread(){

            public void run() {
                boolean radioOff;
                boolean bluetoothOff;
                boolean nfcOff;
                INfcAdapter nfc = INfcAdapter.Stub.asInterface(ServiceManager.checkService("nfc"));
                ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
                IBluetoothManager bluetooth = IBluetoothManager.Stub.asInterface(ServiceManager.checkService("bluetooth_manager"));
                try {
                    boolean bl = nfcOff = nfc == null || nfc.getState() == 1;
                    if (!nfcOff) {
                        Log.w(ShutdownThread.TAG, "Turning off NFC...");
                        nfc.disable(false);
                    }
                }
                catch (RemoteException ex) {
                    Log.e(ShutdownThread.TAG, "RemoteException during NFC shutdown", ex);
                    nfcOff = true;
                }
                try {
                    boolean bl = bluetoothOff = bluetooth == null || !bluetooth.isEnabled();
                    if (!bluetoothOff) {
                        Log.w(ShutdownThread.TAG, "Disabling Bluetooth...");
                        bluetooth.disable(false);
                    }
                }
                catch (RemoteException ex) {
                    Log.e(ShutdownThread.TAG, "RemoteException during bluetooth shutdown", ex);
                    bluetoothOff = true;
                }
                try {
                    boolean bl = radioOff = phone == null || !phone.isRadioOn();
                    if (!radioOff) {
                        Log.w(ShutdownThread.TAG, "Turning off radio...");
                        phone.setRadio(false);
                    }
                }
                catch (RemoteException ex) {
                    Log.e(ShutdownThread.TAG, "RemoteException during radio shutdown", ex);
                    radioOff = true;
                }
                Log.i(ShutdownThread.TAG, "Waiting for NFC, Bluetooth and Radio...");
                while (SystemClock.elapsedRealtime() < endTime) {
                    if (!bluetoothOff) {
                        try {
                            bluetoothOff = !bluetooth.isEnabled();
                        }
                        catch (RemoteException ex) {
                            Log.e(ShutdownThread.TAG, "RemoteException during bluetooth shutdown", ex);
                            bluetoothOff = true;
                        }
                        if (bluetoothOff) {
                            Log.i(ShutdownThread.TAG, "Bluetooth turned off.");
                        }
                    }
                    if (!radioOff) {
                        try {
                            radioOff = !phone.isRadioOn();
                        }
                        catch (RemoteException ex) {
                            Log.e(ShutdownThread.TAG, "RemoteException during radio shutdown", ex);
                            radioOff = true;
                        }
                        if (radioOff) {
                            Log.i(ShutdownThread.TAG, "Radio turned off.");
                        }
                    }
                    if (!nfcOff) {
                        try {
                            nfcOff = nfc.getState() == 1;
                        }
                        catch (RemoteException ex) {
                            Log.e(ShutdownThread.TAG, "RemoteException during NFC shutdown", ex);
                            nfcOff = true;
                        }
                        if (radioOff) {
                            Log.i(ShutdownThread.TAG, "NFC turned off.");
                        }
                    }
                    if (radioOff && bluetoothOff && nfcOff) {
                        Log.i(ShutdownThread.TAG, "NFC, Radio and Bluetooth shutdown complete.");
                        done[0] = true;
                        break;
                    }
                    SystemClock.sleep(500L);
                }
            }
        };
        t.start();
        try {
            t.join(timeout);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (!done[0]) {
            Log.w(TAG, "Timed out waiting for NFC, Radio and Bluetooth shutdown.");
        }
    }

    public static void rebootOrShutdown(boolean reboot, String reason) {
        if (reboot) {
            Log.i(TAG, "Rebooting, reason: " + reason);
            PowerManagerService.lowLevelReboot(reason);
            Log.e(TAG, "Reboot failed, will attempt shutdown instead");
        } else {
            SystemVibrator vibrator = new SystemVibrator();
            try {
                ((Vibrator)vibrator).vibrate(500L);
            }
            catch (Exception e) {
                Log.w(TAG, "Failed to vibrate during shutdown.", e);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Log.i(TAG, "Performing low-level shutdown...");
        PowerManagerService.lowLevelShutdown();
    }

    static {
        sInstance = new ShutdownThread();
    }

    private static class CloseDialogReceiver
    extends BroadcastReceiver
    implements DialogInterface.OnDismissListener {
        private Context mContext;
        public Dialog dialog;

        CloseDialogReceiver(Context context) {
            this.mContext = context;
            IntentFilter filter = new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS");
            context.registerReceiver(this, filter);
        }

        public void onReceive(Context context, Intent intent) {
            this.dialog.cancel();
        }

        public void onDismiss(DialogInterface unused) {
            this.mContext.unregisterReceiver(this);
        }
    }
}

