/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.SystemSensorManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.SystemService;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.util.TimeUtils;
import android.view.WindowManagerPolicy;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.server.BatteryService;
import com.android.server.LightsService;
import com.android.server.TwilightService;
import com.android.server.Watchdog;
import com.android.server.am.ActivityManagerService;
import com.android.server.display.DisplayManagerService;
import com.android.server.dreams.DreamManagerService;
import com.android.server.power.DisplayBlanker;
import com.android.server.power.DisplayPowerController;
import com.android.server.power.DisplayPowerRequest;
import com.android.server.power.Notifier;
import com.android.server.power.ScreenOnBlocker;
import com.android.server.power.ShutdownThread;
import com.android.server.power.SuspendBlocker;
import com.android.server.power.WirelessChargerDetector;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import libcore.util.Objects;

public final class PowerManagerService
extends IPowerManager.Stub
implements Watchdog.Monitor {
    private static final String TAG = "PowerManagerService";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_SPEW = false;
    private static final int MSG_USER_ACTIVITY_TIMEOUT = 1;
    private static final int MSG_SANDMAN = 2;
    private static final int MSG_SCREEN_ON_BLOCKER_RELEASED = 3;
    private static final int MSG_CHECK_IF_BOOT_ANIMATION_FINISHED = 4;
    private static final int DIRTY_WAKE_LOCKS = 1;
    private static final int DIRTY_WAKEFULNESS = 2;
    private static final int DIRTY_USER_ACTIVITY = 4;
    private static final int DIRTY_ACTUAL_DISPLAY_POWER_STATE_UPDATED = 8;
    private static final int DIRTY_BOOT_COMPLETED = 16;
    private static final int DIRTY_SETTINGS = 32;
    private static final int DIRTY_IS_POWERED = 64;
    private static final int DIRTY_STAY_ON = 128;
    private static final int DIRTY_BATTERY_STATE = 256;
    private static final int DIRTY_PROXIMITY_POSITIVE = 512;
    private static final int DIRTY_SCREEN_ON_BLOCKER_RELEASED = 1024;
    private static final int DIRTY_DOCK_STATE = 2048;
    private static final int WAKEFULNESS_ASLEEP = 0;
    private static final int WAKEFULNESS_AWAKE = 1;
    private static final int WAKEFULNESS_NAPPING = 2;
    private static final int WAKEFULNESS_DREAMING = 3;
    private static final int WAKE_LOCK_CPU = 1;
    private static final int WAKE_LOCK_SCREEN_BRIGHT = 2;
    private static final int WAKE_LOCK_SCREEN_DIM = 4;
    private static final int WAKE_LOCK_BUTTON_BRIGHT = 8;
    private static final int WAKE_LOCK_PROXIMITY_SCREEN_OFF = 16;
    private static final int WAKE_LOCK_STAY_AWAKE = 32;
    private static final int USER_ACTIVITY_SCREEN_BRIGHT = 1;
    private static final int USER_ACTIVITY_SCREEN_DIM = 2;
    private static final int DEFAULT_SCREEN_OFF_TIMEOUT = 15000;
    private static final int MINIMUM_SCREEN_OFF_TIMEOUT = 10000;
    private static final int SCREEN_DIM_DURATION = 7000;
    private static final float MAXIMUM_SCREEN_DIM_RATIO = 0.2f;
    private static final String BOOT_ANIMATION_SERVICE = "bootanim";
    private static final int BOOT_ANIMATION_POLL_INTERVAL = 200;
    private static final int DREAM_BATTERY_LEVEL_DRAIN_CUTOFF = 5;
    private Context mContext;
    private LightsService mLightsService;
    private BatteryService mBatteryService;
    private DisplayManagerService mDisplayManagerService;
    private IBatteryStats mBatteryStats;
    private IAppOpsService mAppOps;
    private HandlerThread mHandlerThread;
    private PowerManagerHandler mHandler;
    private WindowManagerPolicy mPolicy;
    private Notifier mNotifier;
    private DisplayPowerController mDisplayPowerController;
    private WirelessChargerDetector mWirelessChargerDetector;
    private SettingsObserver mSettingsObserver;
    private DreamManagerService mDreamManager;
    private LightsService.Light mAttentionLight;
    private final Object mLock = new Object();
    private int mDirty;
    private int mWakefulness;
    private boolean mSandmanScheduled;
    private final ArrayList<SuspendBlocker> mSuspendBlockers = new ArrayList();
    private final ArrayList<WakeLock> mWakeLocks = new ArrayList();
    private int mWakeLockSummary;
    private boolean mRequestWaitForNegativeProximity;
    private long mLastWakeTime;
    private long mLastSleepTime;
    private boolean mSendWakeUpFinishedNotificationWhenReady;
    private boolean mSendGoToSleepFinishedNotificationWhenReady;
    private long mLastUserActivityTime;
    private long mLastUserActivityTimeNoChangeLights;
    private int mUserActivitySummary;
    private final DisplayPowerRequest mDisplayPowerRequest = new DisplayPowerRequest();
    private long mLastScreenOffEventElapsedRealTime;
    private boolean mDisplayReady;
    private final SuspendBlocker mWakeLockSuspendBlocker;
    private boolean mHoldingWakeLockSuspendBlocker;
    private final SuspendBlocker mDisplaySuspendBlocker;
    private boolean mHoldingDisplaySuspendBlocker;
    private final ScreenOnBlockerImpl mScreenOnBlocker;
    private final DisplayBlankerImpl mDisplayBlanker;
    private boolean mSystemReady;
    private boolean mBootCompleted;
    private boolean mIsPowered;
    private int mPlugType;
    private int mBatteryLevel;
    private int mBatteryLevelWhenDreamStarted;
    private int mDockState = 0;
    private boolean mWakeUpWhenPluggedOrUnpluggedConfig;
    private boolean mSuspendWhenScreenOffDueToProximityConfig;
    private boolean mDreamsSupportedConfig;
    private boolean mDreamsEnabledByDefaultConfig;
    private boolean mDreamsActivatedOnSleepByDefaultConfig;
    private boolean mDreamsActivatedOnDockByDefaultConfig;
    private boolean mDreamsEnabledSetting;
    private boolean mDreamsActivateOnSleepSetting;
    private boolean mDreamsActivateOnDockSetting;
    private int mScreenOffTimeoutSetting;
    private int mMaximumScreenOffTimeoutFromDeviceAdmin = Integer.MAX_VALUE;
    private int mStayOnWhilePluggedInSetting;
    private boolean mStayOn;
    private boolean mProximityPositive;
    private int mScreenBrightnessSettingMinimum;
    private int mScreenBrightnessSettingMaximum;
    private int mScreenBrightnessSettingDefault;
    private int mScreenBrightnessSetting;
    private float mScreenAutoBrightnessAdjustmentSetting;
    private int mScreenBrightnessModeSetting;
    private int mScreenBrightnessOverrideFromWindowManager = -1;
    private long mUserActivityTimeoutOverrideFromWindowManager = -1L;
    private int mTemporaryScreenBrightnessSettingOverride = -1;
    private float mTemporaryScreenAutoBrightnessAdjustmentSettingOverride = Float.NaN;
    private long mLastWarningAboutUserActivityPermission = Long.MIN_VALUE;
    private final DisplayPowerController.Callbacks mDisplayPowerControllerCallbacks = new DisplayPowerController.Callbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStateChanged() {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.mDirty |= 8;
                PowerManagerService.this.updatePowerStateLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProximityPositive() {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.mProximityPositive = true;
                PowerManagerService.this.mDirty |= 512;
                PowerManagerService.this.updatePowerStateLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProximityNegative() {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.mProximityPositive = false;
                PowerManagerService.this.mDirty |= 512;
                PowerManagerService.this.userActivityNoUpdateLocked(SystemClock.uptimeMillis(), 0, 0, 1000);
                PowerManagerService.this.updatePowerStateLocked();
            }
        }
    };

    private native void nativeInit();

    private static native void nativeSetPowerState(boolean var0, boolean var1);

    private static native void nativeAcquireSuspendBlocker(String var0);

    private static native void nativeReleaseSuspendBlocker(String var0);

    private static native void nativeSetInteractive(boolean var0);

    private static native void nativeSetAutoSuspend(boolean var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerManagerService() {
        Object object = this.mLock;
        synchronized (object) {
            this.mWakeLockSuspendBlocker = this.createSuspendBlockerLocked("PowerManagerService.WakeLocks");
            this.mDisplaySuspendBlocker = this.createSuspendBlockerLocked("PowerManagerService.Display");
            this.mDisplaySuspendBlocker.acquire();
            this.mHoldingDisplaySuspendBlocker = true;
            this.mScreenOnBlocker = new ScreenOnBlockerImpl();
            this.mDisplayBlanker = new DisplayBlankerImpl();
            this.mWakefulness = 1;
        }
        this.nativeInit();
        PowerManagerService.nativeSetPowerState(true, true);
    }

    public void init(Context context, LightsService ls, ActivityManagerService am, BatteryService bs, IBatteryStats bss, IAppOpsService appOps, DisplayManagerService dm) {
        this.mContext = context;
        this.mLightsService = ls;
        this.mBatteryService = bs;
        this.mBatteryStats = bss;
        this.mAppOps = appOps;
        this.mDisplayManagerService = dm;
        this.mHandlerThread = new HandlerThread(TAG);
        this.mHandlerThread.start();
        this.mHandler = new PowerManagerHandler(this.mHandlerThread.getLooper());
        Watchdog.getInstance().addMonitor(this);
        Watchdog.getInstance().addThread(this.mHandler, this.mHandlerThread.getName());
        this.mDisplayBlanker.unblankAllDisplays();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolicy(WindowManagerPolicy policy) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPolicy = policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady(TwilightService twilight, DreamManagerService dreamManager) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemReady = true;
            this.mDreamManager = dreamManager;
            PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
            this.mScreenBrightnessSettingMinimum = pm.getMinimumScreenBrightnessSetting();
            this.mScreenBrightnessSettingMaximum = pm.getMaximumScreenBrightnessSetting();
            this.mScreenBrightnessSettingDefault = pm.getDefaultScreenBrightnessSetting();
            SystemSensorManager sensorManager = new SystemSensorManager(this.mContext, this.mHandler.getLooper());
            this.mNotifier = new Notifier(Looper.getMainLooper(), this.mContext, this.mBatteryStats, this.mAppOps, this.createSuspendBlockerLocked("PowerManagerService.Broadcasts"), this.mScreenOnBlocker, this.mPolicy);
            this.mDisplayPowerController = new DisplayPowerController(this.mHandler.getLooper(), this.mContext, this.mNotifier, this.mLightsService, twilight, sensorManager, this.mDisplayManagerService, this.mDisplaySuspendBlocker, this.mDisplayBlanker, this.mDisplayPowerControllerCallbacks, this.mHandler);
            this.mWirelessChargerDetector = new WirelessChargerDetector(sensorManager, this.createSuspendBlockerLocked("PowerManagerService.WirelessChargerDetector"), this.mHandler);
            this.mSettingsObserver = new SettingsObserver(this.mHandler);
            this.mAttentionLight = this.mLightsService.getLight(5);
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.BATTERY_CHANGED");
            this.mContext.registerReceiver(new BatteryReceiver(), filter, null, this.mHandler);
            filter = new IntentFilter();
            filter.addAction("android.intent.action.BOOT_COMPLETED");
            this.mContext.registerReceiver(new BootCompletedReceiver(), filter, null, this.mHandler);
            filter = new IntentFilter();
            filter.addAction("android.intent.action.DREAMING_STARTED");
            filter.addAction("android.intent.action.DREAMING_STOPPED");
            this.mContext.registerReceiver(new DreamReceiver(), filter, null, this.mHandler);
            filter = new IntentFilter();
            filter.addAction("android.intent.action.USER_SWITCHED");
            this.mContext.registerReceiver(new UserSwitchedReceiver(), filter, null, this.mHandler);
            filter = new IntentFilter();
            filter.addAction("android.intent.action.DOCK_EVENT");
            this.mContext.registerReceiver(new DockReceiver(), filter, null, this.mHandler);
            ContentResolver resolver = this.mContext.getContentResolver();
            resolver.registerContentObserver(Settings.Secure.getUriFor("screensaver_enabled"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("screensaver_activate_on_sleep"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("screensaver_activate_on_dock"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("screen_off_timeout"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.Global.getUriFor("stay_on_while_plugged_in"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("screen_brightness"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("screen_brightness_mode"), false, this.mSettingsObserver, -1);
            this.readConfigurationLocked();
            this.updateSettingsLocked();
            this.mDirty |= 0x100;
            this.updatePowerStateLocked();
        }
    }

    private void readConfigurationLocked() {
        Resources resources = this.mContext.getResources();
        this.mWakeUpWhenPluggedOrUnpluggedConfig = resources.getBoolean(0x111001C);
        this.mSuspendWhenScreenOffDueToProximityConfig = resources.getBoolean(17891364);
        this.mDreamsSupportedConfig = resources.getBoolean(17891401);
        this.mDreamsEnabledByDefaultConfig = resources.getBoolean(17891402);
        this.mDreamsActivatedOnSleepByDefaultConfig = resources.getBoolean(17891404);
        this.mDreamsActivatedOnDockByDefaultConfig = resources.getBoolean(17891403);
    }

    private void updateSettingsLocked() {
        ContentResolver resolver = this.mContext.getContentResolver();
        this.mDreamsEnabledSetting = Settings.Secure.getIntForUser(resolver, "screensaver_enabled", this.mDreamsEnabledByDefaultConfig ? 1 : 0, -2) != 0;
        this.mDreamsActivateOnSleepSetting = Settings.Secure.getIntForUser(resolver, "screensaver_activate_on_sleep", this.mDreamsActivatedOnSleepByDefaultConfig ? 1 : 0, -2) != 0;
        this.mDreamsActivateOnDockSetting = Settings.Secure.getIntForUser(resolver, "screensaver_activate_on_dock", this.mDreamsActivatedOnDockByDefaultConfig ? 1 : 0, -2) != 0;
        this.mScreenOffTimeoutSetting = Settings.System.getIntForUser(resolver, "screen_off_timeout", 15000, -2);
        this.mStayOnWhilePluggedInSetting = Settings.Global.getInt(resolver, "stay_on_while_plugged_in", 1);
        int oldScreenBrightnessSetting = this.mScreenBrightnessSetting;
        this.mScreenBrightnessSetting = Settings.System.getIntForUser(resolver, "screen_brightness", this.mScreenBrightnessSettingDefault, -2);
        if (oldScreenBrightnessSetting != this.mScreenBrightnessSetting) {
            this.mTemporaryScreenBrightnessSettingOverride = -1;
        }
        float oldScreenAutoBrightnessAdjustmentSetting = this.mScreenAutoBrightnessAdjustmentSetting;
        this.mScreenAutoBrightnessAdjustmentSetting = Settings.System.getFloatForUser(resolver, "screen_auto_brightness_adj", 0.0f, -2);
        if (oldScreenAutoBrightnessAdjustmentSetting != this.mScreenAutoBrightnessAdjustmentSetting) {
            this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride = Float.NaN;
        }
        this.mScreenBrightnessModeSetting = Settings.System.getIntForUser(resolver, "screen_brightness_mode", 0, -2);
        this.mDirty |= 0x20;
    }

    private void handleSettingsChangedLocked() {
        this.updateSettingsLocked();
        this.updatePowerStateLocked();
    }

    public void acquireWakeLockWithUid(IBinder lock, int flags, String tag, String packageName, int uid) {
        this.acquireWakeLock(lock, flags, tag, packageName, new WorkSource(uid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireWakeLock(IBinder lock, int flags, String tag, String packageName, WorkSource ws) {
        if (lock == null) {
            throw new IllegalArgumentException("lock must not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("packageName must not be null");
        }
        PowerManager.validateWakeLockParameters(flags, tag);
        this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
        if (ws != null && ws.size() != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.UPDATE_DEVICE_STATS", null);
        } else {
            ws = null;
        }
        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        long ident = Binder.clearCallingIdentity();
        try {
            this.acquireWakeLockInternal(lock, flags, tag, packageName, ws, uid, pid);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireWakeLockInternal(IBinder lock, int flags, String tag, String packageName, WorkSource ws, int uid, int pid) {
        Object object = this.mLock;
        synchronized (object) {
            WakeLock wakeLock;
            int index = this.findWakeLockIndexLocked(lock);
            if (index >= 0) {
                wakeLock = this.mWakeLocks.get(index);
                if (!wakeLock.hasSameProperties(flags, tag, ws, uid, pid)) {
                    this.notifyWakeLockReleasedLocked(wakeLock);
                    wakeLock.updateProperties(flags, tag, packageName, ws, uid, pid);
                    this.notifyWakeLockAcquiredLocked(wakeLock);
                }
            } else {
                wakeLock = new WakeLock(lock, flags, tag, packageName, ws, uid, pid);
                try {
                    lock.linkToDeath(wakeLock, 0);
                }
                catch (RemoteException ex) {
                    throw new IllegalArgumentException("Wake lock is already dead.");
                }
                this.notifyWakeLockAcquiredLocked(wakeLock);
                this.mWakeLocks.add(wakeLock);
            }
            this.applyWakeLockFlagsOnAcquireLocked(wakeLock);
            this.mDirty |= 1;
            this.updatePowerStateLocked();
        }
    }

    private static boolean isScreenLock(WakeLock wakeLock) {
        switch (wakeLock.mFlags & 0xFFFF) {
            case 6: 
            case 10: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    private void applyWakeLockFlagsOnAcquireLocked(WakeLock wakeLock) {
        if ((wakeLock.mFlags & 0x10000000) != 0 && PowerManagerService.isScreenLock(wakeLock)) {
            this.wakeUpNoUpdateLocked(SystemClock.uptimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWakeLock(IBinder lock, int flags) {
        if (lock == null) {
            throw new IllegalArgumentException("lock must not be null");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
        long ident = Binder.clearCallingIdentity();
        try {
            this.releaseWakeLockInternal(lock, flags);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWakeLockInternal(IBinder lock, int flags) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findWakeLockIndexLocked(lock);
            if (index < 0) {
                return;
            }
            WakeLock wakeLock = this.mWakeLocks.get(index);
            this.mWakeLocks.remove(index);
            this.notifyWakeLockReleasedLocked(wakeLock);
            wakeLock.mLock.unlinkToDeath(wakeLock, 0);
            if ((flags & 1) != 0) {
                this.mRequestWaitForNegativeProximity = true;
            }
            this.applyWakeLockFlagsOnReleaseLocked(wakeLock);
            this.mDirty |= 1;
            this.updatePowerStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWakeLockDeath(WakeLock wakeLock) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mWakeLocks.indexOf(wakeLock);
            if (index < 0) {
                return;
            }
            this.mWakeLocks.remove(index);
            this.notifyWakeLockReleasedLocked(wakeLock);
            this.applyWakeLockFlagsOnReleaseLocked(wakeLock);
            this.mDirty |= 1;
            this.updatePowerStateLocked();
        }
    }

    private void applyWakeLockFlagsOnReleaseLocked(WakeLock wakeLock) {
        if ((wakeLock.mFlags & 0x20000000) != 0 && PowerManagerService.isScreenLock(wakeLock)) {
            this.userActivityNoUpdateLocked(SystemClock.uptimeMillis(), 0, 1, wakeLock.mOwnerUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWakeLockWorkSource(IBinder lock, WorkSource ws) {
        if (lock == null) {
            throw new IllegalArgumentException("lock must not be null");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
        if (ws != null && ws.size() != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.UPDATE_DEVICE_STATS", null);
        } else {
            ws = null;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.updateWakeLockWorkSourceInternal(lock, ws);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWakeLockWorkSourceInternal(IBinder lock, WorkSource ws) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findWakeLockIndexLocked(lock);
            if (index < 0) {
                throw new IllegalArgumentException("Wake lock not active");
            }
            WakeLock wakeLock = this.mWakeLocks.get(index);
            if (!wakeLock.hasSameWorkSource(ws)) {
                this.notifyWakeLockReleasedLocked(wakeLock);
                wakeLock.updateWorkSource(ws);
                this.notifyWakeLockAcquiredLocked(wakeLock);
            }
        }
    }

    private int findWakeLockIndexLocked(IBinder lock) {
        int count = this.mWakeLocks.size();
        for (int i = 0; i < count; ++i) {
            if (this.mWakeLocks.get((int)i).mLock != lock) continue;
            return i;
        }
        return -1;
    }

    private void notifyWakeLockAcquiredLocked(WakeLock wakeLock) {
        if (this.mSystemReady) {
            wakeLock.mNotifiedAcquired = true;
            this.mNotifier.onWakeLockAcquired(wakeLock.mFlags, wakeLock.mTag, wakeLock.mPackageName, wakeLock.mOwnerUid, wakeLock.mOwnerPid, wakeLock.mWorkSource);
        }
    }

    private void notifyWakeLockReleasedLocked(WakeLock wakeLock) {
        if (this.mSystemReady && wakeLock.mNotifiedAcquired) {
            wakeLock.mNotifiedAcquired = false;
            this.mNotifier.onWakeLockReleased(wakeLock.mFlags, wakeLock.mTag, wakeLock.mPackageName, wakeLock.mOwnerUid, wakeLock.mOwnerPid, wakeLock.mWorkSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWakeLockLevelSupported(int level) {
        long ident = Binder.clearCallingIdentity();
        try {
            boolean bl = this.isWakeLockLevelSupportedInternal(level);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWakeLockLevelSupportedInternal(int level) {
        Object object = this.mLock;
        synchronized (object) {
            switch (level) {
                case 1: 
                case 6: 
                case 10: 
                case 26: {
                    return true;
                }
                case 32: {
                    return this.mSystemReady && this.mDisplayPowerController.isProximitySensorAvailable();
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userActivity(long eventTime, int event, int flags) {
        long now = SystemClock.uptimeMillis();
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DEVICE_POWER") != 0) {
            Object object = this.mLock;
            synchronized (object) {
                if (now >= this.mLastWarningAboutUserActivityPermission + 300000L) {
                    this.mLastWarningAboutUserActivityPermission = now;
                    Slog.w(TAG, "Ignoring call to PowerManager.userActivity() because the caller does not have DEVICE_POWER permission.  Please fix your app!   pid=" + Binder.getCallingPid() + " uid=" + Binder.getCallingUid());
                }
            }
            return;
        }
        if (eventTime > SystemClock.uptimeMillis()) {
            throw new IllegalArgumentException("event time must not be in the future");
        }
        int uid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        try {
            this.userActivityInternal(eventTime, event, flags, uid);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void userActivityFromNative(long eventTime, int event, int flags) {
        this.userActivityInternal(eventTime, event, flags, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userActivityInternal(long eventTime, int event, int flags, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.userActivityNoUpdateLocked(eventTime, event, flags, uid)) {
                this.updatePowerStateLocked();
            }
        }
    }

    private boolean userActivityNoUpdateLocked(long eventTime, int event, int flags, int uid) {
        if (eventTime < this.mLastSleepTime || eventTime < this.mLastWakeTime || this.mWakefulness == 0 || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        this.mNotifier.onUserActivity(event, uid);
        if ((flags & 1) != 0) {
            if (eventTime > this.mLastUserActivityTimeNoChangeLights && eventTime > this.mLastUserActivityTime) {
                this.mLastUserActivityTimeNoChangeLights = eventTime;
                this.mDirty |= 4;
                return true;
            }
        } else if (eventTime > this.mLastUserActivityTime) {
            this.mLastUserActivityTime = eventTime;
            this.mDirty |= 4;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp(long eventTime) {
        if (eventTime > SystemClock.uptimeMillis()) {
            throw new IllegalArgumentException("event time must not be in the future");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        long ident = Binder.clearCallingIdentity();
        try {
            this.wakeUpInternal(eventTime);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void wakeUpFromNative(long eventTime) {
        this.wakeUpInternal(eventTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpInternal(long eventTime) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.wakeUpNoUpdateLocked(eventTime)) {
                this.updatePowerStateLocked();
            }
        }
    }

    private boolean wakeUpNoUpdateLocked(long eventTime) {
        if (eventTime < this.mLastSleepTime || this.mWakefulness == 1 || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        switch (this.mWakefulness) {
            case 0: {
                Slog.i(TAG, "Waking up from sleep...");
                this.sendPendingNotificationsLocked();
                this.mNotifier.onWakeUpStarted();
                this.mSendWakeUpFinishedNotificationWhenReady = true;
                break;
            }
            case 3: {
                Slog.i(TAG, "Waking up from dream...");
                break;
            }
            case 2: {
                Slog.i(TAG, "Waking up from nap...");
            }
        }
        this.mLastWakeTime = eventTime;
        this.mWakefulness = 1;
        this.mDirty |= 2;
        this.userActivityNoUpdateLocked(eventTime, 0, 0, 1000);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goToSleep(long eventTime, int reason) {
        if (eventTime > SystemClock.uptimeMillis()) {
            throw new IllegalArgumentException("event time must not be in the future");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        long ident = Binder.clearCallingIdentity();
        try {
            this.goToSleepInternal(eventTime, reason);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void goToSleepFromNative(long eventTime, int reason) {
        this.goToSleepInternal(eventTime, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goToSleepInternal(long eventTime, int reason) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.goToSleepNoUpdateLocked(eventTime, reason)) {
                this.updatePowerStateLocked();
            }
        }
    }

    private boolean goToSleepNoUpdateLocked(long eventTime, int reason) {
        if (eventTime < this.mLastWakeTime || this.mWakefulness == 0 || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        switch (reason) {
            case 1: {
                Slog.i(TAG, "Going to sleep due to device administration policy...");
                break;
            }
            case 2: {
                Slog.i(TAG, "Going to sleep due to screen timeout...");
                break;
            }
            default: {
                Slog.i(TAG, "Going to sleep by user request...");
                reason = 0;
            }
        }
        this.sendPendingNotificationsLocked();
        this.mNotifier.onGoToSleepStarted(reason);
        this.mSendGoToSleepFinishedNotificationWhenReady = true;
        this.mLastSleepTime = eventTime;
        this.mDirty |= 2;
        this.mWakefulness = 0;
        int numWakeLocksCleared = 0;
        int numWakeLocks = this.mWakeLocks.size();
        for (int i = 0; i < numWakeLocks; ++i) {
            WakeLock wakeLock = this.mWakeLocks.get(i);
            switch (wakeLock.mFlags & 0xFFFF) {
                case 6: 
                case 10: 
                case 26: {
                    ++numWakeLocksCleared;
                }
            }
        }
        EventLog.writeEvent(2724, numWakeLocksCleared);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nap(long eventTime) {
        if (eventTime > SystemClock.uptimeMillis()) {
            throw new IllegalArgumentException("event time must not be in the future");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        long ident = Binder.clearCallingIdentity();
        try {
            this.napInternal(eventTime);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void napInternal(long eventTime) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.napNoUpdateLocked(eventTime)) {
                this.updatePowerStateLocked();
            }
        }
    }

    private boolean napNoUpdateLocked(long eventTime) {
        if (eventTime < this.mLastWakeTime || this.mWakefulness != 1 || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        Slog.i(TAG, "Nap time...");
        this.mDirty |= 2;
        this.mWakefulness = 2;
        return true;
    }

    private void updatePowerStateLocked() {
        int dirtyPhase1;
        if (!this.mSystemReady || this.mDirty == 0) {
            return;
        }
        this.updateIsPoweredLocked(this.mDirty);
        this.updateStayOnLocked(this.mDirty);
        long now = SystemClock.uptimeMillis();
        int dirtyPhase2 = 0;
        do {
            dirtyPhase1 = this.mDirty;
            dirtyPhase2 |= dirtyPhase1;
            this.mDirty = 0;
            this.updateWakeLockSummaryLocked(dirtyPhase1);
            this.updateUserActivitySummaryLocked(now, dirtyPhase1);
        } while (this.updateWakefulnessLocked(dirtyPhase1));
        this.updateDreamLocked(dirtyPhase2);
        this.updateDisplayPowerStateLocked(dirtyPhase2);
        if (this.mDisplayReady) {
            this.sendPendingNotificationsLocked();
        }
        this.updateSuspendBlockerLocked();
    }

    private void sendPendingNotificationsLocked() {
        if (this.mSendWakeUpFinishedNotificationWhenReady) {
            this.mSendWakeUpFinishedNotificationWhenReady = false;
            this.mNotifier.onWakeUpFinished();
        }
        if (this.mSendGoToSleepFinishedNotificationWhenReady) {
            this.mSendGoToSleepFinishedNotificationWhenReady = false;
            this.mNotifier.onGoToSleepFinished();
        }
    }

    private void updateIsPoweredLocked(int dirty) {
        if ((dirty & 0x100) != 0) {
            boolean wasPowered = this.mIsPowered;
            int oldPlugType = this.mPlugType;
            this.mIsPowered = this.mBatteryService.isPowered(7);
            this.mPlugType = this.mBatteryService.getPlugType();
            this.mBatteryLevel = this.mBatteryService.getBatteryLevel();
            if (wasPowered != this.mIsPowered || oldPlugType != this.mPlugType) {
                this.mDirty |= 0x40;
                boolean dockedOnWirelessCharger = this.mWirelessChargerDetector.update(this.mIsPowered, this.mPlugType, this.mBatteryLevel);
                long now = SystemClock.uptimeMillis();
                if (this.shouldWakeUpWhenPluggedOrUnpluggedLocked(wasPowered, oldPlugType, dockedOnWirelessCharger)) {
                    this.wakeUpNoUpdateLocked(now);
                }
                this.userActivityNoUpdateLocked(now, 0, 0, 1000);
                if (dockedOnWirelessCharger) {
                    this.mNotifier.onWirelessChargingStarted();
                }
            }
        }
    }

    private boolean shouldWakeUpWhenPluggedOrUnpluggedLocked(boolean wasPowered, int oldPlugType, boolean dockedOnWirelessCharger) {
        if (!this.mWakeUpWhenPluggedOrUnpluggedConfig) {
            return false;
        }
        if (wasPowered && !this.mIsPowered && oldPlugType == 4) {
            return false;
        }
        if (!wasPowered && this.mIsPowered && this.mPlugType == 4 && !dockedOnWirelessCharger) {
            return false;
        }
        return !this.mIsPowered || this.mWakefulness != 2 && this.mWakefulness != 3;
    }

    private void updateStayOnLocked(int dirty) {
        if ((dirty & 0x120) != 0) {
            boolean wasStayOn = this.mStayOn;
            this.mStayOn = this.mStayOnWhilePluggedInSetting != 0 && !this.isMaximumScreenOffTimeoutFromDeviceAdminEnforcedLocked() ? this.mBatteryService.isPowered(this.mStayOnWhilePluggedInSetting) : false;
            if (this.mStayOn != wasStayOn) {
                this.mDirty |= 0x80;
            }
        }
    }

    private void updateWakeLockSummaryLocked(int dirty) {
        if ((dirty & 3) != 0) {
            this.mWakeLockSummary = 0;
            int numWakeLocks = this.mWakeLocks.size();
            block7: for (int i = 0; i < numWakeLocks; ++i) {
                WakeLock wakeLock = this.mWakeLocks.get(i);
                switch (wakeLock.mFlags & 0xFFFF) {
                    case 1: {
                        this.mWakeLockSummary |= 1;
                        continue block7;
                    }
                    case 26: {
                        if (this.mWakefulness == 0) continue block7;
                        this.mWakeLockSummary |= 0xB;
                        if (this.mWakefulness != 1) continue block7;
                        this.mWakeLockSummary |= 0x20;
                        continue block7;
                    }
                    case 10: {
                        if (this.mWakefulness == 0) continue block7;
                        this.mWakeLockSummary |= 3;
                        if (this.mWakefulness != 1) continue block7;
                        this.mWakeLockSummary |= 0x20;
                        continue block7;
                    }
                    case 6: {
                        if (this.mWakefulness == 0) continue block7;
                        this.mWakeLockSummary |= 5;
                        if (this.mWakefulness != 1) continue block7;
                        this.mWakeLockSummary |= 0x20;
                        continue block7;
                    }
                    case 32: {
                        if (this.mWakefulness == 0) continue block7;
                        this.mWakeLockSummary |= 0x10;
                    }
                }
            }
        }
    }

    private void updateUserActivitySummaryLocked(long now, int dirty) {
        if ((dirty & 0x26) != 0) {
            this.mHandler.removeMessages(1);
            long nextTimeout = 0L;
            if (this.mWakefulness != 0) {
                int screenOffTimeout = this.getScreenOffTimeoutLocked();
                int screenDimDuration = this.getScreenDimDurationLocked(screenOffTimeout);
                this.mUserActivitySummary = 0;
                if (this.mLastUserActivityTime >= this.mLastWakeTime) {
                    nextTimeout = this.mLastUserActivityTime + (long)screenOffTimeout - (long)screenDimDuration;
                    if (now < nextTimeout) {
                        this.mUserActivitySummary |= 1;
                    } else {
                        nextTimeout = this.mLastUserActivityTime + (long)screenOffTimeout;
                        if (now < nextTimeout) {
                            this.mUserActivitySummary |= 2;
                        }
                    }
                }
                if (this.mUserActivitySummary == 0 && this.mLastUserActivityTimeNoChangeLights >= this.mLastWakeTime && now < (nextTimeout = this.mLastUserActivityTimeNoChangeLights + (long)screenOffTimeout) && this.mDisplayPowerRequest.screenState != 0) {
                    int n = this.mUserActivitySummary = this.mDisplayPowerRequest.screenState == 2 ? 1 : 2;
                }
                if (this.mUserActivitySummary != 0) {
                    Message msg = this.mHandler.obtainMessage(1);
                    msg.setAsynchronous(true);
                    this.mHandler.sendMessageAtTime(msg, nextTimeout);
                }
            } else {
                this.mUserActivitySummary = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUserActivityTimeout() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDirty |= 4;
            this.updatePowerStateLocked();
        }
    }

    private int getScreenOffTimeoutLocked() {
        int timeout = this.mScreenOffTimeoutSetting;
        if (this.isMaximumScreenOffTimeoutFromDeviceAdminEnforcedLocked()) {
            timeout = Math.min(timeout, this.mMaximumScreenOffTimeoutFromDeviceAdmin);
        }
        if (this.mUserActivityTimeoutOverrideFromWindowManager >= 0L) {
            timeout = (int)Math.min((long)timeout, this.mUserActivityTimeoutOverrideFromWindowManager);
        }
        return Math.max(timeout, 10000);
    }

    private int getScreenDimDurationLocked(int screenOffTimeout) {
        return Math.min(7000, (int)((float)screenOffTimeout * 0.2f));
    }

    private boolean updateWakefulnessLocked(int dirty) {
        boolean changed = false;
        if ((dirty & 0xA97) != 0 && this.mWakefulness == 1 && this.isItBedTimeYetLocked()) {
            long time = SystemClock.uptimeMillis();
            changed = this.shouldNapAtBedTimeLocked() ? this.napNoUpdateLocked(time) : this.goToSleepNoUpdateLocked(time, 2);
        }
        return changed;
    }

    private boolean shouldNapAtBedTimeLocked() {
        return this.mDreamsActivateOnSleepSetting || this.mDreamsActivateOnDockSetting && this.mDockState != 0;
    }

    private boolean isItBedTimeYetLocked() {
        return this.mBootCompleted && !this.isBeingKeptAwakeLocked();
    }

    private boolean isBeingKeptAwakeLocked() {
        return this.mStayOn || this.mProximityPositive || (this.mWakeLockSummary & 0x20) != 0 || (this.mUserActivitySummary & 3) != 0;
    }

    private void updateDreamLocked(int dirty) {
        if ((dirty & 0x3F7) != 0) {
            this.scheduleSandmanLocked();
        }
    }

    private void scheduleSandmanLocked() {
        if (!this.mSandmanScheduled) {
            this.mSandmanScheduled = true;
            Message msg = this.mHandler.obtainMessage(2);
            msg.setAsynchronous(true);
            this.mHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSandman() {
        boolean startDreaming = false;
        Object object = this.mLock;
        synchronized (object) {
            this.mSandmanScheduled = false;
            boolean canDream = this.canDreamLocked();
            if (canDream && this.mWakefulness == 2) {
                startDreaming = true;
            }
        }
        boolean isDreaming = false;
        if (this.mDreamManager != null) {
            if (startDreaming) {
                this.mDreamManager.startDream();
            }
            isDreaming = this.mDreamManager.isDreaming();
        }
        boolean continueDreaming = false;
        Object object2 = this.mLock;
        synchronized (object2) {
            if (isDreaming && this.canDreamLocked()) {
                if (this.mWakefulness == 2) {
                    this.mWakefulness = 3;
                    this.mDirty |= 2;
                    this.mBatteryLevelWhenDreamStarted = this.mBatteryLevel;
                    this.updatePowerStateLocked();
                    continueDreaming = true;
                } else if (this.mWakefulness == 3) {
                    if (!this.isBeingKeptAwakeLocked() && this.mBatteryLevel < this.mBatteryLevelWhenDreamStarted - 5) {
                        Slog.i(TAG, "Stopping dream because the battery appears to be draining faster than it is charging.  Battery level when dream started: " + this.mBatteryLevelWhenDreamStarted + "%.  " + "Battery level now: " + this.mBatteryLevel + "%.");
                    } else {
                        continueDreaming = true;
                    }
                }
            }
            if (!continueDreaming) {
                this.handleDreamFinishedLocked();
            }
        }
        if (this.mDreamManager != null && !continueDreaming) {
            this.mDreamManager.stopDream();
        }
    }

    private boolean canDreamLocked() {
        return this.mDreamsSupportedConfig && this.mDreamsEnabledSetting && this.mDisplayPowerRequest.screenState != 0 && this.mBootCompleted && (this.mIsPowered || this.isBeingKeptAwakeLocked());
    }

    private void handleDreamFinishedLocked() {
        if (this.mWakefulness == 2 || this.mWakefulness == 3) {
            if (this.isItBedTimeYetLocked()) {
                this.goToSleepNoUpdateLocked(SystemClock.uptimeMillis(), 2);
                this.updatePowerStateLocked();
            } else {
                this.wakeUpNoUpdateLocked(SystemClock.uptimeMillis());
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleScreenOnBlockerReleased() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDirty |= 0x400;
            this.updatePowerStateLocked();
        }
    }

    private void updateDisplayPowerStateLocked(int dirty) {
        if ((dirty & 0x43F) != 0) {
            boolean autoBrightness;
            int newScreenState = this.getDesiredScreenPowerStateLocked();
            if (newScreenState != this.mDisplayPowerRequest.screenState) {
                if (newScreenState == 0 && this.mDisplayPowerRequest.screenState != 0) {
                    this.mLastScreenOffEventElapsedRealTime = SystemClock.elapsedRealtime();
                }
                this.mDisplayPowerRequest.screenState = newScreenState;
                PowerManagerService.nativeSetPowerState(newScreenState != 0, newScreenState == 2);
            }
            int screenBrightness = this.mScreenBrightnessSettingDefault;
            float screenAutoBrightnessAdjustment = 0.0f;
            boolean bl = autoBrightness = this.mScreenBrightnessModeSetting == 1;
            if (PowerManagerService.isValidBrightness(this.mScreenBrightnessOverrideFromWindowManager)) {
                screenBrightness = this.mScreenBrightnessOverrideFromWindowManager;
                autoBrightness = false;
            } else if (PowerManagerService.isValidBrightness(this.mTemporaryScreenBrightnessSettingOverride)) {
                screenBrightness = this.mTemporaryScreenBrightnessSettingOverride;
            } else if (PowerManagerService.isValidBrightness(this.mScreenBrightnessSetting)) {
                screenBrightness = this.mScreenBrightnessSetting;
            }
            if (autoBrightness) {
                screenBrightness = this.mScreenBrightnessSettingDefault;
                if (PowerManagerService.isValidAutoBrightnessAdjustment(this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride)) {
                    screenAutoBrightnessAdjustment = this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride;
                } else if (PowerManagerService.isValidAutoBrightnessAdjustment(this.mScreenAutoBrightnessAdjustmentSetting)) {
                    screenAutoBrightnessAdjustment = this.mScreenAutoBrightnessAdjustmentSetting;
                }
            }
            screenBrightness = Math.max(Math.min(screenBrightness, this.mScreenBrightnessSettingMaximum), this.mScreenBrightnessSettingMinimum);
            screenAutoBrightnessAdjustment = Math.max(Math.min(screenAutoBrightnessAdjustment, 1.0f), -1.0f);
            this.mDisplayPowerRequest.screenBrightness = screenBrightness;
            this.mDisplayPowerRequest.screenAutoBrightnessAdjustment = screenAutoBrightnessAdjustment;
            this.mDisplayPowerRequest.useAutoBrightness = autoBrightness;
            this.mDisplayPowerRequest.useProximitySensor = this.shouldUseProximitySensorLocked();
            this.mDisplayPowerRequest.blockScreenOn = this.mScreenOnBlocker.isHeld();
            this.mDisplayReady = this.mDisplayPowerController.requestPowerState(this.mDisplayPowerRequest, this.mRequestWaitForNegativeProximity);
            this.mRequestWaitForNegativeProximity = false;
        }
    }

    private static boolean isValidBrightness(int value) {
        return value >= 0 && value <= 255;
    }

    private static boolean isValidAutoBrightnessAdjustment(float value) {
        return value >= -1.0f && value <= 1.0f;
    }

    private int getDesiredScreenPowerStateLocked() {
        if (this.mWakefulness == 0) {
            return 0;
        }
        if ((this.mWakeLockSummary & 2) != 0 || (this.mUserActivitySummary & 1) != 0 || !this.mBootCompleted) {
            return 2;
        }
        return 1;
    }

    private boolean shouldUseProximitySensorLocked() {
        return (this.mWakeLockSummary & 0x10) != 0;
    }

    private void updateSuspendBlockerLocked() {
        boolean needWakeLockSuspendBlocker = (this.mWakeLockSummary & 1) != 0;
        boolean needDisplaySuspendBlocker = this.needDisplaySuspendBlocker();
        if (needWakeLockSuspendBlocker && !this.mHoldingWakeLockSuspendBlocker) {
            this.mWakeLockSuspendBlocker.acquire();
            this.mHoldingWakeLockSuspendBlocker = true;
        }
        if (needDisplaySuspendBlocker && !this.mHoldingDisplaySuspendBlocker) {
            this.mDisplaySuspendBlocker.acquire();
            this.mHoldingDisplaySuspendBlocker = true;
        }
        if (!needWakeLockSuspendBlocker && this.mHoldingWakeLockSuspendBlocker) {
            this.mWakeLockSuspendBlocker.release();
            this.mHoldingWakeLockSuspendBlocker = false;
        }
        if (!needDisplaySuspendBlocker && this.mHoldingDisplaySuspendBlocker) {
            this.mDisplaySuspendBlocker.release();
            this.mHoldingDisplaySuspendBlocker = false;
        }
    }

    private boolean needDisplaySuspendBlocker() {
        if (!this.mDisplayReady) {
            return true;
        }
        return this.mDisplayPowerRequest.screenState != 0 && (!this.mDisplayPowerRequest.useProximitySensor || !this.mProximityPositive || !this.mSuspendWhenScreenOffDueToProximityConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScreenOn() {
        long ident = Binder.clearCallingIdentity();
        try {
            boolean bl = this.isScreenOnInternal();
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isScreenOnInternal() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mSystemReady || this.mDisplayPowerRequest.screenState != 0;
        }
    }

    private void handleBatteryStateChangedLocked() {
        this.mDirty |= 0x100;
        this.updatePowerStateLocked();
    }

    private void startWatchingForBootAnimationFinished() {
        this.mHandler.sendEmptyMessage(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfBootAnimationFinished() {
        if (SystemService.isRunning(BOOT_ANIMATION_SERVICE)) {
            this.mHandler.sendEmptyMessageDelayed(4, 200L);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mBootCompleted) {
                Slog.i(TAG, "Boot animation finished.");
                this.handleBootCompletedLocked();
            }
        }
    }

    private void handleBootCompletedLocked() {
        long now = SystemClock.uptimeMillis();
        this.mBootCompleted = true;
        this.mDirty |= 0x10;
        this.userActivityNoUpdateLocked(now, 0, 0, 1000);
        this.updatePowerStateLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot(boolean confirm, String reason, boolean wait) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REBOOT", null);
        long ident = Binder.clearCallingIdentity();
        try {
            this.shutdownOrRebootInternal(false, confirm, reason, wait);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean confirm, boolean wait) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REBOOT", null);
        long ident = Binder.clearCallingIdentity();
        try {
            this.shutdownOrRebootInternal(true, confirm, null, wait);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void shutdownOrRebootInternal(final boolean shutdown, final boolean confirm, final String reason, boolean wait) {
        if (this.mHandler == null || !this.mSystemReady) {
            throw new IllegalStateException("Too early to call shutdown() or reboot()");
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    if (shutdown) {
                        ShutdownThread.shutdown(PowerManagerService.this.mContext, confirm);
                    } else {
                        ShutdownThread.reboot(PowerManagerService.this.mContext, reason, confirm);
                    }
                }
            }
        };
        Message msg = Message.obtain((Handler)this.mHandler, runnable);
        msg.setAsynchronous(true);
        this.mHandler.sendMessage(msg);
        if (wait) {
            Runnable runnable2 = runnable;
            synchronized (runnable2) {
                while (true) {
                    try {
                        while (true) {
                            runnable.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crash(String message) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REBOOT", null);
        long ident = Binder.clearCallingIdentity();
        try {
            this.crashInternal(message);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void crashInternal(final String message) {
        Thread t = new Thread("PowerManagerService.crash()"){

            public void run() {
                throw new RuntimeException(message);
            }
        };
        try {
            t.start();
            t.join();
        }
        catch (InterruptedException e) {
            Log.wtf(TAG, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStayOnSetting(int val) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SETTINGS", null);
        long ident = Binder.clearCallingIdentity();
        try {
            this.setStayOnSettingInternal(val);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void setStayOnSettingInternal(int val) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "stay_on_while_plugged_in", val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumScreenOffTimeoutFromDeviceAdmin(int timeMs) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.setMaximumScreenOffTimeoutFromDeviceAdminInternal(timeMs);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMaximumScreenOffTimeoutFromDeviceAdminInternal(int timeMs) {
        Object object = this.mLock;
        synchronized (object) {
            this.mMaximumScreenOffTimeoutFromDeviceAdmin = timeMs;
            this.mDirty |= 0x20;
            this.updatePowerStateLocked();
        }
    }

    private boolean isMaximumScreenOffTimeoutFromDeviceAdminEnforcedLocked() {
        return this.mMaximumScreenOffTimeoutFromDeviceAdmin >= 0 && this.mMaximumScreenOffTimeoutFromDeviceAdmin < Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttentionLight(boolean on, int color2) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        long ident = Binder.clearCallingIdentity();
        try {
            this.setAttentionLightInternal(on, color2);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttentionLightInternal(boolean on, int color2) {
        LightsService.Light light;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mSystemReady) {
                return;
            }
            light = this.mAttentionLight;
        }
        light.setFlashing(color2, 2, on ? 3 : 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long timeSinceScreenWasLastOn() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDisplayPowerRequest.screenState != 0) {
                return 0L;
            }
            return SystemClock.elapsedRealtime() - this.mLastScreenOffEventElapsedRealTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScreenBrightnessOverrideFromWindowManager(int brightness) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        long ident = Binder.clearCallingIdentity();
        try {
            this.setScreenBrightnessOverrideFromWindowManagerInternal(brightness);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setScreenBrightnessOverrideFromWindowManagerInternal(int brightness) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mScreenBrightnessOverrideFromWindowManager != brightness) {
                this.mScreenBrightnessOverrideFromWindowManager = brightness;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    public void setButtonBrightnessOverrideFromWindowManager(int brightness) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserActivityTimeoutOverrideFromWindowManager(long timeoutMillis) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        long ident = Binder.clearCallingIdentity();
        try {
            this.setUserActivityTimeoutOverrideFromWindowManagerInternal(timeoutMillis);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserActivityTimeoutOverrideFromWindowManagerInternal(long timeoutMillis) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserActivityTimeoutOverrideFromWindowManager != timeoutMillis) {
                this.mUserActivityTimeoutOverrideFromWindowManager = timeoutMillis;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemporaryScreenBrightnessSettingOverride(int brightness) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        long ident = Binder.clearCallingIdentity();
        try {
            this.setTemporaryScreenBrightnessSettingOverrideInternal(brightness);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTemporaryScreenBrightnessSettingOverrideInternal(int brightness) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTemporaryScreenBrightnessSettingOverride != brightness) {
                this.mTemporaryScreenBrightnessSettingOverride = brightness;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemporaryScreenAutoBrightnessAdjustmentSettingOverride(float adj) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        long ident = Binder.clearCallingIdentity();
        try {
            this.setTemporaryScreenAutoBrightnessAdjustmentSettingOverrideInternal(adj);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTemporaryScreenAutoBrightnessAdjustmentSettingOverrideInternal(float adj) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride != adj) {
                this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride = adj;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    public static void lowLevelShutdown() {
        SystemProperties.set("sys.powerctl", "shutdown");
    }

    public static void lowLevelReboot(String reason) {
        if (reason == null) {
            reason = "";
        }
        SystemProperties.set("sys.powerctl", "reboot," + reason);
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor() {
        Object object = this.mLock;
        synchronized (object) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        WirelessChargerDetector wcd;
        DisplayPowerController dpc;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump PowerManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println("POWER MANAGER (dumpsys power)\n");
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Power Manager State:");
            pw.println("  mDirty=0x" + Integer.toHexString(this.mDirty));
            pw.println("  mWakefulness=" + PowerManagerService.wakefulnessToString(this.mWakefulness));
            pw.println("  mIsPowered=" + this.mIsPowered);
            pw.println("  mPlugType=" + this.mPlugType);
            pw.println("  mBatteryLevel=" + this.mBatteryLevel);
            pw.println("  mBatteryLevelWhenDreamStarted=" + this.mBatteryLevelWhenDreamStarted);
            pw.println("  mDockState=" + this.mDockState);
            pw.println("  mStayOn=" + this.mStayOn);
            pw.println("  mProximityPositive=" + this.mProximityPositive);
            pw.println("  mBootCompleted=" + this.mBootCompleted);
            pw.println("  mSystemReady=" + this.mSystemReady);
            pw.println("  mWakeLockSummary=0x" + Integer.toHexString(this.mWakeLockSummary));
            pw.println("  mUserActivitySummary=0x" + Integer.toHexString(this.mUserActivitySummary));
            pw.println("  mRequestWaitForNegativeProximity=" + this.mRequestWaitForNegativeProximity);
            pw.println("  mSandmanScheduled=" + this.mSandmanScheduled);
            pw.println("  mLastWakeTime=" + TimeUtils.formatUptime(this.mLastWakeTime));
            pw.println("  mLastSleepTime=" + TimeUtils.formatUptime(this.mLastSleepTime));
            pw.println("  mSendWakeUpFinishedNotificationWhenReady=" + this.mSendWakeUpFinishedNotificationWhenReady);
            pw.println("  mSendGoToSleepFinishedNotificationWhenReady=" + this.mSendGoToSleepFinishedNotificationWhenReady);
            pw.println("  mLastUserActivityTime=" + TimeUtils.formatUptime(this.mLastUserActivityTime));
            pw.println("  mLastUserActivityTimeNoChangeLights=" + TimeUtils.formatUptime(this.mLastUserActivityTimeNoChangeLights));
            pw.println("  mDisplayReady=" + this.mDisplayReady);
            pw.println("  mHoldingWakeLockSuspendBlocker=" + this.mHoldingWakeLockSuspendBlocker);
            pw.println("  mHoldingDisplaySuspendBlocker=" + this.mHoldingDisplaySuspendBlocker);
            pw.println();
            pw.println("Settings and Configuration:");
            pw.println("  mWakeUpWhenPluggedOrUnpluggedConfig=" + this.mWakeUpWhenPluggedOrUnpluggedConfig);
            pw.println("  mSuspendWhenScreenOffDueToProximityConfig=" + this.mSuspendWhenScreenOffDueToProximityConfig);
            pw.println("  mDreamsSupportedConfig=" + this.mDreamsSupportedConfig);
            pw.println("  mDreamsEnabledByDefaultConfig=" + this.mDreamsEnabledByDefaultConfig);
            pw.println("  mDreamsActivatedOnSleepByDefaultConfig=" + this.mDreamsActivatedOnSleepByDefaultConfig);
            pw.println("  mDreamsActivatedOnDockByDefaultConfig=" + this.mDreamsActivatedOnDockByDefaultConfig);
            pw.println("  mDreamsEnabledSetting=" + this.mDreamsEnabledSetting);
            pw.println("  mDreamsActivateOnSleepSetting=" + this.mDreamsActivateOnSleepSetting);
            pw.println("  mDreamsActivateOnDockSetting=" + this.mDreamsActivateOnDockSetting);
            pw.println("  mScreenOffTimeoutSetting=" + this.mScreenOffTimeoutSetting);
            pw.println("  mMaximumScreenOffTimeoutFromDeviceAdmin=" + this.mMaximumScreenOffTimeoutFromDeviceAdmin + " (enforced=" + this.isMaximumScreenOffTimeoutFromDeviceAdminEnforcedLocked() + ")");
            pw.println("  mStayOnWhilePluggedInSetting=" + this.mStayOnWhilePluggedInSetting);
            pw.println("  mScreenBrightnessSetting=" + this.mScreenBrightnessSetting);
            pw.println("  mScreenAutoBrightnessAdjustmentSetting=" + this.mScreenAutoBrightnessAdjustmentSetting);
            pw.println("  mScreenBrightnessModeSetting=" + this.mScreenBrightnessModeSetting);
            pw.println("  mScreenBrightnessOverrideFromWindowManager=" + this.mScreenBrightnessOverrideFromWindowManager);
            pw.println("  mUserActivityTimeoutOverrideFromWindowManager=" + this.mUserActivityTimeoutOverrideFromWindowManager);
            pw.println("  mTemporaryScreenBrightnessSettingOverride=" + this.mTemporaryScreenBrightnessSettingOverride);
            pw.println("  mTemporaryScreenAutoBrightnessAdjustmentSettingOverride=" + this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride);
            pw.println("  mScreenBrightnessSettingMinimum=" + this.mScreenBrightnessSettingMinimum);
            pw.println("  mScreenBrightnessSettingMaximum=" + this.mScreenBrightnessSettingMaximum);
            pw.println("  mScreenBrightnessSettingDefault=" + this.mScreenBrightnessSettingDefault);
            int screenOffTimeout = this.getScreenOffTimeoutLocked();
            int screenDimDuration = this.getScreenDimDurationLocked(screenOffTimeout);
            pw.println();
            pw.println("Screen off timeout: " + screenOffTimeout + " ms");
            pw.println("Screen dim duration: " + screenDimDuration + " ms");
            pw.println();
            pw.println("Wake Locks: size=" + this.mWakeLocks.size());
            for (WakeLock wl : this.mWakeLocks) {
                pw.println("  " + wl);
            }
            pw.println();
            pw.println("Suspend Blockers: size=" + this.mSuspendBlockers.size());
            for (SuspendBlocker sb : this.mSuspendBlockers) {
                pw.println("  " + sb);
            }
            pw.println();
            pw.println("Screen On Blocker: " + this.mScreenOnBlocker);
            pw.println();
            pw.println("Display Blanker: " + this.mDisplayBlanker);
            dpc = this.mDisplayPowerController;
            wcd = this.mWirelessChargerDetector;
        }
        if (dpc != null) {
            dpc.dump(pw);
        }
        if (wcd != null) {
            wcd.dump(pw);
        }
    }

    private SuspendBlocker createSuspendBlockerLocked(String name) {
        SuspendBlockerImpl suspendBlocker = new SuspendBlockerImpl(name);
        this.mSuspendBlockers.add(suspendBlocker);
        return suspendBlocker;
    }

    private static String wakefulnessToString(int wakefulness) {
        switch (wakefulness) {
            case 0: {
                return "Asleep";
            }
            case 1: {
                return "Awake";
            }
            case 3: {
                return "Dreaming";
            }
            case 2: {
                return "Napping";
            }
        }
        return Integer.toString(wakefulness);
    }

    private static WorkSource copyWorkSource(WorkSource workSource) {
        return workSource != null ? new WorkSource(workSource) : null;
    }

    private final class DisplayBlankerImpl
    implements DisplayBlanker {
        private boolean mBlanked;

        private DisplayBlankerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void blankAllDisplays() {
            DisplayBlankerImpl displayBlankerImpl = this;
            synchronized (displayBlankerImpl) {
                this.mBlanked = true;
                PowerManagerService.this.mDisplayManagerService.blankAllDisplaysFromPowerManager();
                PowerManagerService.nativeSetInteractive(false);
                PowerManagerService.nativeSetAutoSuspend(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unblankAllDisplays() {
            DisplayBlankerImpl displayBlankerImpl = this;
            synchronized (displayBlankerImpl) {
                PowerManagerService.nativeSetAutoSuspend(false);
                PowerManagerService.nativeSetInteractive(true);
                PowerManagerService.this.mDisplayManagerService.unblankAllDisplaysFromPowerManager();
                this.mBlanked = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            DisplayBlankerImpl displayBlankerImpl = this;
            synchronized (displayBlankerImpl) {
                return "blanked=" + this.mBlanked;
            }
        }
    }

    private final class ScreenOnBlockerImpl
    implements ScreenOnBlocker {
        private int mNestCount;

        private ScreenOnBlockerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isHeld() {
            ScreenOnBlockerImpl screenOnBlockerImpl = this;
            synchronized (screenOnBlockerImpl) {
                return this.mNestCount != 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            ScreenOnBlockerImpl screenOnBlockerImpl = this;
            synchronized (screenOnBlockerImpl) {
                ++this.mNestCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            ScreenOnBlockerImpl screenOnBlockerImpl = this;
            synchronized (screenOnBlockerImpl) {
                --this.mNestCount;
                if (this.mNestCount < 0) {
                    Log.wtf(PowerManagerService.TAG, "Screen on blocker was released without being acquired!", new Throwable());
                    this.mNestCount = 0;
                }
                if (this.mNestCount == 0) {
                    PowerManagerService.this.mHandler.sendEmptyMessage(3);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            ScreenOnBlockerImpl screenOnBlockerImpl = this;
            synchronized (screenOnBlockerImpl) {
                return "held=" + (this.mNestCount != 0) + ", mNestCount=" + this.mNestCount;
            }
        }
    }

    private final class SuspendBlockerImpl
    implements SuspendBlocker {
        private final String mName;
        private int mReferenceCount;

        public SuspendBlockerImpl(String name) {
            this.mName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.mReferenceCount != 0) {
                    Log.wtf(PowerManagerService.TAG, "Suspend blocker \"" + this.mName + "\" was finalized without being released!");
                    this.mReferenceCount = 0;
                    PowerManagerService.nativeReleaseSuspendBlocker(this.mName);
                }
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            SuspendBlockerImpl suspendBlockerImpl = this;
            synchronized (suspendBlockerImpl) {
                ++this.mReferenceCount;
                if (this.mReferenceCount == 1) {
                    PowerManagerService.nativeAcquireSuspendBlocker(this.mName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            SuspendBlockerImpl suspendBlockerImpl = this;
            synchronized (suspendBlockerImpl) {
                --this.mReferenceCount;
                if (this.mReferenceCount == 0) {
                    PowerManagerService.nativeReleaseSuspendBlocker(this.mName);
                } else if (this.mReferenceCount < 0) {
                    Log.wtf(PowerManagerService.TAG, "Suspend blocker \"" + this.mName + "\" was released without being acquired!", new Throwable());
                    this.mReferenceCount = 0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            SuspendBlockerImpl suspendBlockerImpl = this;
            synchronized (suspendBlockerImpl) {
                return this.mName + ": ref count=" + this.mReferenceCount;
            }
        }
    }

    private final class WakeLock
    implements IBinder.DeathRecipient {
        public final IBinder mLock;
        public int mFlags;
        public String mTag;
        public final String mPackageName;
        public WorkSource mWorkSource;
        public final int mOwnerUid;
        public final int mOwnerPid;
        public boolean mNotifiedAcquired;

        public WakeLock(IBinder lock, int flags, String tag, String packageName, WorkSource workSource, int ownerUid, int ownerPid) {
            this.mLock = lock;
            this.mFlags = flags;
            this.mTag = tag;
            this.mPackageName = packageName;
            this.mWorkSource = PowerManagerService.copyWorkSource(workSource);
            this.mOwnerUid = ownerUid;
            this.mOwnerPid = ownerPid;
        }

        public void binderDied() {
            PowerManagerService.this.handleWakeLockDeath(this);
        }

        public boolean hasSameProperties(int flags, String tag, WorkSource workSource, int ownerUid, int ownerPid) {
            return this.mFlags == flags && this.mTag.equals(tag) && this.hasSameWorkSource(workSource) && this.mOwnerUid == ownerUid && this.mOwnerPid == ownerPid;
        }

        public void updateProperties(int flags, String tag, String packageName, WorkSource workSource, int ownerUid, int ownerPid) {
            if (!this.mPackageName.equals(packageName)) {
                throw new IllegalStateException("Existing wake lock package name changed: " + this.mPackageName + " to " + packageName);
            }
            if (this.mOwnerUid != ownerUid) {
                throw new IllegalStateException("Existing wake lock uid changed: " + this.mOwnerUid + " to " + ownerUid);
            }
            if (this.mOwnerPid != ownerPid) {
                throw new IllegalStateException("Existing wake lock pid changed: " + this.mOwnerPid + " to " + ownerPid);
            }
            this.mFlags = flags;
            this.mTag = tag;
            this.updateWorkSource(workSource);
        }

        public boolean hasSameWorkSource(WorkSource workSource) {
            return Objects.equal(this.mWorkSource, workSource);
        }

        public void updateWorkSource(WorkSource workSource) {
            this.mWorkSource = PowerManagerService.copyWorkSource(workSource);
        }

        public String toString() {
            return this.getLockLevelString() + " '" + this.mTag + "'" + this.getLockFlagsString() + " (uid=" + this.mOwnerUid + ", pid=" + this.mOwnerPid + ", ws=" + this.mWorkSource + ")";
        }

        private String getLockLevelString() {
            switch (this.mFlags & 0xFFFF) {
                case 26: {
                    return "FULL_WAKE_LOCK                ";
                }
                case 10: {
                    return "SCREEN_BRIGHT_WAKE_LOCK       ";
                }
                case 6: {
                    return "SCREEN_DIM_WAKE_LOCK          ";
                }
                case 1: {
                    return "PARTIAL_WAKE_LOCK             ";
                }
                case 32: {
                    return "PROXIMITY_SCREEN_OFF_WAKE_LOCK";
                }
            }
            return "???                           ";
        }

        private String getLockFlagsString() {
            String result = "";
            if ((this.mFlags & 0x10000000) != 0) {
                result = result + " ACQUIRE_CAUSES_WAKEUP";
            }
            if ((this.mFlags & 0x20000000) != 0) {
                result = result + " ON_AFTER_RELEASE";
            }
            return result;
        }
    }

    private final class PowerManagerHandler
    extends Handler {
        public PowerManagerHandler(Looper looper) {
            super(looper, null, true);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PowerManagerService.this.handleUserActivityTimeout();
                    break;
                }
                case 2: {
                    PowerManagerService.this.handleSandman();
                    break;
                }
                case 3: {
                    PowerManagerService.this.handleScreenOnBlockerReleased();
                    break;
                }
                case 4: {
                    PowerManagerService.this.checkIfBootAnimationFinished();
                }
            }
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        public SettingsObserver(Handler handler) {
            super(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(boolean selfChange, Uri uri) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.handleSettingsChangedLocked();
            }
        }
    }

    private final class DockReceiver
    extends BroadcastReceiver {
        private DockReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                int dockState = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                if (PowerManagerService.this.mDockState != dockState) {
                    PowerManagerService.this.mDockState = dockState;
                    PowerManagerService.this.mDirty |= 2048;
                    PowerManagerService.this.updatePowerStateLocked();
                }
            }
        }
    }

    private final class UserSwitchedReceiver
    extends BroadcastReceiver {
        private UserSwitchedReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.handleSettingsChangedLocked();
            }
        }
    }

    private final class DreamReceiver
    extends BroadcastReceiver {
        private DreamReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.scheduleSandmanLocked();
            }
        }
    }

    private final class BootCompletedReceiver
    extends BroadcastReceiver {
        private BootCompletedReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            PowerManagerService.this.startWatchingForBootAnimationFinished();
        }
    }

    private final class BatteryReceiver
    extends BroadcastReceiver {
        private BatteryReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.handleBatteryStateChangedLocked();
            }
        }
    }
}

